use hahn;
pragma yson.DisableStrict;
pragma library("stability_common.sql");
import stability_common symbols $getPlatform;

$gogol_table = "//logs/strm-gogol-log/1d/" || $date;

$parse = ($x) -> {
    $parsed = Yson::ParseJson($x);
    return <|
        shownFrames: Yson::YPathInt64($parsed, "/shownFrames"),
        droppedFrames: Yson::YPathInt64($parsed, "/droppedFrames"),
        ts: Yson::YPathUint64($parsed, "/timestamp"),
        vt: Yson::YPathDouble($parsed, "/watchedTime"),
        st: Yson::YPathDouble($parsed, "/stalledTime"),
        is_muted: cast(Yson::YPathBool($parsed, "/isMuted") as String) ?? "unknown",
        is_visible: cast(Yson::YPathBool($parsed, "/isVisible") as String) ?? "unknown"
    |>
};

$w = ($x) -> (IF($x = "", null, $x));

$s1 = (
    select $parse(data) as data,
        videoContentId,
        service,
        vsid,
        userAgent,
        labels_from
    from $gogol_table
    where eventName = "PlayerAlive" and data like "%shownFrames%" and $w(videoContentId) is not null
);

$s2 = (
    select
        videoContentId,
        vsid,
        userAgent,
        service,
        labels_from,
        data.ts as ts,
        data.vt as vt,
        data.st as st,
        data.shownFrames as shownFrames,
        data.droppedFrames as droppedFrames,
        data.is_muted as is_muted,
        data.is_visible as is_visible
    from $s1
);

$device = ($string) -> (TryMember(Re2::Capture('(?:.\\()([^;]*)')($string), '_1', null) ?? "unknown");

$nwrap = ($x) -> (IF(Math::IsInf($x) or Math::IsNaN($x), null, $x));

$wrapGetPlatform = ($tup) -> ($getPlatform($tup.0, $tup.1));

$gr1 = (
    select
        vsid,
        video_content_id,
        is_muted,
        is_visible,
        $wrapGetPlatform(some(AsTuple(service, userAgent))) as platform,
        $device(some(userAgent)) ?? "-" as device,
        $nwrap(max(droppedFrames) / cast(max(shownFrames) as Double)) as dropped_rate,
        max(droppedFrames) as droppedFrames,
        max(shownFrames) as shownFrames,
        max(labels_from) ?? "-" as ref_from
    from $s2
    where videoContentId is not null
    group by vsid ?? "-" as vsid, videoContentId ?? "-" as video_content_id, is_muted, is_visible
);

$totalizePlatform = ($x) -> {
    return IF(
        $x.platform like "StreamPlayer_%",
        [AddMember(RemoveMember($x, "platform"), "platform", "_total_"),AddMember(RemoveMember($x, "platform"), "platform", "StreamPlayer_total") ],
        [AddMember(RemoveMember($x, "platform"), "platform", "_total_")],
    )
};

$totalize = ($row) -> {
    $result = [$row];
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "device"), "device", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "is_muted"), "is_muted", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "is_visible"), "is_visible", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "ref_from"), "ref_from", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListFlatMap($result, $totalizePlatform);
    $result = ListUnionAll($result, $add);
    return $result
};

$totalize_vcid = ($row) -> {
    $result = [$row];
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "device"), "device", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "ref_from"), "ref_from", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListFlatMap($result, $totalizePlatform);
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "video_content_id"), "video_content_id", "_total_")));
    $result = ListUnionAll($result, $add);
    return $result
};

$totalized = process $gr1 using $totalize(TableRow());

$gr2 = (
    select
        $date as fielddate,
        unwrap(device) as device,
        unwrap(platform) as platform,
        unwrap(is_muted) as is_muted,
        unwrap(is_visible) as is_visible,
        unwrap(ref_from) as ref_from,
        sum(droppedFrames) as dropped_frames,
        sum(shownFrames) as shown_frames,
        count(*) as sessions,
        percentile(dropped_rate, 0.25) as dropped_rate_p25,
        percentile(dropped_rate, 0.50) as dropped_rate_p50,
        percentile(dropped_rate, 0.75) as dropped_rate_p75,
        percentile(dropped_rate, 0.95) as dropped_rate_p95,
    from $totalized
    group by device, is_muted, is_visible, platform, ref_from
);

$totalized_vcid = (
    process (select * from $gr1 where is_visible == "true" and is_muted == "false")
    using $totalize_vcid(TableRow())
);

$gr2_vcid = (
    select
        $date as fielddate,
        unwrap(video_content_id) as video_content_id,
        unwrap(device) as device,
        unwrap(platform) as platform,
        unwrap(ref_from) as ref_from,
        sum(droppedFrames) as dropped_frames,
        sum(shownFrames) as shown_frames,
        count(*) as sessions,
        percentile(dropped_rate, 0.25) as dropped_rate_p25,
        percentile(dropped_rate, 0.50) as dropped_rate_p50,
        percentile(dropped_rate, 0.75) as dropped_rate_p75,
        percentile(dropped_rate, 0.95) as dropped_rate_p95,
    from $totalized_vcid
    group by device, video_content_id, platform, ref_from
);

upsert into stat.`Video/Others/Strm/MMA-5287-dropped-frames-v2/daily` erase by (fielddate)
select * from $gr2 where sessions >= 10000;

upsert into stat.`Video/Others/Strm/MMA-5287-dropped-frames-v2-vcid/daily` erase by (fielddate)
select * from $gr2_vcid where sessions >= 10000;
