use hahn;
pragma AnsiInForEmptyOrNullableItemsCollections;

$table = "//logs/strm-gogol-log/1d/" || $date;
$sessions_table = "//cubes/video-strm/" || $date || "/sessions";
$sessions = (
    select
        vsid,
        `UUID`,
        max(view_time) as tvt
    from $sessions_table
    group by vsid, `UUID`
);

$wrapZen = ($ref_from) -> (IF($ref_from like "zen:%", String::JoinFromList(
    ListTake(String::SplitToList($ref_from, ":"), 2), ":"
), $ref_from));

$native_ads = select distinct JoinKey from `//home/videolog/strm_meta/iron_branch/concat` where is_native_ad;

$tmp_ = (
    select
        streamUrl as stream_url,
        $wrapZen(labels_from) as labels_from,
        streamBucket as stream_bucket,
        Dsv::Parse(streamUrl, ",")["abcID"] as abc_id,
        streamUrl like "%ysign1=%" as is_signed,
        vsid,
        videoContentId
    from $table
    where eventName = "LoadSource"
);
$tmp = select * from $tmp_ where stream_bucket not in ("vh-canvas-converted", "unknown") and videoContentId not in $native_ads;
$join_tvt = (
    select t.*, tvt
    from $tmp as t
    left join any $sessions as s on (t.vsid = s.vsid and t.videoContentId = s.`UUID`)
);

$totalize = ($row) -> {
    $result = [$row];
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "labels_from"), "labels_from", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "stream_bucket"), "stream_bucket", "_total_")));
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "abc_id"), "abc_id", "_total_")));
    $result = ListUnionAll($result, $add);
    return $result
};

$totalized = process $join_tvt using $totalize(TableRow());

$grouped = (
    select
        $date as fielddate,
        stream_bucket,
        labels_from,
        abc_id,
        sum(tvt) as tvt,
        sum_if(tvt, is_signed) as signed_tvt,
        count(*) as playlists,
        count_if(is_signed) as signed_playlists
    from $totalized
    group by
        stream_bucket ?? "-" as stream_bucket,
        labels_from ?? "-" as labels_from,
        abc_id ?? "-" as abc_id
);

upsert into stat.`Video/Others/Strm/MMA-5352/daily` erase by (fielddate)
select * from $grouped;
