use hahn;
pragma yt.Pool = "@[pool]";
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

$BOT_GUID = "7250d595-1607-43cd-97ab-63618cdf8403";
$PARTY_PREFIX = "0/13/party%";

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_root = "@[output_root]";
$output_daily = $output_root || "/daily/" || $date_from || "_" || $date_to;
$output_hourly = $output_root || "/hourly/" || $date_from || "_" || $date_to;

$chats_tables_list = @[chats_tables_list];
$users_tables_list = @[users_tables_list];

$parseDateTime = ($x)->(DateTime::MakeDatetime(DateTime::Parse("%Y-%m-%d %H:%M:%S %Z")($x || " Europe/Moscow")));
$fielddateFormat = DateTime::Format("%Y-%m-%d %H:%M:%S");

$extractFd = ($path) -> (unwrap(ListReverse(String::SplitToList($path, "/"))[1]));

$normalizeTs = ($ts, $table_name) -> {
    $lb = DateTime::ToSeconds($parseDateTime(unwrap($table_name) || " 00:00:00"));
    $ub = DateTime::ToSeconds($parseDateTime(unwrap($table_name) || " 23:59:59"));
    $ts = CASE
    WHEN $ts < $lb THEN $lb
    WHEN $ts > $ub THEN $ub
    ELSE $ts
    END;
    RETURN $ts
};

$getFielddate = ($ts, $fdtype) -> {
    $ts = CAST($ts / 3600 * 3600 as Uint32);
    $tm = AddTimezone(DateTime::FromSeconds($ts), "Europe/Moscow");
    RETURN IF(
        $fdtype == "daily",
        SUBSTRING($fielddateFormat($tm), 0, 10),
        $fielddateFormat($tm)
    )
};

$fdInRange = ($fd, $fdtype) -> {
    $fd = SUBSTRING($fd, 0, 10);
    return $fd >= $date_from and $fd <= $date_to
};


define subquery $get_party_data($fdtype) as
$getNormalizedTsMil = ($ts, $table_name) -> ($getFielddate($normalizeTs($ts / 1000000, $table_name), $fdtype));


$chats_tmp = (
    select
        chat_id,
        $getFielddate(create_timestamp / 1000000, $fdtype) as fielddate,
    from EACH($chats_tables_list)
    WHERE chat_id LIKE $PARTY_PREFIX and $fdInRange(
        $getFielddate(create_timestamp / 1000000, $fdtype), $fdtype
    )
);

$chats_grouped = (
    select
        fielddate,
        CountDistinctEstimate(chat_id) as created_chats
    from $chats_tmp
    group by fielddate
);

$messages_tmp_ = (
    select TableName() as table_name,
    msg_timestamp,
    to_count,
    chat_id,
    guid,
    event_subtype,
    is_tester,
    is_robot,
    is_team,
    namespace,
    user_agent
    from range(
        `//home/mssngr/squeeze/sent_messages`, $date_from, $date_to
    )
);

$wrapIsMobile = ($ua) -> {
    $parsed = UserAgent::Parse($ua);
    return case
    when $parsed.OSFamily in ("Windows", "MacOS", "Linux") and not $parsed.isMobile then false
    when $parsed.isMobile then true
    else null
    end
};

$messages_tmp = (
    select
        $getNormalizedTsMil(msg_timestamp, table_name) as fielddate,
        chat_id,
        guid,
        $wrapIsMobile(user_agent) as is_mobile
    from $messages_tmp_
    WHERE event_subtype = 'sending'
    AND chat_id like $PARTY_PREFIX
    AND to_count
    AND NOT is_tester
    AND NOT is_robot
    AND NOT is_team
    AND namespace=13
);

$messages_grouped = (
    select
        fielddate,
        CountDistinctEstimate(IF(is_mobile, chat_id)) as chats_with_messages_mobile,
        CountDistinctEstimate(IF(not is_mobile, chat_id)) as chats_with_messages_desktop,
        CountDistinctEstimate(chat_id) as chats_with_messages,
        CountDistinctEstimate(guid) as users_with_messages,
        COUNT(*) as messages_total
    from $messages_tmp
    group by fielddate
);

$created_or_active = (
    select chat_id, fielddate
    from (
        select chat_id, fielddate from $chats_tmp
        union all
        select chat_id, fielddate from $messages_tmp
    )
    group by chat_id, fielddate
);

$users_tmp_ = (
    select
        TablePath() as table_path,
        `timestamp`,
        guid,
        chat_id
    from each($users_tables_list)
);

$users_tmp = (
    SELECT
        $getNormalizedTsMil(`timestamp`, $extractFd(table_path)) as fielddate,
        guid,
        chat_id
    from $users_tmp_
    where chat_id like $PARTY_PREFIX
    and guid != $BOT_GUID
);

$users_joined = (
    select
        u.fielddate as fielddate,
        u.chat_id as chat_id,
        guid
    from $users_tmp as u
    inner join $created_or_active as c using (chat_id, fielddate)
);

$users_grouped = (
    select
        fielddate,
        CountDistinctEstimate(chat_id) as created_or_active_chats,
        CountDistinctEstimate(guid) as users
    from $users_joined
    group by fielddate
);

$users_grouped_2 = (
    select
        fielddate,
        chat_id,
        CAST(CountDistinctEstimate(guid) as Double) as users_in_chat
    from $users_joined
    group by fielddate, chat_id
);

$users_grouped_3 = (
    select
        fielddate,
        AVG(users_in_chat) as avg_users_in_chat,
        MEDIAN(users_in_chat) as median_users_in_chat
    from $users_grouped_2
    group by fielddate
);

$xivaaccess_tmp_ = (
    select
        _logfeller_timestamp,
        TableName() as table_name,
        request,
        service,
    from range(
        `logs/xivaserver-access-log/1d`, $date_from, $date_to
    )
);

$xivaaccess_tmp = (
    SELECT
        $getFielddate($normalizeTs(_logfeller_timestamp, table_name), $fdtype) as fielddate,
        Url::GetCGIParam(request, "user") as user
    from $xivaaccess_tmp_
    where service='video-party'
    and request like '/v2/subscribe/websocket%'
);

$xivaaccess_grouped = (
    select fielddate, CountDistinctEstimate(user) as xivahub_users
    from $xivaaccess_tmp
    group by fielddate
);

$xivahub_tmp_ = (
    select
        TableName() as table_name,
        _logfeller_timestamp,
        uid,
        service
    from range(
        `logs/xivahub-log/1d`, $date_from, $date_to
    )
);

$xivahub_tmp = (
    select
        $getFielddate($normalizeTs(_logfeller_timestamp, table_name), $fdtype) as fielddate,
        uid
    from $xivahub_tmp_
    where service='video-party'
);

$xivahub_grouped = (
    select fielddate, CountDistinctEstimate(uid) as xivahub_rooms
    from $xivahub_tmp
    group by fielddate
);

$all_joined = (
    select
        c.fielddate ?? m.fielddate ?? u.fielddate ?? u3.fielddate ?? xh.fielddate ?? xa.fielddate as fielddate,
        created_chats ?? 0 as created_chats,
        chats_with_messages ?? 0 as chats_with_messages,
        chats_with_messages_mobile ?? 0 as chats_with_messages_mobile,
        chats_with_messages_desktop ?? 0 as chats_with_messages_desktop,
        users_with_messages ?? 0 as users_with_messages,
        messages_total ?? 0 as messages_total,
        created_or_active_chats ?? 0 as created_or_active_chats,
        users ?? 0 as users,
        xivahub_rooms ?? 0 as xivahub_rooms,
        xivahub_users ?? 0 as xivahub_users,
        avg_users_in_chat ?? 0 as avg_users_in_chat,
        median_users_in_chat ?? 0 as median_users_in_chat
    from $chats_grouped as c
    full join $messages_grouped as m on (c.fielddate == m.fielddate)
    full join $users_grouped as u on (c.fielddate == u.fielddate)
    full join $users_grouped_3 as u3 on (c.fielddate == u3.fielddate)
    full join $xivahub_grouped as xh on (c.fielddate == xh.fielddate)
    full join $xivaaccess_grouped as xa on (c.fielddate == xa.fielddate)
);

$all_grouped = (
    select
        fielddate,
        max(created_chats) as created_chats,
        max(chats_with_messages) as chats_with_messages,
        max(chats_with_messages_mobile) as chats_with_messages_mobile,
        max(chats_with_messages_desktop) as chats_with_messages_desktop,
        max(users_with_messages) as users_with_messages,
        max(messages_total) as messages_total,
        max(created_or_active_chats) as created_or_active_chats,
        max(users) as users,
        max(xivahub_rooms) as xivahub_rooms,
        max(avg_users_in_chat) as avg_users_in_chat,
        max(median_users_in_chat) as median_users_in_chat
    from $all_joined
    where fielddate is not null
    group by unwrap(fielddate) as fielddate
);
select * from $all_grouped;
end define;

insert into $output_daily WITH TRUNCATE
select * from $get_party_data("daily");

insert into $output_hourly WITH TRUNCATE
select * from $get_party_data("hourly");

upsert into stat.`@[report]/daily`
select * from $get_party_data("daily");

upsert into stat.`@[report]/hourly`
select * from $get_party_data("hourly");
