#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import argparse
import datetime
from nile.api.v1 import clusters
from yql.api.v1.client import YqlClient
from videolog_common import (
    apply_replacements,
    date_range,
    get_cluster,
    get_driver,
    get_stat_headers,
    get_dates_from_stat,
    get_date,
    StatPusher,
    YqlRunner,
)

log_roots = [
    "//home/logfeller/logs/mssngr-router-event-log/stream/5min",
    "//logs/xivahub-log/stream/5min",
]
TITLE = "[MMA-4697] Fast Party Video Stats | YQL"


def process_dates(dates, cluster, args):
    proxy = os.environ["YT_PROXY"]
    output_table = "{}/stat/{}_{}".format(args["root"], dates[0], dates[-1])
    yc = YqlClient(db=proxy.lower(), token=os.environ["YQL_TOKEN"])
    yr = YqlRunner(client=yc, title=TITLE)
    with open("party_fast_stats_report_stub.sql", "rb") as f:
        query = f.read().decode("utf8")
    query = apply_replacements(
        query,
        {
            "@[pool]": args["pool"],
            "@[output_root]": args["root"],
            "@[date_from]": str(dates[0]),
            "@[date_to]": str(dates[-1]),
        },
    )
    yr.run(query, wait=True)
    # if not args.get("debug"):
    #     sp = StatPusher(cluster, report=args["report"], scale="i")
    #     print("pushing to {}".format(args["report"]))
    #     kwargs = {"replace_mask": "fielddate"} if args.get("redo") else {}
    #     sp.push(output_table, **kwargs)


def parse_datetime(s):
    return datetime.datetime.strptime(s.replace("T", " "), "%Y-%m-%d %H:%M:%S")


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--pool", default="robot-mma-nirvana")
    parser.add_argument(
        "--report", default="Video/Others/Strm/party_fast_stats"
    )
    parser.add_argument(
        "--root",
        default="//home/videoquality/vh_analytics/party_fast_stats_report",
    )
    parser.add_argument("--from")
    parser.add_argument("--redo", action="store_true")
    # parser.add_argument("--notmp", action="store_true")
    parser.add_argument("--to")
    args = vars(parser.parse_args())

    from_ = args.get("from")
    to_ = args.get("to")

    cluster = get_cluster(clusters, args)
    yt = get_driver(cluster).client

    if from_ and to_:
        dates = sorted(date_range(from_, to_))
    else:
        dates_from_stat = get_dates_from_stat(
            report=args["report"],
            headers=get_stat_headers(),
            scale="i",
            raw=True,
        )
        last_datetime = parse_datetime(dates_from_stat[-1])
        print("last date: {}".format(last_datetime))
        availables = None
        for log_root in log_roots:
            set_ = {
                x.split("/")[-1]
                for x in yt.search(root=log_root, node_type="table")
            }
            if availables is None:
                availables = set_
            else:
                availables &= set_
        availables = sorted(availables)
        date_to = [x for x in availables if x.endswith((":25:00", ":55:00"))][
            -1
        ]
        print("last available date: {}".format(date_to))
        date_from_ = [
            x
            for x in availables
            if x.endswith((":00:00", ":30:00")) and x < date_to
        ]
        if date_from_ and parse_datetime(date_to) > last_datetime:
            date_from = date_from_[0]
            dates = [date_from, date_to]
        else:
            dates = []

    if dates:
        print("processing {}".format(dates))
        process_dates(dates, cluster, args)
    else:
        print("no dates to process")


if __name__ == "__main__":
    main()
