use hahn;
pragma yt.Pool = "@[pool]";

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_root = "@[output_root]";
$output_table = $output_root || "/stat/" || $date_from || "_" || $date_to;

$fielddateFormat = DateTime::Format("%Y-%m-%d %H:%M:%S");

$getFielddate = ($x)->{
    $x = $x || " Europe/Moscow";
    $dt = DateTime::MakeDatetime(DateTime::Parse("%Y-%m-%dT%H:%M:%S %Z")($x));
    $ts = DateTime::ToSeconds($dt);
    $ts = CAST($ts / 1800 * 1800 as Uint32);
    $tm = AddTimezone(DateTime::FromSeconds($ts), "Europe/Moscow");
    return $fielddateFormat($tm)
};

$router = (
    select
        fielddate,
        CountDistinctEstimate(ChatId) as chats,
        COUNT_IF(event_name == "TMessageContent") as total_events,
        CountDistinctEstimate(Guid) as users
    from range(
        `//home/logfeller/logs/mssngr-router-event-log/stream/5min`, $date_from, $date_to
    )
    where ChatId like "0/13/party%"
    and Guid != '7250d595-1607-43cd-97ab-63618cdf8403'
    and $getFielddate(TableName()) is not null
    group by $getFielddate(TableName()) as fielddate
);

$xivahub = (
    select
        fielddate, CountDistinctEstimate(uid) as xivahub_uids
    from range(
        `logs/xivahub-log/stream/5min`, $date_from, $date_to
    )
    where service='video-party' and $getFielddate(TableName()) is not null
    group by $getFielddate(TableName()) as fielddate
);

$joined = (
    select
        unwrap(r.fielddate ?? x.fielddate) as fielddate,
        chats ?? 0 as chats,
        total_events ?? 0 as total_events,
        users ?? 0 as users,
        xivahub_uids ?? 0 as xivahub_uids
    from $router as r
    full join $xivahub as x using (fielddate)
);

insert into $output_table with truncate
select * from $joined;

upsert into stat.`Video/Others/Strm/party_fast_stats/minutely`
select * from $joined;

