pragma yson.DisableStrict;

$parsePlayerState = ($state) -> {
    RETURN AsStruct(
        Yson::LookupString($state, "ad") is not null as is_ad,
        Yson::LookupInt64($state, "height") as height,
        Yson::LookupInt64($state, "width") as width,
        Yson::LookupInt64($state, "maxHeight") as maxHeight,
        Yson::LookupInt64($state, "maxWidth") as maxWidth,
        Yson::LookupInt64($state, "capHeight") as capHeight,
        Yson::LookupInt64($state, "capWidth") as capWidth,
        Yson::LookupBool($state, "isVisible") as isVisible,
        Yson::LookupBool($state, "isMuted") as isMuted,
        Yson::LookupUint64($state, "timestamp") ?? cast(
            (Yson::LookupDouble($state, "timestamp") * 1000.0) as Uint64
        ) as `timestamp`,
        Yson::LookupString($state, "state") as state,
        Yson::LookupDouble($state, "currentTime") as currentTime,
        Yson::LookupDouble($state, "watchedTime") as watchedTime,
        Yson::LookupDouble($state, "stalledTime") as stalledTime,
        Yson::LookupInt64($state, "stalledCount") as stalledCount,
        Yson::LookupString($state, "stalledReason") as stalledReason,
        Yson::LookupInt64($state, "bandwidthEstimate") as bandwidthEstimate,
    )
};

$getPlayerStateFromData = ($data) -> {
    $parsed = Yson::ParseJson($data);
    RETURN IF(
        Yson::LookupString($parsed, "state") is not null,
        $parsed,
        Yson::YPath($parsed, "/data/state")
    )
};

---

$input_type = List<
Struct<
    capHeight : Int64?,
    capWidth : Int64?,
    height : Int64?,
    is_ad : Bool,
    isMuted : Bool?,
    isVisible: Bool?,
    maxHeight : Int64?,
    maxWidth : Int64?,
    stalledCount : Int64?,
    stalledTime : Double?,
    state : String?,
    'timestamp' : Uint64?,
    watchedTime : Double?,
    width : Int64?
>
>;

$output_type = Struct<
    'avglogs': List<Double>,
    'resolutions': Yson?,
    'timestamp': Int64?
>?;

$avglogProcessList = Python::process_list(
    Callable<($input_type)->$output_type>,
    FileContent("list_processor.py")
);

$avglogParseResolutions = ($resolutions) -> {
    $res = Yson::ConvertToList($resolutions);
    $p_fhd = ListFilter($res, ($x)->(Yson::LookupString($x, "resolution") == "fhd"));
    $p_hd = ListFilter($res, ($x)->(Yson::LookupString($x, "resolution") == "hd"));
    $p_sd = ListFilter($res, ($x)->(Yson::LookupString($x, "resolution") == "sd"));
    $p_ld = ListFilter($res, ($x)->(Yson::LookupString($x, "resolution") == "ld"));
    RETURN AsStruct(
        IF(ListLength($p_fhd) == 1, Yson::LookupDouble($p_fhd[0], "watchedTime"), null) as p_fhd_watched_time,
        IF(ListLength($p_fhd) == 1, Yson::LookupDouble($p_fhd[0], "stalledTime"), null) as p_fhd_stalled_time,
        IF(ListLength($p_fhd) == 1, Yson::LookupInt64($p_fhd[0], "stalledCount"), null) as p_fhd_stalled_count,
        IF(ListLength($p_hd) == 1, Yson::LookupDouble($p_hd[0], "watchedTime"), null) as p_hd_watched_time,
        IF(ListLength($p_hd) == 1, Yson::LookupDouble($p_hd[0], "stalledTime"), null) as p_hd_stalled_time,
        IF(ListLength($p_hd) == 1, Yson::LookupInt64($p_hd[0], "stalledCount"), null) as p_hd_stalled_count,
        IF(ListLength($p_sd) == 1, Yson::LookupDouble($p_sd[0], "watchedTime"), null) as p_sd_watched_time,
        IF(ListLength($p_sd) == 1, Yson::LookupDouble($p_sd[0], "stalledTime"), null) as p_sd_stalled_time,
        IF(ListLength($p_sd) == 1, Yson::LookupInt64($p_sd[0], "stalledCount"), null) as p_sd_stalled_count,
        IF(ListLength($p_ld) == 1, Yson::LookupDouble($p_ld[0], "watchedTime"), null) as p_ld_watched_time,
        IF(ListLength($p_ld) == 1, Yson::LookupDouble($p_ld[0], "stalledTime"), null) as p_ld_stalled_time,
        IF(ListLength($p_ld) == 1, Yson::LookupInt64($p_ld[0], "stalledCount"), null) as p_ld_stalled_count
    )
};

$avglogPRSkipZeroes = ($resolutions) -> {
    $parsed = $avglogParseResolutions($resolutions);
    return IF(
        (
            $parsed.p_fhd_watched_time > 0
            or $parsed.p_hd_watched_time > 0
            or $parsed.p_sd_watched_time > 0
            or $parsed.p_ld_watched_time > 0
            or $parsed.p_fhd_stalled_count > 0
            or $parsed.p_hd_stalled_count > 0
            or $parsed.p_sd_stalled_count > 0
            or $parsed.p_ld_stalled_count > 0
        ),
        $parsed,
        AsStruct(
            null as p_fhd_watched_time,
            null as p_fhd_stalled_time,
            null as p_fhd_stalled_count,
            null as p_hd_watched_time,
            null as p_hd_stalled_time,
            null as p_hd_stalled_count,
            null as p_sd_watched_time,
            null as p_sd_stalled_time,
            null as p_sd_stalled_count,
            null as p_ld_watched_time,
            null as p_ld_stalled_time,
            null as p_ld_stalled_count
        )
    )
};

EXPORT $parsePlayerState, $avglogProcessList, $avglogParseResolutions, $avglogPRSkipZeroes, $getPlayerStateFromData;