pragma library('stability_common.sql');
import stability_common symbols $getPlatform, $refFromWrapperSafe, $mockService;

use hahn;
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;


$date_from = "@[date_from]";
$date = "@[date]";
--$date_from = "2020-06-02";
--$date = "2020-06-02";

$getServiceFromVSID = ($vsid) -> {
    return case
        when substring($vsid, 44, 5) == 'xWEBx' then 'StreamPlayer'
        when substring($vsid, 44, 5) == 'xANDx' then 'AndroidPlayer'
        when substring($vsid, 44, 5) == 'xAPLx' then 'ApplePlayer'
        when substring($vsid, 44, 5) == 'xIOSx' then 'iosZenAppPlayer'
        when substring($vsid, 44, 5) == 'xSTAx' then 'YaStation'
        when substring($vsid, 44, 5) == 'xSTMx' then 'YaStationMini'
        else null
    end;
};

$sessions = select
        some(user_agent) as user_agent,
        some(player_version) as player_version,
        some(view_type) as view_type,
        max(ref_from) as ref_from,
        sum(view_time) as view_time,
        $getServiceFromVSID(vsid) as service,
        vsid,
        fielddate
    from range("//cubes/video-strm", $date_from, $date, "sessions")
    where sources_aggr like '%js_tracer%'
    group by vsid, fielddate;

$gogol = select
    vsid,
    fielddate,
    max(labels_from) as ref_from,
    max(service) as service,
    count(*) as hit_per_vsid
from (
    select TableName() as fielddate,
    vsid,
    labels_from,
    service,
    eventName
    from range(`//logs/strm-gogol-log/1d`, $date_from, $date)
)
where vsid is not null AND eventName == 'ReportLog'
group by vsid, fielddate;


$data = select
    sessions.fielddate ?? gogol.fielddate as fielddate,
    $getPlatform(gogol.service ?? sessions.service, sessions.user_agent) as platform,
    $refFromWrapperSafe(gogol.ref_from ?? sessions.ref_from) as ref_from,
    sessions.player_version ?? "unknown" as player_version,
    sessions.view_type ?? "unknown" as view_type,
    sessions.view_time ?? 0 as view_time,
    gogol.hit_per_vsid as hit_per_vsid
from $sessions as sessions
right join $gogol as gogol
on (sessions.vsid == gogol.vsid and sessions.fielddate == gogol.fielddate);

$totalize = ($row) -> {
    $result = AsList($row);
    $result = ListUnionAll(
        $result,
        ListMap(
            $result, ($x)->(AddMember(RemoveMember($x, "ref_from"), "ref_from", "_total_"))
        )
    );
    $result = ListUnionAll(
        $result,
        ListMap(
            $result, ($x)->(AddMember(RemoveMember($x, "platform"), "platform", "_total_"))
        )
    );
    $result = ListUnionAll(
        $result,
        ListMap(
            $result, ($x)->(AddMember(RemoveMember($x, "player_version"), "player_version", "_total_"))
        )
    );
    $result = ListUnionAll(
        $result,
        ListMap(
            $result, ($x)->(AddMember(RemoveMember($x, "view_type"), "view_type", "_total_"))
        )
    );
    RETURN $result
};

$totalized = process $data using $totalize(TableRow());

insert into `@[root]/@[date_from]-@[date]` WITH TRUNCATE
select
    fielddate,
    platform,
    ref_from,
    player_version,
    view_type,
    sum(hit_per_vsid) as total_events,
    count(*) as total_vsids,
    count_if(view_time == 0) as total_vsids_zero_tvt
from $totalized
group by fielddate,
    platform,
    ref_from,
    player_version,
    view_type;
