PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.DisableStrict;


$checkUUID = ($UUID) -> {
    RETURN IF(
        $UUID LIKE "v%" or (LENGTH($UUID) == 32 AND SUBSTRING($UUID, 0, 1) == "4"),
        $UUID,
        NULL
    )
};

$extractKpVcid = ($url) -> {
    $split = String::SplitToList($url, "/");
    $section = $split[5];
    RETURN String::SplitToList($section, "-")[1]
};

$getVideoContentId = ($Data) -> {
    $stream_url = (
        Yson::ConvertToString(Yson::YPath($Data, "/streamUrl"))
        ?? Yson::ConvertToString(Yson::YPath($Data, "/data/currentStream/url"))
        ?? Yson::ConvertToString((Yson::YPath($Data, "/data/source/streams/0/url"))
        )
    );
    $adConfig = (
        Yson::YPath($Data, "/data/playerState/ad/adConfig")
        ?? Yson::YPath($Data, "/data/params/adConfig")
        ?? Yson::YPath($Data, "/data/source/adConfig")
        ?? Yson::YPath($Data, "/data/playerState/controller/sourceParams/adConfig")
    );
    RETURN
        Yson::LookupString($adConfig, "videoContentId")
        ?? Url::GetCGIParam($stream_url, "video_content_id")
        ?? $checkUUID(Url::GetCGIParam($stream_url, "uuid"))
        ?? $checkUUID($extractKpVcid($stream_url))
};

$getPlatform = ($service, $ua) -> {
    $parsed = UserAgent::Parse($ua);
    $os_family = $parsed.OSFamily;
    $osf_processed = CASE
    WHEN $parsed.isTV THEN "tv"
    WHEN $os_family in ("Windows", "Android", "iOS") THEN $os_family
    WHEN $parsed.isMobile THEN "other_mobile"
    ELSE "other_desktop"
    END;
    RETURN CASE
    WHEN $service in ("StreamPlayer", "ott-smart", "AndroidPlayer") then $service || "_" || $osf_processed
    ELSE $service
    END;
};

$getPlatformExt = ($service, $ua, $vsid) -> {
    $platform = $getPlatform($service, $ua);
    return IF(
        $platform like "AndroidPlayer%" and $vsid like "%xPRAx%",
        "AndroidPlayerPreloader",
        $platform
    )
};

$invalid_ref_from = Pire::Grep("[^a-zA-Z0-9\-_\.]");

$getRefFrom = ($Data) -> {
    RETURN
        Yson::ConvertToString(Yson::YPath($Data, "/labels/from"))
        ?? Yson::ConvertToString(Yson::YPath($Data, "/data/additionalParams/from"))
        ?? Yson::ConvertToString(Yson::YPath($Data, "/data/source/additionalParams/from"))
        ?? Url::GetCGIParam(
            Yson::ConvertToString(Yson::YPath($Data, "/streamUrl")), "from"
        )
        ?? Url::GetCGIParam(
            Yson::ConvertToString(Yson::YPath($Data, "/data/currentStream/url")), "from"
        )
        ?? Url::GetCGIParam(Yson::ConvertToString(Yson::YPath($Data, "/location")), "from")
};

$refFromWrapper = ($rf) -> {
    RETURN CASE
    WHEN $rf in [
    'efir','efir_touch','videohub','videohub_touch',
    'morda','morda_touch','streamhandler_other',
    'streamhandler_appsearch','efir_turboapp'
    ] THEN "Эфир"
    WHEN $rf in [
        'serp','ottwidget_ya-serp','streamhandler_serp','streamhandler_serp_touch'
    ] THEN "Поиск"
    WHEN $rf in [
        'yavideo','ottwidget_ya-video','ottwidget_yavideo'
    ] THEN "ЯВидео"
    WHEN $rf in [
        'yanews','yanewstragic'
    ] THEN "Новости"
    WHEN FIND($rf, "weather") IS NOT NULL THEN "Погода"
    WHEN (
        $rf = "discovery"
        OR FIND($rf, "ottwidget") IS NOT NULL
        OR FIND($rf, "kinopoisk") IS NOT NULL
        OR FIND($rf, "ott-smart") IS NOT NULL
        OR FIND($rf, "ott-mobile") IS NOT NULL
        OR FIND($rf, "ott-kp") IS NOT NULL
    ) THEN "Кинопоиск"
    WHEN $rf LIKE "zen%" or $rf LIKE "%.zen%"THEN "Zen"
    WHEN Length($rf) > 64 THEN "weird"
    WHEN $invalid_ref_from($rf) THEN "weird"
    WHEN $rf == "" THEN NULL
    ELSE $rf
    END
};

$remappedWrapDict = {
    "Эфир": "EFIR",
    "Поиск": "SERP",
    "Погода": "WEATHER",
    "ЯВидео": "VIDEO",
    "Новости": "NEWS",
    "Кинопоиск": "KINOPOISK",
    "Zen": "ZEN"
};

$remappedWrapRefFrom = ($rf) -> {
    $wrapped = $refFromWrapper($rf);
    RETURN CASE
    WHEN DictContains($remappedWrapDict, $wrapped) then $remappedWrapDict[$wrapped]
    WHEN $rf in ['other', 'disk', 'partner', 'district', 'ya-q', 'vconf'] THEN $rf
    WHEN $rf in ["ru.yandex.quasar.app", "ya-station"] THEN "STATION"
    WHEN $rf in ["yatvapp", "tvandroid"] or FIND($rf, "yandex.tv.videoplayer") IS NOT NULL THEN "TVAPP"
    WHEN $rf = "ya-market" then "MARKET"
    ELSE "UNMAPPED"
    END
};

$refFromWrapperSafe = ($x) -> ($refFromWrapper($x) ?? "NO_FROM");

$re_kal = Re2::Capture("/(kal|stream)/([0-9A-Za-z-_]+?)/");
$re_vod = Re2::Capture("/([0-9A-Za-z-_]+?)-vod/");
$re_converted = Re2::Capture("/vh-([0-9A-Za-z-_]+?)-converted/");

$getTechName = ($request) -> {
    RETURN CASE
    WHEN String::Contains($request, "cdn1tvru") THEN "1tv"
    WHEN $re_converted($request)._1 is not null THEN $re_converted($request)._1
    WHEN $re_vod($request)._1 is not null THEN $re_vod($request)._1
    WHEN $re_kal($request)._2 is not null THEN $re_kal($request)._2
    ELSE NULL
    END
};

$countTVT = ($lst) -> {
    $t30 = ListLength(ListFilter($lst, ($x)->($x == "30SecHeartbeat")));
    $t20 = ListLength(ListFilter($lst, ($x)->($x == "20SecWatched")));
    $t10 = ListLength(ListFilter($lst, ($x)->($x == "10SecWatched")));
    $result = CASE
    WHEN $t30 > 0 THEN 30 * $t30
    WHEN $t20 > 0 THEN 20
    WHEN $t10 > 0 THEN 10
    ELSE 0
    END;
    return CAST($result as UInt64)
};

$fielddateFormat = DateTime::Format("%Y-%m-%d");

$getFielddate = ($ts) -> {
    $ts = CAST($ts as Int64);
    $ts = CAST(($ts / 1800 * 1800) as UInt32);
    $tm = AddTimezone(DateTime::FromSeconds($ts), "Europe/Moscow");
    RETURN $fielddateFormat($tm)
};

$mockService = ($ref_from) -> {
    RETURN CASE
    WHEN $ref_from LIKE "ru.%" OR $ref_from LIKE "com.%" THEN "AndroidPlayer"
    WHEN $ref_from == "tvandroid" THEN "AndroidPlayer"
    WHEN $ref_from == "ott-smart-androidtv" THEN "AndroidPlayer"
    WHEN $ref_from == "ott-mobile-ios" OR $ref_from == "ott-smart-tvos" THEN "ApplePlayer"
    WHEN $ref_from LIKE "ott-smart%" THEN "ott-smart"
    WHEN $ref_from == "zen_app_ios_yandex" THEN "iosZenAppPlayer"
    ELSE "StreamPlayer"
    END
};

$parsePlayerState = ($state) -> {
    RETURN AsStruct(
        Yson::LookupString($state, "ad") is not null as is_ad,
        Yson::LookupInt64($state, "height") as height,
        Yson::LookupInt64($state, "width") as width,
        Yson::LookupInt64($state, "maxHeight") as maxHeight,
        Yson::LookupInt64($state, "maxWidth") as maxWidth,
        Yson::LookupInt64($state, "capHeight") as capHeight,
        Yson::LookupInt64($state, "capWidth") as capWidth,
        Yson::LookupUint64($state, "timestamp") as `timestamp`,
        Yson::LookupString($state, "state") as state,
        Yson::LookupDouble($state, "watchedTime") as watchedTime,
        Yson::LookupDouble($state, "stalledTime") as stalledTime,
        Yson::LookupInt64($state, "stalledCount") as stalledCount,
    )
};

$getPlayerStates = ($data) -> (
    AsList($parsePlayerState(Yson::ParseJson($data)) ?? $parsePlayerState(
        Yson::YPath(Yson::ParseJson($data), "/data/state")
    )) ?? ListMap(Yson::ConvertToList(Yson::YPath(
        Yson::ParseJson($data), "/data/states"
    )), $parsePlayerState)
);

$parseDate = ($x)->(DateTime::MakeDate(DateTime::Parse("%Y-%m-%d")($x)));
$formatDate = DateTime::Format("%Y-%m-%d");
$shiftDate = ($date, $days) -> ($formatDate(
    $parseDate($date) + DateTime::IntervalFromDays(cast($days as Int16))
));
$getFirstDayOfMonth = ($date) -> ($shiftDate($date, 1-cast(DateTime::GetDayOfMonth($parseDate($date)) as Int64)));

$mskDateFromTs = ($ts) -> ($formatDate(AddTimezone(DateTime::FromSeconds(cast($ts as Uint32)), "Europe/Moscow")));
$mskDateFromDtWithSub = ($dt, $sub) -> {
    $dt = cast($dt as DateTime) - DateTime::IntervalFromMinutes($sub);
    $tm = DateTime::Split($dt);
    $tm = DateTime::MakeTimestamp(DateTime::Update($tm, "Europe/Moscow" as Timezone));
    return $formatDate($tm)
};
$mskDateFromDt = ($dt) -> {
    $dt = cast($dt as DateTime);
    $tm = DateTime::Split($dt);
    $tm = DateTime::MakeTimestamp(DateTime::Update($tm, "Europe/Moscow" as Timezone));
    return $formatDate($tm)
};

$daysDiff = ($date1, $date2) -> (DateTime::ToDays($date2 - $date1) + 1);

$dateRange = ($f, $t) -> {
    $f = $parseDate($f);
    $t = $parseDate($t);
    $diff = DateTime::ToDays($t - $f) + 1;
    return ListMap(
        ListFromRange(0, unwrap($diff)),
        ($x)->(
            $formatDate($f + DateTime::IntervalFromDays(cast($x as Int16)))
        )
    )
};

$getLastDayOfMonth = ($date) -> {
    $date = cast($date as Date);
    $first_day_of_month = $date - DateTime::IntervalFromDays(DateTime::GetDayOfMonth($date) - 1);
    $guaranteed_next_month = $first_day_of_month + DateTime::IntervalFromDays(32);
    return cast($guaranteed_next_month - DateTime::IntervalFromDays(DateTime::GetDayOfMonth($guaranteed_next_month)) as String)
};

$stationMaxCrutch = ($rf, $ua) -> (IF(
    find($ua, "Yandexstation_2") is not null,
    $rf || "_Yandexstation_2",
    $rf
));

$dedup_stalleds = ($list) -> {
    RETURN ListNotNull(ListMap(
        ListEnumerate($list), ($pair) -> {
            $index = $pair.0;
            $object = $pair.1;
            RETURN CASE
            WHEN $object.duration == 0 and $list[$index + 1].duration == 1 THEN NULL
            WHEN $object.duration == 1 and $list[$index + 1].duration == 5 THEN NULL
            WHEN $object.duration == 5 and $list[$index + 1].duration == 10 THEN NULL
            ELSE $object
            END
        }
    ))
};

$wrapBool = ($bool)->(IF(
    $bool is not null,
    CAST($bool as String),
    "unknown"
));

$getStalleds = ($errors) -> {
    $stalleds = ListFilter(
        Yson::ConvertToList($errors), ($x)->(Yson::LookupString($x, "id_raw") == "Stalled")
    );
    $stalleds = ListMap(
        $stalleds, ($x)->(
            AsStruct(
                Yson::ConvertToInt64(Yson::YPath($x, "/details/stalledId")) as stalledId,
                Yson::ConvertToString(Yson::YPath($x, "/details/reason")) as reason,
                Yson::LookupInt64($x, "rel_time") as rel_time,
                cast(Yson::ConvertToDouble(Yson::YPath($x, "/details/stalledDuration")) ?? Yson::ConvertToInt64(Yson::YPath($x, "/details/stalledDuration")) as Double) as duration,
                $wrapBool(Yson::ConvertToBool(Yson::YPath($x, "/details/isMuted"))) as muted_cat,
            )
        )
    );
    $stalleds = $dedup_stalleds($stalleds);
    $stalledEnds = ListFilter(
        Yson::ConvertToList($errors), ($x)->(Yson::LookupString($x, "id_raw") == "StalledEnd")
    );
    $stalledEnds = ToDict(ListMap(
        $stalledEnds, ($x)->(AsTuple(
            Yson::ConvertToInt64(Yson::YPath($x, "/details/stalledId")),
            Yson::ConvertToDouble(Yson::YPath($x, "/details/stalledDuration"))
        ))
    ));
    $stalleds = ListMap(
        $stalleds,
        ($x)->(
            IF(
                $x.stalledId is not null and DictContains($stalledEnds, $x.stalledId) and $stalledEnds[$x.stalledId] is not null,
                AddMember(RemoveMember($x, "duration"), "duration", unwrap($stalledEnds[$x.stalledId])),
                $x
            )
        )
    );
    RETURN $stalleds
};

$wrapZen = ($ref_from) -> (IF($ref_from like "zen:%", String::JoinFromList(
    ListTake(String::SplitToList($ref_from, ":"), 2), ":"
), $ref_from));

$processRefFrom = ($rf, $ua) -> {
    $rf = $wrapZen($rf);
    $wrapped = $refFromWrapper($rf);
    $list = ListNotNull([$rf, IF($rf != $wrapped, $wrapped)]);
    return ListMap($list, ($x)->($stationMaxCrutch($x, $ua)))
};

$processRefFromDetailed = ($rf, $ua, $fb, $sb) -> {
    $rf = $wrapZen($rf);
    $wrapped = $refFromWrapper($rf);
    $list = ListNotNull([
        $rf,
        IF($rf != $wrapped, $wrapped),
        IF(
            $rf = "zen" and $fb is not null,
            "zen/" || $fb
        ),
        IF(
            $rf = "zen" and $fb is not null and $sb is not null,
            "zen/" || $fb || "/" || $sb
        ),
    ]);
    return ListMap($list, ($x)->($stationMaxCrutch($x, $ua)))
};

$totalizePlatform = ($x) -> {
    return case
    when $x.platform like "StreamPlayer_%" then
        [AddMember(RemoveMember($x, "platform"), "platform", "_total_"),AddMember(RemoveMember($x, "platform"), "platform", "StreamPlayer_total") ]
    when $x.platform like "AndroidPlayer_%" then [AddMember(RemoveMember($x, "platform"), "platform", "_total_"),AddMember(RemoveMember($x, "platform"), "platform", "AndroidPlayer_total") ]
    else [AddMember(RemoveMember($x, "platform"), "platform", "_total_")]
    end
};

EXPORT $getPlatform, $refFromWrapper, $refFromWrapperSafe, $remappedWrapRefFrom,
$getRefFrom, $getTechName, $countTVT, $getVideoContentId, $getFielddate,
$mockService, $getPlayerStates,
$parseDate, $formatDate, $dateRange, $shiftDate, $getFirstDayOfMonth, $getLastDayOfMonth,
$mskDateFromTs, $mskDateFromDtWithSub, $mskDateFromDt,
$stationMaxCrutch, $getStalleds, $wrapZen, $processRefFrom, $processRefFromDetailed, $totalizePlatform,
$getPlatformExt;
