pragma library('stability_common.sql');
import stability_common symbols $getPlatform, $refFromWrapper, $processRefFromDetailed, $mockService, $totalizePlatform;

use hahn;
pragma yt.UseDefaultTentativePoolTrees;
pragma yson.DisableStrict;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma yt.PoolTrees = "physical";
pragma yt.TentativePoolTrees = "cloud";
pragma SimpleColumns;

-- @[graph_info]

$from = "@[date_from]";
$to = "@[date]";
$table = "//logs/strm-gogol-log/1d";

$getDouble = ($json, $fieldPath) -> {
    return Yson::ConvertToDouble(Yson::YPath(Yson::ParseJson($json), $fieldPath));
};

$getInt = ($json, $fieldPath) -> {
    return Yson::ConvertToInt64(Yson::YPath(Yson::ParseJson($json), $fieldPath));
};

$getString = ($json, $fieldPath) -> {
    return Yson::ConvertToString(Yson::YPath(Yson::ParseJson($json), $fieldPath));
};

$stalleds = select 
    TableName() as fielddate,
    service,
    vsid,
    $getDouble(data, '/data/stalledDuration') as stalled_duration,
    $getInt(data, '/data/stalledId') as stalled_id,
    labels_reason as stalled_reason,
    labels_from as ref_from,
    userAgent,
    additionalParameters_from_block as ref_from_block,
    additionalParameters_stream_block as stream_block,

    -- тип рекламного блока для рекламных stalled
    $getString(data, '/data/adType') as ad_type,

    -- для stalled setsource
    $getString(data, '/data/preloadingMethod') as preloading_method,
    $getString(data, '/data/preloaded') as preloaded,


from range($table, $from, $to)
where 
    eventType == 'event' and
    (eventName == 'Stalled' or eventName == 'StalledEnd');

$stalleds = select 
    stalled_reason,
    max(stalled_duration) as stalled_duration,
    min(fielddate) as fielddate,
    some(service) as service,
    some(userAgent) as user_agent,
    some(ref_from) as ref_from,
    some(ref_from_block) as ref_from_block,
    some(stream_block) as stream_block,

    some(ad_type) as ad_type,
    some(preloading_method) as preloading_method,
    some(preloaded) as preloaded,
    vsid,
from $stalleds
group by vsid, stalled_reason, stalled_id;

$slow_net = select 
    if(percentile(bandwidth_estimate, 0.6) < 500000, 'true', 'false') as slow_net,
    vsid, 
from (
    select 
        $getDouble(data, '/bandwidthEstimate') ?? 0 as bandwidth_estimate,
        vsid
    from range($table, $from, $to)
    where
        eventType == 'event' and
        eventName == 'PlayerAlive'
)
where bandwidth_estimate > 0
group by vsid;

$stalleds = select 
    stalled_reason,
    stalled_duration,
    fielddate,
    ad_type,
    preloading_method,
    preloaded,
    $processRefFromDetailed(ref_from, user_agent, ref_from_block, stream_block) as ref_from,
    $getPlatform(service ?? $mockService(ref_from), user_agent) as platform,
    vsid,
from $stalleds;

$stalleds = select 
    stalled_reason,
    stalled_duration,
    fielddate,
    ad_type ?? 'none' as ad_type,
    preloading_method ?? 'none' as preloading_method,
    preloaded ?? 'none' as preloaded,
    ref_from,
    platform,
    slow_net ?? 'false' as slow_net
from $stalleds as a
left join $slow_net as b
using (vsid);

$totalize = ($row) -> {
    $rf = ListExtend($row.ref_from, ["_total_"]);
    $result = ListMap($rf, ($x)->(AddMember(RemoveMember($row, "ref_from"), "ref_from", $x)));

    $add = ListFlatMap($result, $totalizePlatform);
    $result = ListUnionAll($result, $add);

    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "ref_from"), "ref_from", "_total_")));
    $result = ListUnionAll($result, $add);

    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "stalled_reason"), "stalled_reason", "_total_")));
    $result = ListUnionAll($result, $add);

    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "ad_type"), "ad_type", "_total_")));
    $result = ListUnionAll($result, $add);

    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "preloading_method"), "preloading_method", "_total_")));
    $result = ListUnionAll($result, $add);

    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "preloaded"), "preloaded", "_total_")));
    $result = ListUnionAll($result, $add);

    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "slow_net"), "slow_net", "_total_")));
    $result = ListUnionAll($result, $add);

    RETURN $result
};


$data = process $stalleds using $totalize(TableRow());

$result = select
    fielddate,
    stalled_reason,
    ref_from,
    platform,
    ad_type,
    preloading_method,
    preloaded,
    slow_net,
    count(*) as stalled_count,
    percentile(stalled_duration, 0.25) as stalled_duration_p25,
    percentile(stalled_duration, 0.5) as stalled_duration_p50,
    percentile(stalled_duration, 0.75) as stalled_duration_p75,
    percentile(stalled_duration, 0.95) as stalled_duration_p95,
    percentile(stalled_duration, 0.99) as stalled_duration_p99,
    sum(stalled_duration) as total_stalled_duration
from $data
group by fielddate, stalled_reason, ref_from, platform, ad_type, preloading_method, preloaded, slow_net;


upsert into stat.`@[report]/daily`
select
    platform ?? 'unknown' as platform,
    ref_from ?? 'unknown' as ref_from,
    stalled_reason ?? 'unknown' as stalled_reason,
s.* without platform, ref_from, stalled_reason from $result as s;
