use hahn;
pragma yt.Pool = "@[pool]";
pragma yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
pragma library("stability_common.sql");
import stability_common symbols $refFromWrapper, $getPlatformExt, $mockService, $stationMaxCrutch, $getStalleds, $wrapZen;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_table = "@[output_table]";

$getStalledsWrap = ($errors) -> {
    $stalleds = ListFilter($getStalleds($errors), ($x)->($x.duration <= 600.0));
    $result = AsList(AsStruct(
        "Start" as reason,
        0 as duration,
        "unknown" as muted_cat
    ));
    RETURN ListUnionAll($result, $stalleds)
};

$processRefFrom = ($rf, $ua, $fb, $sb) -> {
    $rf = IF($rf = "", null, $rf);
    $rf = $wrapZen($rf);
    $wrapped = $refFromWrapper($rf);
    $list = ListNotNull([
        $rf,
        IF($rf != $wrapped, $wrapped),
        IF(
            $rf = "zen" and $fb is not null,
            "zen/" || $fb
        ),
        IF(
            $rf = "zen" and $fb is not null and $sb is not null,
            "zen/" || $fb || "/" || $sb
        ),
    ]);
    return ListExtend(ListMap($list, ($x)->($stationMaxCrutch($x, $ua))), ["_total_"])
};

$source = (
    select
        fielddate,
        vsid,
        $processRefFrom(ref_from, user_agent, ref_from_block, stream_block) as ref_from,
        $getPlatformExt(gogol_service ?? $mockService(ref_from), user_agent, vsid) as platform,
        view_time,
        view_type ?? "unknown" as view_type,
        $getStalledsWrap(errors) as stalleds
    from range(
        `cubes/video-strm`, $date_from, $date_to, `sessions`
    ) with columns Struct<gogol_service:String?>
    where vsid not like 'rtbdsp%'
);

$flattened = (
    select
        stalleds.duration as stalled_duration,
        stalleds.reason as stalled_reason,
        stalleds.muted_cat as muted_cat,
        t.* without t.stalleds
    from $source as t
    flatten list by stalleds
);

$totalize = ($row) -> {
    $result = AsList($row);
    $add = ListMap(
        $result, ($x)->(AddMember(RemoveMember($x, "view_type"), "view_type", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    $add = ListFlatMap(
        $result, ($x)->(ListNotNull([
            AddMember(RemoveMember($x, "platform"), "platform", "_total_"),
            IF($x.platform like "StreamPlayer%", AddMember(RemoveMember($x, "platform"), "platform", "StreamPlayer")),
            IF($x.platform like "AndroidPlayer%", AddMember(RemoveMember($x, "platform"), "platform", "AndroidPlayer")),
        ]))
    );
    $result = ListUnionAll($result, $add);
    $add = ListMap(
        $result, ($x)->(AddMember(RemoveMember($x, "muted_cat"), "muted_cat", "_total_"))
    );
    $result = ListUnionAll($result, $add);
    $add = ListNotNull(ListMap(
        $result, ($x)->(IF(
            $x.stalled_reason != "Start",
            AddMember(RemoveMember($x, "stalled_reason"), "stalled_reason", "_total_"),
            NULL
        ))
    ));
    $result = ListUnionAll($result, $add);
    RETURN $result
};

$totalized = select * from (process $flattened using $totalize(TableRow())) flatten list by ref_from;

$starts = (select * from $totalized where stalled_reason == "Start" and muted_cat == "_total_");
$stalleds = (select * from $totalized where stalled_reason != "Start");

$starts_grouped = (
    select
        fielddate,
        platform,
        ref_from,
        view_type,
        sum(view_time) as tvt,
        CountDistinctEstimate(vsid) as total_vsids
    from $starts
    group by fielddate,
        platform,
        ref_from,
        view_type
);

$stalleds_grouped = (
    select
        fielddate,
        platform,
        ref_from,
        muted_cat,
        view_type,
        stalled_reason,
        count(*) as total_stalleds,
        CountDistinctEstimate(vsid) as stalled_vsids,
        sum(stalled_duration) as total_stalled_duration,
        avg(stalled_duration) as avg_stalled_duration,
        percentile(stalled_duration, 0.5) as stalled_duration_p50,
        percentile(stalled_duration, 0.75) as stalled_duration_p75,
        percentile(stalled_duration, 0.90) as stalled_duration_p90,
        percentile(stalled_duration, 0.95) as stalled_duration_p95
    from $stalleds
    group by fielddate,
        platform,
        ref_from,
        muted_cat,
        view_type,
        stalled_reason
);

$joined = (
    select
        s.*,
        tvt,
        total_vsids
    from $stalleds_grouped as s
    left join any $starts_grouped as st using(
        fielddate,
        platform,
        ref_from,
        view_type
    )
);

insert into $output_table WITH TRUNCATE
select * from $joined
where stalled_reason is not null and stalled_reason != "";
