use hahn;
pragma yt.Pool = "@[pool]";
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$suffix = IF(
    $date_from == $date_to,
    $date_from,
    $date_from || "_" || $date_to
);
$root = "//home/videoquality/vh_analytics/strm_perf_dash/" || $suffix;
$input_table = $root || "/strm_perf_joined";
$output_table = $root || "/quality_chunk_view_report";

$fielddateFormat = DateTime::Format("%Y-%m-%d %H:%M:%S");

$getFielddate = ($ts) -> {
    $ts = CAST($ts as Int64);
    $ts = CAST(($ts / 1800 * 1800) as UInt32);
    $tm = AddTimezone(DateTime::FromSeconds($ts), "Europe/Moscow");
    RETURN $fielddateFormat($tm)
};


$totalize_quality_dash_live = ($row) -> {
    $retrans = IF(
        $row.transferSize != 0,
        $row.tcpinfo_total_retrans / cast($row.transferSize as Double) * 1400.0,
        1
    );
    $throughput = IF(
        $row.transferSize == 0,
        NULL,
        $row.transferSize / cast($row.duration as Double)
    );
    $result_row = AsStruct(
        $getFielddate($row.`timestamp`) as fielddate,
        $row.os_family as os_family,
        $row.quality as quality,
        $row.transferSize as transferSize,
        $row.chunk_type as chunk_type,
        $row.view_type as view_type,
        $retrans as retrans_packet_share,
        $row.duration as duration,
        $throughput as throughput,
        cast($row.tcpinfo_rtt as Double) / 1000.0 as tcpinfo_rtt,
        cast($row.tcpinfo_rttvar as Double) / 1000.0 as tcpinfo_rttvar,
        $row.tcpinfo_snd_cwnd as tcpinfo_snd_cwnd,
    );
    $result = AsList(
        $result_row
    );
    $expand = ListFlatMap(
        $result,
        ($x) -> {RETURN IF(
            $x.chunk_type != "_total_",
            AddMember(RemoveMember($x, "chunk_type"), "chunk_type", "_total_"),
            NULL
        )}
    );
    $result = ListUnionAll($result, $expand);
    $expand = ListFlatMap(
        $result,
        ($x) -> {RETURN IF(
            $x.view_type != "_total_",
            AddMember(RemoveMember($x, "view_type"), "view_type", "_total_"),
            NULL
        )}
    );
    $result = ListUnionAll($result, $expand);
    RETURN $result
};

$tmp = (
    process $input_table using $totalize_quality_dash_live(TableRow())
);

$nanvl = ($x) -> {
    RETURN IF(
        $x == cast('inf' as Double),
        NULL,
        $x
    )
};

$grouped = (
    select
        fielddate,
        os_family,
        quality,
        chunk_type,
        view_type,
        count(*) as `count`,
        count_if(throughput IS NULL) / cast(count(*) as Double) as null_transfersize_share,
        $nanvl(percentile(retrans_packet_share, 0.50)) as retrans_packet_share_p50,
        $nanvl(percentile(retrans_packet_share, 0.70)) as retrans_packet_share_p70,
        $nanvl(percentile(retrans_packet_share, 0.90)) as retrans_packet_share_p90,
        $nanvl(percentile(retrans_packet_share, 0.95)) as retrans_packet_share_p95,
        $nanvl(percentile(retrans_packet_share, 0.97)) as retrans_packet_share_p97,
        $nanvl(percentile(retrans_packet_share, 0.99)) as retrans_packet_share_p99,
        $nanvl(percentile(duration, 0.50)) as duration_p50,
        $nanvl(percentile(duration, 0.70)) as duration_p70,
        $nanvl(percentile(duration, 0.90)) as duration_p90,
        $nanvl(percentile(duration, 0.95)) as duration_p95,
        $nanvl(percentile(duration, 0.97)) as duration_p97,
        $nanvl(percentile(duration, 0.99)) as duration_p99,
        $nanvl(percentile(throughput, 0.50)) as throughput_p50,
        $nanvl(percentile(throughput, 0.70)) as throughput_p70,
        $nanvl(percentile(throughput, 0.90)) as throughput_p90,
        $nanvl(percentile(throughput, 0.95)) as throughput_p95,
        $nanvl(percentile(throughput, 0.97)) as throughput_p97,
        $nanvl(percentile(throughput, 0.99)) as throughput_p99,
        $nanvl(percentile(tcpinfo_rtt, 0.50)) as tcpinfo_rtt_p50,
        $nanvl(percentile(tcpinfo_rtt, 0.70)) as tcpinfo_rtt_p70,
        $nanvl(percentile(tcpinfo_rtt, 0.90)) as tcpinfo_rtt_p90,
        $nanvl(percentile(tcpinfo_rtt, 0.95)) as tcpinfo_rtt_p95,
        $nanvl(percentile(tcpinfo_rtt, 0.97)) as tcpinfo_rtt_p97,
        $nanvl(percentile(tcpinfo_rtt, 0.99)) as tcpinfo_rtt_p99,
        $nanvl(percentile(tcpinfo_rttvar, 0.50)) as tcpinfo_rttvar_p50,
        $nanvl(percentile(tcpinfo_rttvar, 0.70)) as tcpinfo_rttvar_p70,
        $nanvl(percentile(tcpinfo_rttvar, 0.90)) as tcpinfo_rttvar_p90,
        $nanvl(percentile(tcpinfo_rttvar, 0.95)) as tcpinfo_rttvar_p95,
        $nanvl(percentile(tcpinfo_rttvar, 0.97)) as tcpinfo_rttvar_p97,
        $nanvl(percentile(tcpinfo_rttvar, 0.99)) as tcpinfo_rttvar_p99,
        $nanvl(percentile(tcpinfo_snd_cwnd, 0.50)) as tcpinfo_snd_cwnd_p50,
        $nanvl(percentile(tcpinfo_snd_cwnd, 0.70)) as tcpinfo_snd_cwnd_p70,
        $nanvl(percentile(tcpinfo_snd_cwnd, 0.90)) as tcpinfo_snd_cwnd_p90,
        $nanvl(percentile(tcpinfo_snd_cwnd, 0.95)) as tcpinfo_snd_cwnd_p95,
        $nanvl(percentile(tcpinfo_snd_cwnd, 0.97)) as tcpinfo_snd_cwnd_p97,
        $nanvl(percentile(tcpinfo_snd_cwnd, 0.99)) as tcpinfo_snd_cwnd_p99
    from $tmp
    group by
        os_family,
        quality,
        chunk_type,
        view_type,
        fielddate
);

$addPercentiles = ($row) -> {
    RETURN  AsList(
        AsStruct(
            $row.fielddate as fielddate,
            $row.os_family as os_family,
            $row.quality as quality,
            $row.chunk_type as chunk_type,
            $row.view_type as view_type,
            $row.`count` as `count`,
            $row.null_transfersize_share as null_transfersize_share,
            "0.50" as quantile,
            $row.retrans_packet_share_p50 as retrans_packet_share,
            $row.duration_p50 as duration,
            $row.throughput_p50 as throughput,
            $row.tcpinfo_rtt_p50 as tcpinfo_rtt,
            $row.tcpinfo_rttvar_p50 as tcpinfo_rttvar,
            $row.tcpinfo_snd_cwnd_p50 as tcpinfo_snd_cwnd
        ), AsStruct(
            $row.fielddate as fielddate,
            $row.os_family as os_family,
            $row.quality as quality,
            $row.chunk_type as chunk_type,
            $row.view_type as view_type,
            $row.`count` as `count`,
            $row.null_transfersize_share as null_transfersize_share,
            "0.70" as quantile,
            $row.retrans_packet_share_p70 as retrans_packet_share,
            $row.duration_p70 as duration,
            $row.throughput_p70 as throughput,
            $row.tcpinfo_rtt_p70 as tcpinfo_rtt,
            $row.tcpinfo_rttvar_p70 as tcpinfo_rttvar,
            $row.tcpinfo_snd_cwnd_p70 as tcpinfo_snd_cwnd
        ), AsStruct(
            $row.fielddate as fielddate,
            $row.os_family as os_family,
            $row.quality as quality,
            $row.chunk_type as chunk_type,
            $row.view_type as view_type,
            $row.`count` as `count`,
            $row.null_transfersize_share as null_transfersize_share,
            "0.90" as quantile,
            $row.retrans_packet_share_p90 as retrans_packet_share,
            $row.duration_p90 as duration,
            $row.throughput_p90 as throughput,
            $row.tcpinfo_rtt_p90 as tcpinfo_rtt,
            $row.tcpinfo_rttvar_p90 as tcpinfo_rttvar,
            $row.tcpinfo_snd_cwnd_p90 as tcpinfo_snd_cwnd
        ), AsStruct(
            $row.fielddate as fielddate,
            $row.os_family as os_family,
            $row.quality as quality,
            $row.chunk_type as chunk_type,
            $row.view_type as view_type,
            $row.`count` as `count`,
            $row.null_transfersize_share as null_transfersize_share,
            "0.95" as quantile,
            $row.retrans_packet_share_p95 as retrans_packet_share,
            $row.duration_p95 as duration,
            $row.throughput_p95 as throughput,
            $row.tcpinfo_rtt_p95 as tcpinfo_rtt,
            $row.tcpinfo_rttvar_p95 as tcpinfo_rttvar,
            $row.tcpinfo_snd_cwnd_p95 as tcpinfo_snd_cwnd
        ), AsStruct(
            $row.fielddate as fielddate,
            $row.os_family as os_family,
            $row.quality as quality,
            $row.chunk_type as chunk_type,
            $row.view_type as view_type,
            $row.`count` as `count`,
            $row.null_transfersize_share as null_transfersize_share,
            "0.97" as quantile,
            $row.retrans_packet_share_p97 as retrans_packet_share,
            $row.duration_p97 as duration,
            $row.throughput_p97 as throughput,
            $row.tcpinfo_rtt_p97 as tcpinfo_rtt,
            $row.tcpinfo_rttvar_p97 as tcpinfo_rttvar,
            $row.tcpinfo_snd_cwnd_p97 as tcpinfo_snd_cwnd
        ), AsStruct(
            $row.fielddate as fielddate,
            $row.os_family as os_family,
            $row.quality as quality,
            $row.chunk_type as chunk_type,
            $row.view_type as view_type,
            $row.`count` as `count`,
            $row.null_transfersize_share as null_transfersize_share,
            "0.99" as quantile,
            $row.retrans_packet_share_p99 as retrans_packet_share,
            $row.duration_p99 as duration,
            $row.throughput_p99 as throughput,
            $row.tcpinfo_rtt_p99 as tcpinfo_rtt,
            $row.tcpinfo_rttvar_p99 as tcpinfo_rttvar,
            $row.tcpinfo_snd_cwnd_p99 as tcpinfo_snd_cwnd
        )
    )
};

insert into $output_table WITH TRUNCATE 
select * from (process $grouped using $addPercentiles(TableRow()))