use hahn;
pragma yt.Pool = "video_player_abt";
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma library("stability_common.sql");
import stability_common symbols $refFromWrapper;
pragma library("common.sql");
import common symbols $getQuality;

$date_from = $date;
$date_to = $date;

$re_kal = Re2::Capture("/(kal|stream)/([0-9A-Za-z-_]+?)/");
$re_fm = Re2::Capture("/fm/([0-9A-Za-z-_]+?)/");
$re_vod = Re2::Capture("/([0-9A-Za-z-_]+?)-vod/");
$re_converted = Re2::Capture("/vh-([0-9A-Za-z-_]+?)-converted/");
$ad_buckets = ["bsvideo", "canvas", "adfox"];

$get_channel_old = ($request) -> {
    $channel_old = CASE
    WHEN String::Contains($request, "cdn1tvru") THEN "1tv"
    WHEN $re_converted($request)._1 is not null THEN $re_converted($request)._1
    WHEN $re_vod($request)._1 is not null THEN $re_vod($request)._1
    WHEN $re_kal($request)._2 is not null and $re_kal($request)._2 like 'fm_%' THEN "fm"
    WHEN $re_kal($request)._2 is not null and $re_kal($request)._2 like '%weather%' then "kal_weather"
    WHEN $re_kal($request)._2 is not null THEN "kal_" || $re_kal($request)._2
    WHEN $re_fm($request)._1 is not null THEN "fm"
    ELSE NULL
    END;
    $channel_old = String::ToLower($channel_old);
    $channel_old = String::ReplaceAll($channel_old, "_supres", "");
    RETURN $channel_old
};

$invalid_ref_from = Pire::Grep("[^a-zA-Z0-9\-_\.]");

$refFromWrapper_ = ($ref_from) -> {
    $wrapped = $refFromWrapper($ref_from);
    RETURN IF(
        $wrapped is null, "weird", $wrapped
    )
};

$roundTs = ($timestamp) -> {
    $timestamp = CAST($timestamp as Uint64);
    RETURN $timestamp - ($timestamp % 3600)
};

$getVsid = ($request) -> {
    $vsid = Url::GetCGIParam("http://example.com" || $request, "vsid");
    RETURN IF(
        length($vsid) in (64, 62) and $vsid != "0000000000000000000000000000000000000000000000000000000000000000",
        $vsid,
        null
    )
};

$yandex_as = AsList();

$vhost_type = ($vhost, $source_uri, $remote_addr) -> {
    RETURN CASE
    WHEN $vhost like 'ext-strm-cogent%' or $vhost like 'ext-strm-level3%' or $vhost like 'ext-strm-telia%' or $vhost like 'strm-kiv%' or $vhost like 'strm-rad%' THEN "kiv-rad paid"
    WHEN $vhost like 'ext-strm-marrt%' or $vhost like 'ext-strm-mskrt%' or $vhost like 'ext-strm-stdrt%' or $vhost like 'ext-strm-spbrt%' THEN "rt paid"
    WHEN $vhost like 'ext-strm-%' THEN "isp IP"
    WHEN $vhost like 'strm.yandex.ru%' or $vhost like 'strm.yandex.net%' or $vhost like 'media.strm.yandex.net%' THEN "anycast" -- иногда добавляется порт :443
    WHEN $source_uri like '%@strm-%' THEN "yandex IP"
    WHEN $vhost in ('src_common_9090', 'vod_src_common', 'src_common') AND Geo::IsYandex($remote_addr)  THEN "swap-internal"
    WHEN $vhost in ('src_common_9090', 'vod_src_common', 'src_common') THEN "swap-external"
    ELSE "other"
    END
};


$tmp = (
    select
        TableName() as fielddate,
        $roundTs(`timestamp`) as hour,
        $get_channel_old(request) ?? "bucket" as bucket,
        $getVsid(request) as vsid,
        $getQuality(request) as quality,
        $vhost_type(vhost, source_uri, remote_addr) as vhost_type,
        remote_addr,
        bytes_sent,
    from range(
        `logs/strm-access-log/1d`, $date_from, $date_to
    )
    where status in ("200", "206")
    and remote_addr not in ('127.0.0.1', '::1')
    and not is_subrequest
    and not (
        Geo::IsYandex(remote_addr) and vhost like '[2a02:6b8:%'
    )
    and vhost != 'xaccelredirect.strm.yandex.net'
    and vhost != 'xaccelredirect'
    and vhost not like 'production-xaccelredirect%'
    and vhost != 'trns-manager.strm.yandex.net'
    and vhost not like 'trns%.strm.yandex.net%'
    and vhost not like 'trns-strm%'
    and vhost not like 'tumbler%.strm.yandex.net'
    and vhost not like '%.tst.strm.yandex.net'
    and vhost not like 'mgr%.strm.yandex.net'
    and vhost not like 'playlist-cache%'
);

$grouped = (
    select
        fielddate,
        hour,
        vsid,
        bucket,
        vhost_type,
        quality,
        sum(bytes_sent) as bytes_sent
    from $tmp
    group by
        fielddate,
        hour,
        vsid,
        bucket,
        vhost_type,
        quality
);

$wrapBucket = ($ref_from, $bucket) -> {
    RETURN CASE
    WHEN $ref_from IS NOT NULL THEN $ref_from
    WHEN $bucket in $ad_buckets THEN "Реклама"
    ELSE "no_vsid"
    END
};

$nonnull = select * from $grouped where vsid is not null;
$null = select t.*, IF(bucket in $ad_buckets, "Реклама", "no_vsid") as ref_from from $grouped as t where vsid is null;

$nanwrap = ($x) -> (IF(CAST($x as String) in ("nan", "-nan", "inf", "-inf"), null, $x));

$vsid_to_ref_from = (
    select
        fielddate,
        vsid,
        max($refFromWrapper_(ref_from)) as ref_from,
        (
            $nanwrap(sum_if(view_time, license in ("Svod", "Tvod_Est")) / cast(SUM(view_time) as Double))
            ?? $nanwrap(sum_if(bytes_sent, license in ("Svod", "Tvod_Est")) / cast(SUM(bytes_sent) as Double))
            ?? $nanwrap(count_if(license in ("Svod", "Tvod_Est")) / cast(count(*) as Double))
        ) as svod_share
    from range(
        `cubes/video-strm`, $date_from, $date_to, `sessions`
    )
    where length(vsid) in (62, 64) and ref_from is not null
    group by ListReverse(String::SplitToList(TablePath(), "/"))[1] as fielddate, vsid
);

$joined = (
    select
        s.*,
        v.ref_from ?? "no_vsid" as ref_from,
        svod_share
    from $nonnull as s
    left join $vsid_to_ref_from as v using (fielddate, vsid)
);

$concat = (
    select * from $joined
    union all
    select * from $null
);

$concat_add = (
    select
        c.*,
        bytes_sent * (svod_share ?? 0.0) as svod_bytes_sent
    from $concat as c
);

$grouped2 = (
    select
        fielddate,
        hour,
        ref_from,
        bucket,
        vhost_type,
        quality,
        ((sum(bytes_sent) ?? 0.0) / Math::Pow(1000, 3)) * 8.0 as gbit,
        ((sum(svod_bytes_sent) ?? 0.0) / Math::Pow(1000, 3)) * 8.0 as svod_gbit,
        (((sum(bytes_sent) ?? 0.0) - (sum(svod_bytes_sent) ?? 0.0)) / Math::Pow(1000, 3)) * 8.0 as avod_gbit,
    from $concat_add
    group by fielddate,
        hour,
        ref_from,
        bucket,
        vhost_type,
        quality
);

$totalize = ($row) -> {
    $result = AsList($row);
    $result = ListUnionAll($result, ListMap(
        $result, ($x) -> {
            RETURN AddMember(RemoveMember($x, "ref_from"), "ref_from", "_total_")
        }
    ));
    $result = ListUnionAll($result, ListMap(
        $result, ($x) -> {
            RETURN AddMember(RemoveMember($x, "quality"), "quality", "_total_")
        }
    ));
    $result = ListUnionAll($result, ListFlatMap(
        $result, ($x) -> {
            RETURN IF(
                $x.vhost_type != "swap-internal",
                AddMember(RemoveMember($x, "vhost_type"), "vhost_type", "_total_"),
                NULL
            )
        }
    ));
    $result = ListUnionAll($result, ListFlatMap(
        $result, ($x) -> {
            RETURN IF(
                $x.vhost_type not like "%swap%",
                AddMember(RemoveMember($x, "vhost_type"), "vhost_type", "_not_swap_"),
                NULL
            )
        }
    ));
    $result = ListUnionAll($result, ListFlatMap(
        $result, ($x) -> {
            RETURN CASE
            WHEN $x.bucket like 'kal%' THEN AsList(
                AddMember(RemoveMember($x, "bucket"), "bucket", "_kal_"),
                AddMember(RemoveMember($x, "bucket"), "bucket", "_total_")
            )
            ELSE AsList(AddMember(RemoveMember($x, "bucket"), "bucket", "_total_"))
            END
        }
    ));
    RETURN $result
};

$totalized = process $grouped2 using $totalize(TableRow());

$grouped2a = (
    select
        fielddate,
        hour,
        ref_from,
        bucket,
        vhost_type,
        quality,
        sum(gbit) as gbit,
        sum(svod_gbit) as svod_gbit,
        sum(avod_gbit) as avod_gbit,
    from $totalized
    group by fielddate,
        hour,
        ref_from,
        bucket,
        vhost_type,
        quality
);

$w = ($x) -> (IF($x = "", null, $x));

$grouped3 = (
    select
        fielddate,
        ref_from,
        bucket,
        vhost_type,
        quality,
        max(gbit) / 3600.0 as gbit_peak,
        max(svod_gbit) / 3600.0 as svod_gbit_peak,
        max(avod_gbit) / 3600.0 as avod_gbit_peak,
        sum(gbit) as gbit_sum
    from $grouped2a
    group by $w(fielddate) ?? "-" as fielddate,
        $w(ref_from) ?? "-" as ref_from,
        $w(bucket) ?? "-" as bucket,
        $w(vhost_type) ?? "-" as vhost_type,
        $w(quality) ?? "-" as quality
    having (max(gbit) / 3600.0) > 0.01
);

upsert into stat.`Video/Others/Strm/mma-3856-traffic/daily` erase by (fielddate)
select * from $grouped3;
