pragma library('stability_common.sql');
import stability_common symbols $getPlatform, $refFromWrapper, $processRefFromDetailed, $mockService;

use hahn;
pragma yt.UseDefaultTentativePoolTrees;
pragma yson.DisableStrict;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma yt.PoolTrees = "physical";
pragma yt.TentativePoolTrees = "cloud";
pragma SimpleColumns;

-- @[graph_info]

$from = "@[date_from]";
$to = "@[date]";

$sessions_ = select
    fielddate,
    vsid,
    user_agent,
    ref_from,
    ref_from_block,
    stream_block,
    gogol_service,
    view_time,
    bytes_sent,
from range("//cubes/video-strm", $from, $to, "sessions") with columns Struct<gogol_service:String?>
where vsid not like 'rtbdsp%' and (bytes_sent > 0 or view_time > 0);
$sessions = (
    select
        fielddate,
        vsid,
        sum(view_time) as view_time,
        sum(bytes_sent) as bytes_sent,
        max(user_agent) as user_agent,
        max(ref_from) as ref_from,
        max(ref_from_block) as ref_from_block,
        max(stream_block) as stream_block,
        max(gogol_service) as gogol_service,
        -- $getPlatform(max(gogol_service) ?? $mockService(max(ref_from)), max(user_agent)) as platform,
        -- $processRefFromDetailed(substring(max(ref_from), 0, 1000), max(user_agent), max(ref_from_block), max(stream_block)) as ref_from,
    from $sessions_
    group by fielddate, vsid
);

$cache_info_ready_ = (
    select TableName() as fielddate, vsid, Yson::YPathString(Yson::ParseJson(data), "/data/preloaderVsid") as preloader_vsid
from range("//logs/strm-gogol-log/1d", $from, $to)
where service = "AndroidPlayer" and eventName = "CacheInfoReady" and data like "%xPRAx%"
);
$cache_info_ready = (select fielddate, preloader_vsid, max(vsid) as vsid from $cache_info_ready_ where preloader_vsid is not null and vsid is not null group by fielddate, preloader_vsid);

$labels_from_ = (
    select
        TableName() as fielddate,
        vsid,
        labels_from
    from range("//logs/strm-gogol-log/1d", $from, $to)
    where service = "AndroidPlayer" and vsid like "%xPRAx%"
);
$labels_from = select fielddate, vsid, max(labels_from) as labels_from from $labels_from_ group by fielddate, vsid;

$preloader_vsids = (
    select
        ref_from ?? labels_from as ref_from,
        c.vsid as original_vsid,
        s.* without s.ref_from
    from (select * from $sessions where vsid like "%xPRAx%") as s
    left join any $labels_from as l on (s.fielddate = l.fielddate and s.vsid = l.vsid)
    left join any $cache_info_ready as c on (s.fielddate = c.fielddate and s.vsid = c.preloader_vsid)
);
$with_original_vsid = select * from $preloader_vsids where original_vsid is not null;
$without_original_vsid = select * from $preloader_vsids where original_vsid is null;

$add_preloader_vsid_traffic = (
    select
        (s.bytes_sent ?? 0) + (v.bytes_sent ?? 0) as bytes_sent,
        s.* without s.bytes_sent
    from (select * from $sessions where vsid not like "%xPRAx%") as s
    left join any $with_original_vsid as v on (
        s.fielddate = v.fielddate and s.vsid = v.original_vsid
    )
);
$unify = select * from $add_preloader_vsid_traffic union all select * from $without_original_vsid;

$add_ref_from_and_platform = (
    select
        $getPlatform(gogol_service ?? $mockService(ref_from), user_agent) as platform,
        $processRefFromDetailed(substring(ref_from, 0, 1000), user_agent, ref_from_block, stream_block) as ref_from,
        s.* without ref_from
    from $unify as s
);

$totalizePlatform = ($x) -> {
    return IF(
        $x.platform like "StreamPlayer_%",
        [AddMember(RemoveMember($x, "platform"), "platform", "_total_"),AddMember(RemoveMember($x, "platform"), "platform", "StreamPlayer_total") ],
        [AddMember(RemoveMember($x, "platform"), "platform", "_total_")],
    )
};

$totalize = ($row) -> {
    $rf = ListExtend($row.ref_from, ["_total_"]);
    $result = ListMap($rf, ($x)->(AddMember(RemoveMember($row, "ref_from"), "ref_from", $x)));
    $add = ListFlatMap($result, $totalizePlatform);
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "ref_from"), "ref_from", "_total_")));
    $result = ListUnionAll($result, $add);
    RETURN $result
};

$totalized = process $add_ref_from_and_platform using $totalize(TableRow());

$result = select 
    fielddate,
    platform,
    ref_from,
    sum(view_time) as tvt, 
    sum(bytes_sent) as traffic,
    sum_if(bytes_sent, view_time == 0) as zero_tvt_traffic,
    cast(sum(bytes_sent) as float) / cast(MAX_OF(sum(view_time), 1) as float) as traffic_by_tvt
    
from $totalized
group by fielddate,
    platform,
    ref_from;


upsert into stat.`@[report]/daily`
select
    platform ?? 'unknown' as platform,
    ref_from ?? 'unknown' as ref_from,
s.* without platform, ref_from from $result as s;
