use hahn;
pragma AnsiInForEmptyOrNullableItemsCollections;
pragma yt.DefaultMaxJobFails = "1";
pragma yson.DisableStrict;
pragma DqEngine = "disable";
pragma library('stability_common.sql');
import stability_common symbols $getPlatformExt, $processRefFromDetailed;

$py = FileContent("useful_traffic_common.py");

$dict_type = Struct<
    "resolution": String,
    "count": Uint64,
    "traffic_seconds": Double,
    "played_seconds": Double,
    "bytes_sent": Double,
    "bytes_sent_preloader": Double?,
    "useful_bytes_sent": Double?,
    "useful_bytes_share": Double?
>;

$get_useful_time = Python::get_useful_time(
    Callable<(Yson?, Yson?, Yson?)->List<$dict_type>?>, $py
);
$merge_resolutions = Python::merge_resolutions(
    Callable<(List<Yson?>?)->Yson?>, $py
);
$merge_pa_data = Python::merge_pa_data(
    Callable<(List<Yson?>?)->Yson?>, $py
);

$from = $date;
$to = $date;

$sessions_ = select
    fielddate,
    vsid,
    user_agent,
    ref_from,
    ref_from_block,
    stream_block,
    gogol_service,
    Yson::Serialize(Yson::YPath(add_info, "/resolutions")) as resolutions,
    player_alive_data
from range("//cubes/video-strm", $from, $to, "sessions") with columns Struct<gogol_service:String?>
where vsid not like 'rtbdsp%' and (Yson::Serialize(Yson::YPath(add_info, "/resolutions")) is not null or player_alive_data is not null);
$sessions = (
    select
        fielddate,
        vsid,
        $merge_resolutions(ListNotNull(aggregate_list(resolutions))) as resolutions,
        $merge_pa_data(ListNotNull(aggregate_list(player_alive_data))) as pa_data,
        max(user_agent) as user_agent,
        max(ref_from) as ref_from,
        max(ref_from_block) as ref_from_block,
        max(stream_block) as stream_block,
        max(gogol_service) as gogol_service,
    from $sessions_
    group by fielddate, vsid
);

$cache_info_ready_ = (
    select TableName() as fielddate, vsid, Yson::YPathString(Yson::ParseJson(data), "/data/preloaderVsid") as preloader_vsid
from range("//logs/strm-gogol-log/1d", $from, $to)
where service = "AndroidPlayer" and eventName = "CacheInfoReady" and data like "%xPRAx%"
);
$cache_info_ready = (select fielddate, preloader_vsid, max(vsid) as vsid from $cache_info_ready_ where preloader_vsid is not null and vsid is not null group by fielddate, preloader_vsid);

$labels_from_ = (
    select
        TableName() as fielddate,
        vsid,
        labels_from
    from range("//logs/strm-gogol-log/1d", $from, $to)
    where service = "AndroidPlayer" and vsid like "%xPRAx%"
);
$labels_from = select fielddate, vsid, max(labels_from) as labels_from from $labels_from_ group by fielddate, vsid;

$preloader_vsids = (
    select
        ref_from ?? labels_from as ref_from,
        c.vsid as original_vsid,
        s.* without s.ref_from
    from (select * from $sessions where vsid like "%xPRAx%") as s
    left join any $labels_from as l on (s.fielddate = l.fielddate and s.vsid = l.vsid)
    left join any $cache_info_ready as c on (s.fielddate = c.fielddate and s.vsid = c.preloader_vsid)
);
$with_original_vsid = select * from $preloader_vsids where original_vsid is not null;
$without_original_vsid = select resolutions as resolutions_preloader, s.* without resolutions from $preloader_vsids as s where original_vsid is null;

$add_preloader_vsid_traffic = (
    select
        s.*, v.resolutions as resolutions_preloader
    from (select * from $sessions where vsid not like "%xPRAx%") as s
    left join any $with_original_vsid as v on (
        s.fielddate = v.fielddate and s.vsid = v.original_vsid
    )
);
$unify = select * from $add_preloader_vsid_traffic union all select * from $without_original_vsid;

$add_ref_from_and_platform = (
    select
        if(
            gogol_service is not null,
            $getPlatformExt(gogol_service, user_agent, vsid),
            "Unknown" || (UserAgent::Parse(user_agent).OSFamily ?? "")
        ) as platform,
        $processRefFromDetailed(substring(ref_from, 0, 1000), user_agent, ref_from_block, stream_block) as ref_from,
        $get_useful_time(
            resolutions,
            resolutions_preloader,
            pa_data
        ) as useful_time,
        s.* without ref_from
    from $unify as s
);

$totalizePlatform = ($x) -> {
    return IF(
        $x.platform like "StreamPlayer_%",
        [AddMember(RemoveMember($x, "platform"), "platform", "_total_"),AddMember(RemoveMember($x, "platform"), "platform", "StreamPlayer_total") ],
        [AddMember(RemoveMember($x, "platform"), "platform", "_total_")],
    )
};

$totalize = ($row) -> {
    $rf = ListExtend($row.ref_from, ["_total_"]);
    $result = ListMap($rf, ($x)->(AddMember(RemoveMember($row, "ref_from"), "ref_from", $x)));
    $add = ListFlatMap($result, $totalizePlatform);
    $result = ListUnionAll($result, $add);
    $add = ListMap($result, ($x)->(AddMember(RemoveMember($x, "ref_from"), "ref_from", "_total_")));
    $result = ListUnionAll($result, $add);
    RETURN $result
};

$totalized = process $add_ref_from_and_platform using $totalize(TableRow());

$f = ($x) -> (IF(Math::IsFinite($x), $x));

$t_filter = (
    select
        $f(useful_time.played_seconds) as played_seconds,
        $f(useful_time.useful_bytes_share) as useful_bytes_share,
        $f(useful_time.bytes_sent) as bytes_sent,
        $f(useful_time.bytes_sent_preloader) as bytes_sent_preloader,
        $f(useful_time.traffic_seconds) as traffic_seconds,
        $f(useful_time.useful_bytes_sent) as useful_bytes_sent,
        $f(useful_time.`count`) as chunks_count,
        s.*
    from $totalized as s
    flatten list by useful_time
);

$result = select
    fielddate,
    platform,
    ref_from,
    resolution,
    sum(IF(played_seconds = 0, bytes_sent)) as zero_tvt_bytes_sent,
    sum(IF(played_seconds = 0, bytes_sent_preloader)) as zero_tvt_bytes_sent_preloader,
    sum(bytes_sent) as bytes_sent,
    sum(bytes_sent_preloader) as bytes_sent_preloader,
    sum(played_seconds) as played_seconds,
    sum(traffic_seconds) as traffic_seconds,
    sum(useful_bytes_sent) as useful_bytes_sent,
    sum(chunks_count) as chunks_count,
    $f(percentile(useful_bytes_share, 0.5)) as useful_traffic_share_p50,
    $f(percentile(useful_bytes_share, 0.75)) as useful_traffic_share_p75,
    $f(percentile(useful_bytes_share, 0.9)) as useful_traffic_share_p90,
    $f(percentile(useful_bytes_share, 0.95)) as useful_traffic_share_p95,
    $f(sum(useful_bytes_sent) / cast(sum(bytes_sent) as double)) as useful_traffic_share
from $t_filter
group by fielddate,
    platform ?? "-" as platform,
    ref_from ?? "-" as ref_from,
    useful_time.resolution ?? "-" as resolution;

upsert into stat.`Video/Others/Strm/Stability/UsefulTVTReport/daily` erase by (fielddate)
select * from $result;
