from collections import defaultdict
from yt import yson

VALID_RESOLUTIONS = [4320, 2880, 2160, 1440, 1080, 720, 576, 480, 360, 240, 144]

def wrap_res(res):
    return sorted(VALID_RESOLUTIONS, key=lambda x: abs(x - res))[0]

def merge_resolutions(list_of_dicts):
    result = defaultdict(lambda: {"count": 0, "bytes_sent": 0})
    for element in list_of_dicts:
        try:
            dict_ = yson.loads(element)
        except:
            continue
        for key in dict_:
            if tryint(key) is not None:
                new_k = str(wrap_res(tryint(key)))
                result[new_k]["count"] += dict_[key]["count"]
                result[new_k]["bytes_sent"] += dict_[key]["bytes_sent"]
            elif key == "audio":
                result[key]["count"] += dict_[key]["count"]
                result[key]["bytes_sent"] += dict_[key]["bytes_sent"]
    return yson.dumps(dict(result))

def tryint(s):
    try:
        return int(s)
    except:
        return

def merge_pa_data(list_of_dicts):
    result = defaultdict(lambda: {"watchedTime": 0})
    result["total_view_time"] = 0
    for element in list_of_dicts:
        try:
            dict_ = yson.loads(element)
        except:
            continue
        result["total_view_time"] += dict_["total_view_time"]
        for k in dict_:
            if tryint(k) is not None:
                new_k = str(wrap_res(tryint(k)))
                result[new_k]["watchedTime"] += dict_[k]["watchedTime"]
    return yson.dumps(dict(result))

def count_useful(dct):
    try:
        useful_share = min(dct["played_seconds"] / dct["traffic_seconds"], 1)
    except ZeroDivisionError:
        dct["useful_bytes_sent"] = None
        dct["useful_bytes_share"] = None
        return
    dct["useful_bytes_sent"] = dct["bytes_sent"] * useful_share
    dct["useful_bytes_share"] = useful_share

def get_useful_time(resolutions, resolutions_preloader, pa_data):
    try:
        resolutions = yson.loads(resolutions)
    except:
        resolutions = {}
    try:
        resolutions_preloader = yson.loads(resolutions_preloader)
    except:
        resolutions_preloader = {}
    if not resolutions and not resolutions_preloader:
        return []
    try:
        pa_data = yson.loads(pa_data)
    except:
        pa_data = {}
    total = {
        "count": 0,
        "bytes_sent": 0,
        "useful_bytes_sent": 0,
        "useful_bytes_share": None,
        "bytes_sent_preloader": 0,
        "traffic_seconds": 0,
        "played_seconds": pa_data.get("total_view_time") or 0,
        "resolution": "_total_"
    }
    for res in (resolutions_preloader or {}):
        dct = resolutions_preloader[res]
        if res not in resolutions:
            resolutions[res] = {
                "count": dct["count"],
                "bytes_sent": dct["bytes_sent"],
            }
        resolutions[res]["bytes_sent_preloader"] = dct["bytes_sent"]
        total["bytes_sent_preloader"] += dct["bytes_sent"]
    for res in (resolutions or {}):
        dct = resolutions[res]
        dct["traffic_seconds"] = dct["count"] * 4
        if res != "audio":
            total["count"] += dct["count"]
            total["bytes_sent"] += dct["bytes_sent"]
            total["traffic_seconds"] += dct["traffic_seconds"]
        try:
            if res == "audio":
                dct["played_seconds"] = pa_data["total_view_time"]
            else:
                dct["played_seconds"] = pa_data[res]["watchedTime"]
        except:
            dct["played_seconds"] = 0
    for res in resolutions:
        dct = resolutions[res]
        dct["resolution"] = res
        count_useful(dct)
        total["useful_bytes_sent"] += (dct.get("useful_bytes_sent") or 0)
    if total["bytes_sent"]:
        total["useful_bytes_share"] = total["useful_bytes_sent"] / total["bytes_sent"]
    return sorted(list(resolutions.values()) + [total], key=lambda x: x["resolution"])
