$re_kal = Re2::Capture("/kal/([0-9A-Za-z-_]+?)/");
$re_fm = Re2::Capture("/fm/([0-9A-Za-z-_]+?)/");
$re_vod = Re2::Capture("/([0-9A-Za-z-_]+?)-vod/");
$re_converted = Re2::Capture("/vh-([0-9A-Za-z-_]+?)-converted/");

$get_channel_old = ($request) -> {
    $channel_old = CASE
    WHEN String::Contains($request, "cdn1tvru") THEN "1tv"
    WHEN $re_converted($request)._1 is not null THEN $re_converted($request)._1
    WHEN $re_vod($request)._1 is not null THEN $re_vod($request)._1
    WHEN $re_kal($request)._1 is not null and $re_kal($request)._1 like 'fm_%' THEN "fm"
    WHEN $re_kal($request)._1 is not null and $re_kal($request)._1 like '%weather%' then "kal_weather"
    WHEN $re_kal($request)._1 is not null THEN "kal_" || $re_kal($request)._1
    WHEN $re_fm($request)._1 is not null THEN "fm"
    ELSE NULL
    END;
    $channel_old = String::ToLower($channel_old);
    $channel_old = String::ReplaceAll($channel_old, "_supres", "");
    RETURN $channel_old
};

$invalid_ref_from = Pire::Grep("[^a-zA-Z0-9\-_\.]");

$refFromWrapper = ($ref_from) -> {
    RETURN CASE
    WHEN FIND($ref_from, "zen") IS NOT NULL THEN "Zen"
    WHEN $ref_from in ("efir", "efir_touch", "videohub", "videohub_touch") THEN "Эфир"
    WHEN $ref_from in ("yavideo", "ottwidget_ya-video", "ottwidget_yavideo") THEN "ЯВидео"
    WHEN $ref_from in ("serp", "ottwidget_ya-serp") THEN "Поиск"
    WHEN $ref_from in ("ya-weather", "weather_desktop", "weather_turbo") THEN "Погода"
    WHEN $ref_from in ("yanews", "yanewstragic") THEN "Новости"
    WHEN $ref_from in ("ottwidget_kp", "ottwidget_ott-kp", "ru.kinopoisk") THEN "Кинопоиск"
    WHEN Length($ref_from) > 64 THEN "weird"
    WHEN $invalid_ref_from($ref_from) THEN "weird"
    ELSE $ref_from
    END
};

$roundTs = ($timestamp) -> {
    $timestamp = CAST($timestamp as Uint64);
    RETURN $timestamp - ($timestamp % 300)
};

$parseSignedUrl = ($url) -> {
    $url = SUBSTRING($url, 0, FIND($url, "?"));
    $sp = ListFilter(String::SplitToList($url, "/"), ($x) -> {RETURN FIND($x, "=") IS NOT NULL});
    RETURN ToDict(ListMap($sp, ($x) -> {
        RETURN AsTuple(
            unwrap(String::SplitToList($x, "=")[0]),
            unwrap(String::SplitToList($x, "=")[1])
        )
    }));
};

$getVsid = ($request) -> {
    $parsed = $parseSignedUrl($request);
    $vsid = $parsed["vsid"] ?? Url::GetCGIParam("http://example.com" || $request, "vsid");
    RETURN IF(
        length($vsid) in (64, 62) and $vsid != "0000000000000000000000000000000000000000000000000000000000000000",
        $vsid,
        null
    )
};

$yandex_as = AsList();

$vhost_type = ($vhost, $source_uri, $remote_addr) -> {
    RETURN CASE
    WHEN $vhost like 'ext-strm-cogent%' or $vhost like 'ext-strm-level3%' or $vhost like 'ext-strm-telia%' or $vhost like 'strm-kiv%' or $vhost like 'strm-rad%' or $vhost like 'ext-strm-rascom%' or $vhost like 'ext-strm-kivretn%' THEN "kiv-rad paid"
    WHEN $vhost like 'ext-strm-stdrt%' or $vhost like 'ext-strm-marrt%' or $vhost like 'ext-strm-mskrt%' or $vhost like 'ext-strm-spbrt%' THEN "rt paid"
    WHEN $vhost like 'ext-strm-%' THEN "isp IP"
    WHEN $vhost like 'strm.yandex.ru%' or $vhost like 'strm.yandex.net%' or $vhost like 'media.strm.yandex.net%' THEN "anycast" -- иногда добавляется порт :443
    WHEN $source_uri like '%@strm-%' THEN "yandex IP"
    WHEN $vhost in ('src_common_9090', 'vod_src_common', 'src_common') AND Geo::IsYandex($remote_addr)  THEN "swap-internal"
    WHEN $vhost in ('src_common_9090', 'vod_src_common', 'src_common') THEN "swap-external"
    ELSE "other"
    END
};


$paid_vhost_cat = ($vhost) -> {
    RETURN CASE
    WHEN $vhost like "ext-strm-cogent%" THEN "ext-strm-cogent"
    WHEN $vhost like "ext-strm-level3%" THEN "ext-strm-level3"
    WHEN $vhost like "ext-strm-telia%" THEN "ext-strm-telia"
    WHEN (
        $vhost like 'ext-strm-stdrt%'
        or $vhost like 'ext-strm-marrt%'
        or $vhost like 'ext-strm-mskrt%'
        or $vhost like 'ext-strm-spbrt%'
        or $vhost like 'ext-strm-nnovrt%'
        or $vhost like 'ext-strm-novosibrt%'
        or $vhost like 'ext-strm-khabrt%'
    ) THEN "ext-strm-rostelecom"
    ELSE "other"
    END
};

$get_moscow_ts = ($ts) -> {
    $st = CAST(DateTime::FromSeconds(cast($ts + 10800 as Uint32)) as String);
    $st = String::ReplaceAll($st, "T", " ");
    $st = String::ReplaceAll($st, "Z", "");
    RETURN $st
};

$fiveMinsInMonth = ($month) -> {
    $firstDay = CAST($month || "-01T00:00:00,Europe/Moscow" AS TzDateTime);
    $fd_res = DateTime::Split($firstDay);
    $nfd_res = DateTime::ShiftMonths($fd_res, 1);
    $nextFirstDay = DateTime::MakeDatetime($nfd_res);
    RETURN (DateTime::ToSeconds($nextFirstDay) - DateTime::ToSeconds($firstDay)) / 300
};

export $get_channel_old, $refFromWrapper, $getVsid, $roundTs, $vhost_type, $paid_vhost_cat, $get_moscow_ts, $fiveMinsInMonth;
