use hahn;
pragma yson.DisableStrict;
pragma yt.Pool = "@[pool]";
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;
pragma library("peaks_common.sql");
import peaks_common symbols $get_channel_old, $refFromWrapper, $getVsid, $roundTs, $vhost_type, $paid_vhost_cat, $get_moscow_ts, $fiveMinsInMonth;

$month = "@[month]";
$available_to_exceed = Math::Ceil($fiveMinsInMonth($month) * 0.05) - 1;
$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_table = "@[output_table]";

$input_struct_type = Struct<
    'fivemin':UInt64?,
    'fielddate':String,
    'paid_vhost_cat':String,
    'mbit_sec':Double?,
    'has_overcommit':Int32
>;
$output_struct_type = Struct<
    'fielddate':String,
    'paid_vhost_cat':String,
    'total_overcommits':Int32,
    'available_overcommits':Int32,
    'current_peak':Double,
    'current_p95':Double
>;

$py_reducer = Python::reducer(
    Callable<(String?, Stream<$input_struct_type>)->Stream<$output_struct_type>>,
    FileContent("peaks_reducer.py")
);

$paid_dict = AsDict(
    AsTuple("ext-strm-telia", 15000),
    AsTuple("ext-strm-rascom", 100000),
    AsTuple("ext-strm-cogent", 30000),
    AsTuple("ext-strm-level3", 15000),
    AsTuple("ext-strm-kivretn", 100000),
    AsTuple("ext-strm-rostelecom", 500000)
);

$getThreshold = ($cat) -> {
    RETURN $paid_dict[$cat] ?? 0.0
};

$wrapTs = ($x)->(CAST(Yson::ConvertToString($x) as Uint64) ?? CAST(Yson::ConvertToInt64($x) as Uint64));

-----

$tmp = (
    select
        TableName() as fielddate,
        $roundTs($wrapTs(`timestamp`)) as fivemin,
        $paid_vhost_cat(vhost) as paid_vhost_cat,
        bytes_sent,
    from range(
        `logs/strm-access-log/1d`, $date_from, $date_to
    ) with columns Struct<'timestamp':Yson?>
    where status in ("200", "206")
    and remote_addr not in ('127.0.0.1', '::1')
    and not (
        Geo::IsYandex(remote_addr) and vhost like '[2a02:6b8:%'
    )
    and $vhost_type(vhost, source_uri, remote_addr) in ("kiv-rad paid", "rt paid")
    and vhost != 'xaccelredirect.strm.yandex.net'
    and vhost != 'xaccelredirect'
    and vhost not like 'production-xaccelredirect%'
    and vhost != 'trns-manager.strm.yandex.net'
    and vhost not like 'trns%.strm.yandex.net%'
    and vhost not like 'trns-strm%'
    and vhost not like 'tumbler%.strm.yandex.net'
    and vhost not like '%.tst.strm.yandex.net'
    and vhost not like 'mgr%.strm.yandex.net'
    and vhost not like 'playlist-cache%'
);

$to_mbit_sec = ($bytes_sent) -> {
    return ($bytes_sent * 8 / 1000 / 1000 / 300.0)
};

$grouped = (
    select
        fielddate,
        fivemin,
        paid_vhost_cat,
        $to_mbit_sec(sum(bytes_sent)) as mbit_sec,
        if(
            $to_mbit_sec(sum(bytes_sent)) > $getThreshold(paid_vhost_cat),
            1,
            0
        ) as has_overcommit
    from $tmp
    group by fielddate,
        fivemin,
        paid_vhost_cat
);

$overcommits = (
    reduce $grouped
    presort fielddate, fivemin
    on paid_vhost_cat
    using $py_reducer(TableRow())
);

$plus = (
    select o.*,
    $paid_dict[paid_vhost_cat] as commit_threshold,
    if(
        current_p95 > $paid_dict[paid_vhost_cat],
        current_p95 - $paid_dict[paid_vhost_cat],
        0
    ) as overcommit
    from $overcommits as o
);

insert into $output_table with truncate
select * from $plus;
