import math
import datetime


def shift_month(date):
    year = date.year
    month = date.month
    if date.month == 12:
        month = 1
        year += 1
    else:
        month += 1
    return date.replace(month=month, year=year)


def get_threshold_from_month(fielddate):
    parsed = (
        datetime.datetime.strptime(fielddate.decode("utf8"), "%Y-%m-%d")
        .date()
        .replace(day=1)
    )
    next_month = shift_month(parsed)
    fivemins_total = (
        int(next_month.strftime("%s")) - int(parsed.strftime("%s"))
    ) / 300
    return math.ceil(fivemins_total * 0.05) - 1


class Reducer:
    def process_day(self, key, rec):
        return {
            "fielddate": rec.fielddate,
            "paid_vhost_cat": key,
            "total_overcommits": self.total_overcommits,
            "available_overcommits": max(self.available_overcommits, 0),
            "current_p95": sorted(self.fivemins)[-self.threshold :][0],
            "current_peak": max(self.fivemins[-288:]),
        }

    def process_rec(self, rec):
        self.fivemins.append(rec.mbit_sec)
        if rec.has_overcommit:
            self.total_overcommits += 1
            self.available_overcommits -= 1

    def __call__(self, key, recs):
        prev_rec = None
        self.fivemins = []
        self.total_overcommits = 0
        self.available_overcommits = None
        self.threshold = None

        for rec in recs:
            if not self.threshold:
                self.threshold = get_threshold_from_month(rec.fielddate)
                self.available_overcommits = self.threshold
            if prev_rec and rec.fielddate != prev_rec.fielddate:
                yield self.process_day(key, prev_rec)
            self.process_rec(rec)
            prev_rec = rec
        yield self.process_day(key, prev_rec)


reducer = Reducer()
