use hahn;
pragma yt.Pool = "@[pool]";
pragma yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
pragma library("stability_common.sql");
import stability_common SYMBOLS $refFromWrapper, $getPlatform, $mockService;

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_table = "@[output_table]";
$tmp_table = "@[tmp_table]";

$good_rfs = AsList(
    "Zen",
    "Эфир",
    "ЯВидео",
    "Поиск",
    "Погода",
    "Новости",
    "Кинопоиск"
);

$wrapWrapper = ($rf) -> {
    $wrapped = $refFromWrapper($rf);
    RETURN CASE
    WHEN $wrapped in $good_rfs THEN $wrapped
    WHEN $wrapped is null OR LENGTH($wrapped) == 0 THEN "-"
    ELSE "other"
    END;
};

$emptywrap = ($pv)->(IF(
    length($pv) == 0 or $pv is null,
    "-",
    $pv
));

$tmp = (
    select
        fielddate,
        $wrapWrapper(ref_from) as ref_from,
        $getPlatform($mockService(ref_from), user_agent) as platform,
        $emptywrap(player_version) as player_version,
        IF(
            bytes_sent > 0 and view_time > 0,
            cast(bytes_sent as Double) / 1024.0 / cast(view_time as Double),
            null
        ) as kb_per_sec,
        bytes_sent,
        view_time
    from range(
        `cubes/video-strm`, $date_from, $date_to, `sessions`
    )
);

$totalize = ($row) -> {
    $result = AsList($row);
    $result = ListUnionAll($result, ListMap(
        $result, ($x)->(AddMember(RemoveMember($x, "ref_from"), "ref_from", "_total_"))
    ));
    $result = ListUnionAll($result, ListMap(
        $result, ($x)->(AddMember(RemoveMember($x, "platform"), "platform", "_total_"))
    ));
    $result = ListUnionAll($result, ListMap(
        $result, ($x)->(AddMember(RemoveMember($x, "player_version"), "player_version", "_total_"))
    ));
    RETURN $result
};

$totalized = process $tmp using $totalize(TableRow());

$grouped = (
    select
        fielddate,
        ref_from,
        platform,
        player_version,
        SUM(bytes_sent) / Math::Pow(1024, 3) as gbytes_sent,
        SUM(view_time) as tvt,
        PERCENTILE(kb_per_sec, 0.5) as kb_per_sec_p50,
        PERCENTILE(kb_per_sec, 0.75) as kb_per_sec_p75,
        PERCENTILE(kb_per_sec, 0.9) as kb_per_sec_p90,
        PERCENTILE(kb_per_sec, 0.95) as kb_per_sec_p95,
        PERCENTILE(kb_per_sec, 0.99) as kb_per_sec_p99,
    from $totalized
    group by fielddate, ref_from, platform, player_version
);

insert into $output_table with truncate
select * from $grouped;
