pragma yson.DisableStrict;

$skipEvents = AsList(
    "CanPlay",
    "LoadStartHavingCurrentData",
    "DestroyPlayer",
    "TabCrash",
    "STRM_LOG_URL_LENGTH_LIMIT_EXCEEDED",
    "CreatePlayer",
    "PrerollInit",
    "PlayerFrameUnload",
    "InitialConfigDeprecated",
    "StalledEnd",
    "LoadSource",
    "NotReplacedBroadcastAdPodStart",
    "NotReplacedBroadcastAdPodEnd",
    "AdPodEnd",
    "AdPodStart",
    "StreamPlayerReceivedMetadata",
    "bufferStalledError",
    "MULTIROLL_INIT_ERROR",
    "DrmSystemsSupportDetected",
    "RAA_TAKING_2_SEC",
    "0",
    "AD_IS_ALREADY_PLAYING",
    "AutoplayImpossible",
    "BROADCAST_AD_BLOCK_INIT_ERROR",
    "BroadcastAdInit",
    "BroadcastAdReceived",
    "Buffer.Empty",
    "Buffer.Full",
    "CallPublicApiAfterDestroy",
    "ConcurrentRecoverCalled",
    "ControllerForVideoSearch.onQualityChange",
    "DETECT_PLAY_BY_INTERVAL",
    "HiddenAutoplayPrevented",
    "IFrameController.getCurrentQuality",
    "IFrameController.onQualityChange",
    "LqHqHdParamInIframeParams",
    "META_INFO_REQUEST_FAILED",
    "NotReplacedBroadcastAdEnd",
    "NotReplacedBroadcastAdStart",
    "OriginalBroadcastAdEnd",
    "OriginalBroadcastAdStart",
    "PROTECTED_FRAME_DIRECT_LINK_BLOCKED",
    "PartnerIdParamInPlayerConfig",
    "PauseVideoOnVisibilityChange",
    "PlayAfterWaitingForDocumentVisibility",
    "PlayVideoOnVisibilityChange",
    "PlayWithoutRAAResults",
    "PostMessengerRequestAborted",
    "PreloadSource",
    "REFRESH_SUBTITLES_ERROR",
    "ReplacedBroadcastAdEnd",
    "ReplacedBroadcastAdPodEnd",
    "ReplacedBroadcastAdPodStart",
    "ReplacedBroadcastAdStart",
    "ReportLog",
    "RequestAutoplaySettingsStart",
    "RequestAutoplaySettingsTime",
    "ResourcesIdle",
    "StreamLog",
    "StreamStopDuringDefineAutoplaySettings",
    "StreamStopWhileChoosingStream",
    "StreamStopWhileDestroyVideoController",
    "StreamStopWhileLoadingMultiroll",
    "StreamStopWhileLoadingPreroll",
    "StreamStopWhilePreoadingPreroll",
    "StreamStopWhileWaitingForDocumentVisibility",
    "StreamStopWhileWaitingForPlay",
    "SkippableFragmentWidgetDrawn",
    "SkippableFragmentWidgetHidden",
    "UsePreloadedHlsJs",
    "UsingDeprecatedProperties",
    "WaitForDocumentVisibility",
    "WaitForPlayCompleted",
    "WaitForUserGesture",
    "XRAY_REQUEST_BOXES_ERROR",
    "paramsObject.version",
    "shaka.Error_7001",
    "shaka.OPERATION_ABORTED_7001",
    "ExternalPlaybackOpenButtonClick",
    "ExternalPlaybackPlayerCsrfFetching",
    "ExternalPlayerListVisibleStatusChange",
    "ExternalPlaybackPlayerListFetching",
    "ExternalPlaybackPlayerCsrfFetchError",
    "ExternalPlaybackPlayerListFetchError",
    "ExternalPlaybackPlayerCsrfFetchSuccess",
    "ExternalPlaybackPlayerListFetchSuccess",
    "ExternalPlaybackCloseButtonClick",
    "ExternalPlaybackPlayerListHasAnyDevice",
    "ExternalPlaybackPlayerActivate",
    "onReady.platform",
    "PlayAdViewers",
    "AdPodLoading",
    "AdStartTime",
    "TempTouchDetectResult",
    "StreamPlayerChooseMetadata",
    "INVALID_METADATA",
    "StreamStopWhilePreloadingPreroll",
    "NonFatalError",
    "UNEXPECTED_FEATURE_NAME",
    "ExternalPlaybackPlayerActivateSucceed",
    "Seek"
);

$goodEvents = AsList(
    "Start", "AdEnd", "AdStart",
    "10SecWatched", "20SecWatched", "30SecHeartbeat", "NULL",
    "IframeReloadSuccess", "End", "SetSource",
    "ContentImpression", "NoFragLoadRecovered", "Stalled_Seek_1"
);

$badEvents = AsList(
    "1002",
    "1003",
    "111",
    "2152398850: Request failed",
    "3015",
    "3016",
    "4012",
    "4032",
    "6001",
    "6002",
    "6006",
    "6007",
    "6008",
    "6012",
    "7001",
    "DEMUXER_ERROR_COULD_NOT_OPEN: FFmpegDemuxer: open context failed",
    "MEDIA_ELEMENT_ERROR: Player load failure: error creating media player",
    "NS_ERROR_DOM_MEDIA_METADATA_ERR (0x806e0006)",
    "DRM_PROXY_ERROR",
    "DRM_ERROR",
    "NO_CHUNK_ERROR",
    "DRM_PROXY_ERROR_SIGNATURE_EXPIRED",
    "FAIRPLAY_CERT_LOAD_ERROR",
    "FAIRPLAY_CREATE_MEDIA_KEYS_ERROR",
    "FAIRPLAY_SPC_LOAD_ERROR",
    "Failed to init decoder",
    "FatalError",
    "HLS_MEDIA_ERROR",
    "HlsJsLoadSourceCalledTwice",
    "INVALID_STREAM_URL",
    "InvalidConfigElementInCreatePlayer",
    "InvalidConfigInCreatePlayer",
    "InvalidFragDuration",
    "LoaderInitError",
    "MEDIA_ELEMENT_ERROR: Format error",
    "MEDIA_ERR_DECODE",
    "MEDIA_ERR_SRC_NOT_SUPPORTED",
    "MEDIA_NOT_PLAYING",
    "MPD_NOT_SUPPORTED_ERROR",
    "MPD_SHAKA_INIT_ERROR",
    "MediaSequenceDrop",
    "NATIVE_ENCODER_NON_FATAL_ERROR",
    "NATIVE_HLS_NOT_SUPPORTED_ERROR",
    "NO_PLAYABLE_STREAMS",
    "NO_MSE",
    "NO_CODECS",
    "NO_DRM",
    "NoFragLoad",
    "ON_TICK_ERROR",
    "PIPELINE_ERROR_DECODE",
    "PIPELINE_ERROR_INITIALIZATION_FAILED",
    "PLAY_AD_VIEWERS_ERROR",
    "POST_MESSAGE_GET_CONFIG_TIMEOUT",
    "PUBLIC_API_CALL_ERROR",
    "RAA_TAKING_10SEC",
    "RAA_TAKING_2SEC",
    "REACT_COMPONENT_DID_CATCH_ERROR_INFO",
    "REGIONAL_LIMITATION_LEVEL",
    "REGIONAL_LIMITATION_MANIFEST",
    "RecoverStreamError",
    "SAGA_ERROR",
    "SCRIPT_INIT_ERROR",
    "STRM_ABD_INVALID_RESPONSE",
    "Stalled",
    "Stalled1",
    "Stalled5",
    "Stalled10",
    "UNABLE_TO_LOAD_PLAYER_IFRAME",
    "UNHANDLED_GLOBAL_ERROR",
    "UNHANDLED_PROMISE_REJECTION",
    "UNSUPPORTED_MEDIA_TYPE",
    "audioTrackLoadError",
    "audioTrackLoadTimeOut",
    "bufferAddCodecError",
    "bufferAppendError",
    "bufferAppendingError",
    "bufferFullError",
    "bufferNudgeOnStall",
    "bufferSeekOverHole",
    "fragLoadError",
    "fragLoadTimeOut",
    "fragParsingError",
    "internalException",
    "keyLoadError",
    "keyLoadTimeOut",
    "levelLoadError",
    "levelLoadTimeOut",
    "manifestLoadError",
    "manifestLoadTimeOut",
    "manifestParsingError",
    "remuxAllocError",
    "shaka.BAD_HTTP_STATUS_1001",
    "shaka.BAD_HTTP_STATUS_1001_LICENSE",
    "shaka.BAD_HTTP_STATUS_1001_MANIFEST",
    "shaka.BAD_HTTP_STATUS_1001_SEGMENT",
    "shaka.CONTENT_UNSUPPORTED_BY_BROWSER_4032",
    "shaka.ERROR_11",
    "shaka.ERROR_undefined",
    "shaka.Error_0",
    "shaka.Error_11",
    "shaka.Error_4032",
    "shaka.FAILED_TO_ATTACH_TO_VIDEO_6003",
    "shaka.FAILED_TO_CREATE_CDM_6002",
    "shaka.FAILED_TO_CREATE_SESSION_6005",
    "shaka.FAILED_TO_GENERATE_LICENSE_REQUEST_6006",
    "shaka.HTTP_ERROR_1002",
    "shaka.HTTP_ERROR_1002_LICENSE",
    "shaka.HTTP_ERROR_1002_MANIFEST",
    "shaka.HTTP_ERROR_1002_SEGMENT",
    "shaka.INVALID_SERVER_CERTIFICATE_6004",
    "shaka.LICENSE_REQUEST_FAILED_6007",
    "shaka.LICENSE_REQUEST_FAILED_DRM_PROXY_ERROR",
    "shaka.LICENSE_REQUEST_FAILED_DRM_PROXY_ERROR_SIGNATURE_EXPIRED",
    "shaka.LICENSE_RESPONSE_REJECTED_6008",
    "shaka.MEDIA_SOURCE_OPERATION_THREW_3015",
    "shaka.NO_LICENSE_SERVER_GIVEN_6012",
    "shaka.QUOTA_EXCEEDED_ERROR_3017",
    "shaka.REQUESTED_KEY_SYSTEM_CONFIG_UNAVAILABLE_6001",
    "shaka.RESPONSE_FILTER_ERROR_1007",
    "shaka.RESTRICTIONS_CANNOT_BE_MET_4012",
    "shaka.TIMEOUT_1003",
    "shaka.TIMEOUT_1003_LICENSE",
    "shaka.TIMEOUT_1003_MANIFEST",
    "shaka.TIMEOUT_1003_SEGMENT",
    "shaka.UNSUPPORTED_SCHEME_1000",
    "shaka.VIDEO_ERROR_3016",
    "Stalled_AdEnd_1",
    "Stalled_AdEnd_10",
    "Stalled_AdEnd_5",
    "Stalled_Init_1",
    "Stalled_Init_10",
    "Stalled_Init_5",
    "Stalled_MediaError_1",
    "Stalled_MediaError_10",
    "Stalled_MediaError_5",
    "Stalled_NoFragLoad_1",
    "Stalled_NoFragLoad_10",
    "Stalled_NoFragLoad_5",
    "Stalled_Offline_1",
    "Stalled_Offline_10",
    "Stalled_Offline_5",
    "Stalled_Other_1",
    "Stalled_Other_10",
    "Stalled_Other_5",
    "Stalled_Recover_1",
    "Stalled_Recover_10",
    "Stalled_Recover_5",
    "Stalled_Seek_10",
    "Stalled_Seek_5",
    "Stalled_SetSource_1",
    "Stalled_SetSource_10",
    "Stalled_SetSource_5",
    "Stalled_VideoTrackChange_1",
    "Stalled_VideoTrackChange_10",
    "Stalled_VideoTrackChange_5",
    "Stalled_REGULAR_1000",
    "Stalled_REGULAR_5000",
    "Stalled_REGULAR_10000",
    "Stalled_INIT_1000",
    "Stalled_INIT_5000",
    "Stalled_INIT_10000",
    "Stalled_Init_1000",
    "Stalled_Init_5000",
    "Stalled_Init_10000",
    "Stalled_Other_1000",
    "Stalled_Other_5000",
    "Stalled_Other_10000",
    "REQUIRED_FEATURE_IS_NOT_IN_BUNDLE",
    "EXTERNAL_POST_MESSENGER_SEND_MESSAGE_ERROR",
    "shaka.MEDIA_SOURCE_OPERATION_FAILED_3014",
    "shaka.EXPIRED_6014",
    "INTERNAL_POST_MESSENGER_SEND_MESSAGE_ERROR",
    "FIRST_LOAD_SOURCE_ERROR",
    "1001"
);

$pairToString = ($pair) -> {
    RETURN (
        (unwrap($pair[0]) ?? "NULL") || "___" || (unwrap($pair[1]) ?? "NULL")
    )
};

$tryGetEventName = ($struct) -> {
    RETURN IF(
        $struct is null,
        "NULL",
        unwrap($struct).EventName
    )
};

$getStrictPair = ($filtered) -> {
    $len = ListLength($filtered);
    RETURN CASE
    WHEN ($len == 0) OR ($filtered is null) THEN AsList(NULL, NULL)
    WHEN $len == 1 THEN AsList(NULL, $tryGetEventName(unwrap($filtered[0])))
    ELSE AsList($tryGetEventName(unwrap($filtered[$len - 2])), $tryGetEventName(unwrap($filtered[$len - 1])))
    END
};

$pairIsBad = ($pair) -> {
    RETURN (
        ($pair is null) or
        ($pair[0] is null and $pair[1] is null)
    )
};

$countUnhappyEnd = ($pair) -> {
    $toUE = ListFlatMap(
        $pair,
        ($x) -> {
            RETURN CASE
            when $x is null then null
            when $x in $goodEvents then 0
            else 1
            end
        }
    );
    RETURN ListSum($toUE) / CAST(ListLength($toUE) as Double)
};

$getUnfilteredPair = ($sorted_events) -> {
    $filtered = ListFilter($sorted_events, ($x) -> {RETURN $x.EventName not in ("DestroyPlayer", "PlayerFrameUnload")});
    RETURN $getStrictPair($filtered)
};

$getStalledEventName = ($Data) -> {
    -- $Data = Yson::ParseJson($Data);
    $dur = Yson::ConvertToInt64(Yson::YPath($Data, "/data/stalledDuration")) ?? CAST(Yson::ConvertToString(Yson::YPath($Data, "/labels/stalledDuration")) AS Int64);
    $reason = Yson::ConvertToString(Yson::YPath($Data, "/labels/reason"));
    RETURN IF(
        $dur IS NOT NULL and $reason is not null,
        "Stalled" || "_" || $reason || "_" || CAST($dur AS String),
        "Stalled"
    )
};

$getCurrentStream = ($Data) -> {
    $Data = Yson::ParseJson($Data);
    $cs = Yson::ConvertToString(Yson::YPath($Data, "/data/currentStream/url"));
    RETURN IF(
        $cs IS NULL OR LENGTH(String::SplitToList($cs, "?")[0]) == 0,
        NULL,
        unwrap(String::SplitToList($cs, "?")[0])
    )
};

$getPairAndCountUE = ($sorted_events) -> {
    $filtered = ListFilter($sorted_events, ($x) -> {RETURN $x.EventName in $badEvents or $x.EventName in $goodEvents});
    $filtered_raw = ListFilter($sorted_events, ($x) -> {RETURN $x.EventName not in $skipEvents});
    $unknown = ListUniq(ListFlatMap(
        $sorted_events, ($x) -> {
            RETURN IF(
                $x.EventName in $goodEvents or $x.EventName in $badEvents or $x.EventName in $skipEvents,
                NULL,
                $x.EventName
            )
        }
    ));
    $pair = $getStrictPair($filtered);
    $pair_raw = $getStrictPair($filtered_raw);
    $anyHb = ListMax(
        ListMap($filtered, ($x) -> {RETURN $x.EventName in ("10SecWatched", "20SecWatched", "30SecHeartbeat")})
    ) ?? false;
    RETURN AsStruct(
        IF($pairIsBad($pair), NULL, $countUnhappyEnd($pair)) as unhappy_end,
        IF($pairIsBad($pair_raw), NULL, $countUnhappyEnd($pair_raw)) as unhappy_end_raw,
        $pairToString($pair) as event_pair,
        $pairToString($pair_raw) as event_pair_raw,
        $unknown as unknown_events,
        $pairToString($getUnfilteredPair($sorted_events)) as event_pair_unfiltered,
        unwrap($anyHb) as has_heartbeat,
        $pair as pair,
        $pairIsBad($pair) as pair_is_bad,
        $filtered as filtered
    )
};

EXPORT $skipEvents, $badEvents, $goodEvents, $pairToString, $tryGetEventName, $getStrictPair, $getUnfilteredPair, $pairIsBad, $countUnhappyEnd, $getStalledEventName, $getCurrentStream, $getPairAndCountUE;
