use hahn;
pragma yt.Pool = "@pool";
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;
pragma library("unhappyend_common.sql");
pragma SimpleColumns;
pragma DisableUnordered;
pragma yson.DisableStrict;
IMPORT unhappyend_common SYMBOLS $skipEvents, $badEvents, $goodEvents, $pairToString, $tryGetEventName, $getStrictPair, $getUnfilteredPair, $pairIsBad, $countUnhappyEnd, $getUnfilteredPair, $getStalledEventName, $getCurrentStream, $getPairAndCountUE;

$by_vsid_table = "@by_vsid_table";
$unhappyend_report_table = "@unhappyend_report_table";
$pairs_report_table = "@pairs_report_table";
$unknown_events_table = "@unknown_events_table";
$date_from = "@date_from";
$date_to = "@date_to";


--@ref_from

$re_RefFrom = Re2::Capture("from(=|%3D|%253D)([a-z_\-]+)");

$getRefFrom = ($x) -> {
    RETURN $ref_from_preprocess($re_RefFrom($x)._2)
};


$wrapTopFreq = ($x) -> {
    RETURN IF(
        $x is null,
        "UNKNOWN",
        unwrap($x).Value ?? "UNKNOWN"
    )
};


$EventNameWrapper = ($EventName, $Data) -> {
    $Data = Yson::ParseJson($Data);
    RETURN CASE
    WHEN $EventName == "Stalled" THEN $getStalledEventName($Data)
    WHEN $EventName IS NULL AND Yson::LookupString($Data, "service") == "ott-smart" THEN Yson::LookupString($Data, "code") ?? "UNKNOWN_ERROR"
    WHEN $EventName IS NULL THEN "NULL"
    ELSE $EventName
    END
};


$getVsid = ($VSID, $Data, $Service) -> {
    RETURN CASE
    WHEN $Service != "ott-smart" OR $VSID IS NOT NULL THEN $VSID
    WHEN $VSID IS NULL THEN Url::GetCGIParam(Yson::ConvertToString(Yson::YPath(Yson::ParseJson($Data), "/data/currentStream/url")), "vsid")
    ELSE NULL
    END
};


$tmp = (
    select
        fielddate,
        vsid,
        ListSort(AGGREGATE_LIST(AsStruct(
            $EventNameWrapper(EventName, Data) as EventName,
            ClientTimestamp as ClientTimestamp,
            $getCurrentStream(Data) as currentStream
        )), ($x) -> {RETURN $x.ClientTimestamp}) as sorted_events,
        MAX(Version) as player_version,
        -- MAX($ref_from_preprocess($getRefFrom(Data))) as ref_from,
        MAX(UserAgent) as user_agent,
        $wrapTopFreq(TOPFREQ(
            Yson::ConvertToString(Yson::YPath(Yson::ParseJson(Data), "/data/connectionQuality")), 1
        )[0]) as connection,
        MAX(ClientIP) as ClientIP
    from range(
        `logs/jstracer-log/1d`, $date_from, $date_to
    )
    where Service in ("StreamPlayer", "ott-smart", "AndroidPlayer")
    and UserAgent NOT LIKE "%AdsBot-Google%"
    and $getVsid(VSID, Data, Service) IS NOT NULL
    group by
        $getVsid(VSID, Data, Service) as vsid,
        ListReverse(String::SplitToList(TablePath(), "/"))[0] as fielddate
    having count(*) < 1000
);

$getPair = ($sorted_events) -> {
    $filtered = ListFilter($sorted_events, ($x) -> {RETURN $x.EventName not in (
        "CanPlay", "LoadStartHavingCurrentData", "DestroyPlayer", "PlayerFrameUnload",
        "CreatePlayer", "SetSource", 
    )});
    RETURN ($filtered[listlength($filtered) - 2].EventName ?? "NULL") || "___" || ($filtered[listlength($filtered) - 1].EventName ?? "NULL")
};

$getProvider = ($ip) -> {
    $ispname = Geo::GetIspNameByIp($ip);
    RETURN IF(
        $ispname is null or Length($ispname) == 0,
        "UNKNOWN",
        $ispname
    )
};


$getLastStream = ($se) -> {
    $se = ListFlatMap(
        $se, ($x) -> {RETURN $x.currentStream}
    );
    RETURN IF(
        ListLength($se) > 0,
        unwrap($se[ListLength($se) - 1]),
        null
    )
};

$countViewTime = ($sorted_events) -> {
    $vt30 = ListLength(ListFilter($sorted_events, ($x) -> {RETURN $x.EventName == "30SecHeartbeat"}));
    $vt20 = ListLength(ListFilter($sorted_events, ($x) -> {RETURN $x.EventName == "20SecWatched"}));
    $vt10 = ListLength(ListFilter($sorted_events, ($x) -> {RETURN $x.EventName == "10SecWatched"}));
    RETURN CASE
    WHEN $vt30 IS NOT NULL AND $vt30 > 0 THEN 30 * $vt30
    WHEN $vt20 IS NOT NULL AND $vt20 > 0 THEN 20
    WHEN $vt10 IS NOT NULL AND $vt10 > 0 THEN 10
    ELSE 0
    END
};

$tmp_plus_last_events = (
    select
        t.*,
        $getPairAndCountUE(sorted_events).event_pair as event_pair,
        $getPairAndCountUE(sorted_events).event_pair_raw as event_pair_raw,
        $getPairAndCountUE(sorted_events).event_pair_unfiltered as event_pair_unfiltered,
        $getPairAndCountUE(sorted_events).unhappy_end as unhappy_end,
        $getPairAndCountUE(sorted_events).unhappy_end_raw as unhappy_end_raw,
        $getPairAndCountUE(sorted_events).unknown_events as unknown_events,
        $getPairAndCountUE(sorted_events).has_heartbeat as has_heartbeat,
        $countViewTime(sorted_events) as view_time,
        $getLastStream(sorted_events) as lastStream,
        UserAgent::Parse(user_agent).OSFamily ?? "Unknown" as os_family,
        UserAgent::Parse(user_agent).BrowserName ?? "Unknown" as browser,
        $getProvider(ClientIP) as provider,
        Geo::RoundRegionByIp(ClientIP, "country").short_en_name ?? "UNK" as country
    from $tmp as t
    where not UserAgent::Parse(user_agent).isRobot
);

$getRefFrom = ($rflist) -> {
    $rflist = ListFilter($rflist, ($x) -> {RETURN $x.ref_from != "-"});
    $goodvcids = ListFilter($rflist, ($x) -> {RETURN $x.video_content_id != "novcid"});
    RETURN CASE
    WHEN ListLength($goodvcids) > 0 THEN $goodvcids[listlength($goodvcids) - 1].ref_from
    WHEN ListLength($rflist) > 0 THEN $rflist[listlength($rflist) - 1].ref_from
    ELSE "unknown"
    END
};

$ref_froms = (
    select
        vsid,
        fielddate,
        $getRefFrom(listsort(aggregate_list_distinct(asstruct(
            ref_from as ref_from,
            video_content_id as video_content_id,
            `timestamp` as ts
        )), ($x) -> {RETURN $x.ts})) as ref_from
    from range(
        `cubes/video-strm`, $date_from, $date_to, `sessions`
    )
    group by
        vsid,
        ListReverse(String::SplitToList(TablePath(), "/"))[1] as fielddate
);

$tmp_joined = (
    select
        t.*,
        ref_from ?? "unknown" as ref_from,
        IF(
            event_pair is not null,
            unwrap(String::SplitToList(event_pair, "___")[0]),
            null
        ) as event1,
        CASE
        WHEN event_pair is null then NULL
        WHEN unwrap(String::SplitToList(event_pair, "___")[0]) in $goodEvents THEN 0
        ELSE 1
        END as event1_value,
        IF(
            event_pair is not null,
            unwrap(String::SplitToList(event_pair, "___")[1]),
            null
        ) as event2,
        CASE
        WHEN event_pair is null then NULL
        WHEN unwrap(String::SplitToList(event_pair, "___")[1]) in $goodEvents THEN 0
        ELSE 1
        END as event2_value
    from $tmp_plus_last_events as t
    left join $ref_froms as r using (fielddate, vsid)
);

insert into $by_vsid_table with truncate
select * from $tmp_joined;

$totalize_unhappyend = ($row) -> {
    $row = AsStruct(
        $row.fielddate as fielddate,
        $row.unhappy_end as unhappy_end,
        $row.unhappy_end_raw as unhappy_end_raw,
        $row.view_time as view_time,
        CAST($row.has_heartbeat as String) as has_heartbeat,
        $row.os_family as os_family,
        $row.browser as browser,
        $row.provider as provider,
        $row.country as country,
        $row.ref_from as ref_from,
        $row.player_version as player_version
    );
    $totaled = AsStruct(
        $row.fielddate as fielddate,
        $row.unhappy_end as unhappy_end,
        $row.unhappy_end_raw as unhappy_end_raw,
        $row.view_time as view_time,
        "_total_" as has_heartbeat,
        "_total_" as os_family,
        "_total_" as browser,
        "_total_" as provider,
        "_total_" as country,
        "_total_" as ref_from,
        "_total_" as player_version
    );
    $result = AsList(
        $row,
        $totaled,
        ExpandStruct(
            RemoveMember(RemoveMember(RemoveMember(
                $totaled, "ref_from"
            ), "os_family"), "browser"),
            $row.ref_from as ref_from,
            $row.os_family as os_family,
            $row.browser as browser
        ),
        ExpandStruct(
            RemoveMember(RemoveMember(
                $totaled, "ref_from"
            ), "os_family"),
            $row.ref_from as ref_from,
            $row.os_family as os_family
        ),
        ExpandStruct(
            RemoveMember(RemoveMember(RemoveMember(
                $totaled, "ref_from"
            ), "os_family"), "has_heartbeat"),
            $row.ref_from as ref_from,
            $row.os_family as os_family,
            $row.has_heartbeat as has_heartbeat
        ),
        ExpandStruct(
            RemoveMember(RemoveMember(RemoveMember(
                $totaled, "ref_from"
            ), "os_family"), "player_version"),
            $row.ref_from as ref_from,
            $row.os_family as os_family,
            $row.player_version as player_version
        ),
        ExpandStruct(
            RemoveMember(RemoveMember(RemoveMember(
                $totaled, "ref_from"
            ), "os_family"), "country"),
            $row.ref_from as ref_from,
            $row.os_family as os_family,
            $row.country as country
        ),
        ExpandStruct(
            RemoveMember(RemoveMember(RemoveMember(
                $totaled, "ref_from"
            ), "os_family"), "provider"),
            $row.ref_from as ref_from,
            $row.os_family as os_family,
            $row.provider as provider
        )
    );
    $extend = ListFlatMap(
        $result, ($x) -> {RETURN IF(
            $x.ref_from in ("morda", "videohub", "efir", "streamhandler_other"),
            AddMember(RemoveMember($x, "ref_from"), "ref_from", "Эфир"),
            NULL
        )}
    );
    $result = ListUnionAll($result, $extend);
    $extend = ListFlatMap(
        $result, ($x) -> {RETURN IF(
            $x.ref_from in ("morda_touch", "videohub_touch", "efir_touch", "streamhandler_appsearch"),
            AddMember(RemoveMember($x, "ref_from"), "ref_from", "Эфир"),
            NULL
        )}
    );
    $result = ListUnionAll($result, $extend);
    RETURN $result
};

$reduce_unhappyend = (
    select
        fielddate,
        ref_from,
        os_family,
        browser,
        provider,
        country,
        has_heartbeat,
        player_version,
        AVG(unhappy_end) as unhappy_end,
        AVG_IF(unhappy_end, unhappy_end is not null AND view_time >= 600) as unhappy_end_10minplus,
        AVG(unhappy_end_raw) as unhappy_end_raw,
        COUNT_IF(unhappy_end is not null) as `count`,
        COUNT_IF(unhappy_end == 1) / COUNT_IF(unhappy_end IS NOT NULL) as good_sessions_share,
        COUNT_IF(unhappy_end == 0) / COUNT_IF(unhappy_end IS NOT NULL) as bad_sessions_share,
        COUNT_IF(unhappy_end == 0.5) / COUNT_IF(unhappy_end IS NOT NULL) as half_sessions_share,
        COUNT(*) as count_total,
        COUNT_IF(unhappy_end is null) as count_skipped
    from (
        process $tmp_joined using $totalize_unhappyend(TableRow())
    )
    group by
        fielddate,
        ref_from,
        os_family,
        browser,
        provider,
        country,
        has_heartbeat,
        player_version
    having count(*) > 1000 and count(*) != count_if(unhappy_end is null)
);

insert into $unhappyend_report_table with truncate
select * from $reduce_unhappyend;

$totalize_pairs = ($row) -> {
    $row = AsStruct(
        $row.fielddate as fielddate,
        cast($row.has_heartbeat as string) as has_heartbeat,
        $row.ref_from as ref_from,
        $row.os_family as os_family,
        $row.browser as browser,
        IF(
            $row.unhappy_end_raw is null,
            $row.event_pair_unfiltered,
            $row.event_pair_raw
        ) as event_pair
    );
    $totaled = AsStruct(
        $row.fielddate as fielddate,
        "_total_" as ref_from,
        "_total_" as os_family,
        "_total_" as browser,
        "_total_" as has_heartbeat,
        $row.event_pair as event_pair
    );
    $result = AsList(
        $row,
        $totaled,
        ExpandStruct(
            RemoveMember(RemoveMember($totaled, "ref_from"), "os_family"),
            $row.ref_from as ref_from,
            $row.os_family as os_family
        ),
        ExpandStruct(
            RemoveMember(RemoveMember($totaled, "ref_from"), "has_heartbeat"),
            $row.ref_from as ref_from,
            $row.has_heartbeat as has_heartbeat
        ),
        ExpandStruct(
            RemoveMember(RemoveMember(RemoveMember($totaled, "ref_from"), "os_family"), "has_heartbeat"),
            $row.ref_from as ref_from,
            $row.os_family as os_family,
            $row.has_heartbeat as has_heartbeat
        ),
        AddMember(
            RemoveMember($totaled, "ref_from"), "ref_from", $row.ref_from
        ),
        AddMember(
            RemoveMember($totaled, "os_family"), "os_family", $row.os_family
        ),
        AddMember(
            RemoveMember($totaled, "browser"), "browser", $row.browser
        )
    );
    $extend = ListFlatMap(
        $result, ($x) -> {RETURN IF(
            $x.ref_from in ("morda", "videohub", "efir", "streamhandler_other", "morda_touch", "videohub_touch", "efir_touch", "streamhandler_appsearch"),
            AddMember(RemoveMember($x, "ref_from"), "ref_from", "Эфир"),
            NULL
        )}
    );
    $result = ListUnionAll($result, $extend);
    RETURN $result
};


$getUEValuePairs = ($str_pair) -> {
    $pair_as_list = String::SplitToList($str_pair, "___");
    $filtered = ListFilter($pair_as_list, ($x) -> {RETURN $x in $badEvents or $x in $goodEvents});
    RETURN CASE
    WHEN ListLength($filtered) == 2 THEN cast($countUnhappyEnd($filtered) as String)
    WHEN ListLength($filtered) == 1 THEN cast($countUnhappyEnd(AsList(NULL, unwrap($filtered[0]))) as String)
    ELSE "skip"
    END
};

$reduce_pairs = (
    select
        fielddate,
        ref_from,
        os_family,
        browser,
        event_pair,
        has_heartbeat,
        COUNT(*) as `count`,
        $getUEValuePairs(event_pair) as unhappyend_value
    from (process $tmp_joined using $totalize_pairs(TableRow()))
    group by
        fielddate,
        ref_from,
        os_family,
        browser,
        event_pair,
        has_heartbeat
    having count(*) > 1000
);

insert into $pairs_report_table with truncate
select * from $reduce_pairs;

insert into $unknown_events_table with truncate
select
    unknown_events, count(*) as `count`
from (
    select unknown_events
    from $tmp_plus_last_events
    flatten by unknown_events
)
group by unknown_events
order by `count` desc;