use hahn;
pragma yt.Pool = "@pool";
pragma yt.PoolTrees = "physical";
pragma yt.TentativePoolTrees = "cloud";
pragma SimpleColumns;
pragma yson.DisableStrict;

$date_from = "@date_from";
$date_to = "@date_to";

pragma yt.DataSizePerMapJob = "4G";

--@ref_from

$pv_capture = Re2::Capture("1\.0-[0-9]{3}");

$extract_pv = ($add_info) -> {
    RETURN $pv_capture(
        Yson::LookupString($add_info, "referer")
    )._0 ?? $pv_capture(
        Yson::LookupString($add_info, "request")
    )._0
};

$process_player_version = ($pv, $add_info) -> {
    RETURN IF(
        $pv IS NOT NULL AND $pv != "-", $pv, $extract_pv($add_info) ?? "-"
    )
};

-- $source__ = (
$source = (
    select
        ListReverse(String::SplitToList(TablePath(), "/"))[1] as fielddate,
        yu_hash,
        `timestamp`,
        fatal,
        error_id,
        vsid,
        video_content_id,
        yandexuid,
        event,
        provider,
        region,
        device_type,
        country,
        os_family,
        browser_name,
        view_type,
        ref_from,
        player_version,
        source,
        add_info,
    from range(
        `cubes/video-strm`, $date_from, $date_to, `preprocessed`
    ) as s
);

$getHb = ($ai) -> {
    RETURN Yson::LookupString($ai, "heartbeat_src")
};

$refreshes_map = (
    select
        fielddate,
        yu_hash,
        `timestamp`,
        vsid,
        video_content_id
    from $source
    where source != "redir"
    and yu_hash is not null
    and yu_hash != "-"
    and yu_hash != ""
    and yandexuid != "undefined"
    and video_content_id != ""
    and video_content_id != "-"
    and video_content_id != "novcid"
    and video_content_id is not null
);

$blacklist = (
    select fielddate, yu_hash
    from $refreshes_map
    group by fielddate, yu_hash
    having count(*) > 300000
);

$refreshes_reduce0 = (
    select *
    from $refreshes_map as r
    left only join $blacklist as b using (fielddate, yu_hash)
);

$refreshes_reduce1 = (
    select
        fielddate,
        yu_hash,
        vsid,
        `timestamp`,
        lead(`timestamp`) over w as next_ts,
        lead(vsid) over w as next_vsid,
        lead(video_content_id) over w as next_vcid,
        video_content_id
    from $refreshes_reduce0 as t
    window w as (
        partition by fielddate, yu_hash
        order by `timestamp`
    )
);

$refreshes_reduce2 = (
    select
        fielddate, vsid
    from $refreshes_reduce1
    where video_content_id == next_vcid
    and vsid != next_vsid
    and vsid is not null
    and next_vsid is not null
    and (next_ts - `timestamp`) <= 60 * 5
);

$refreshes_grouped = (
    select
        fielddate, vsid,
        1 as refreshes
    from $refreshes_reduce2
    group by fielddate, vsid
);

$view_time_map = (
    select
        vsid,
        fielddate,
        IF(event == "start", 0, NULL) as viewTime_Start,
        IF(event == "heartbeat" and source == "redir", 30, NULL) as viewTime30_Redir,
        IF(event == "heartbeat" and source == "js_tracer" and $getHb(add_info) == "10SecWatched", 10, NULL) as viewTime10_JsTracer,
        IF(event == "heartbeat" and source == "js_tracer" and $getHb(add_info) == "20SecWatched", 20, NULL) as viewTime20_JsTracer,
        IF(event == "heartbeat" and source == "js_tracer" and $getHb(add_info) == "30SecHeartbeat", 30, NULL) as viewTime30_JsTracer,
        IF(event == "heartbeat" and source == "strm" and $getHb(add_info) == "10SecWatched", 10, NULL) as viewTime10_Strm,
        IF(event == "heartbeat" and source == "strm" and $getHb(add_info) == "20SecWatched", 20, NULL) as viewTime20_Strm,
        IF(event == "heartbeat" and source == "strm" and $getHb(add_info) == "30SecHeartbeat", 30, NULL) as viewTime30_Strm,
        IF(event == "chunk", `timestamp`, NULL) as chunk_ts,
        provider,
        region,
        device_type,
        country,
        os_family,
        browser_name,
        view_type,
        $ref_from_preprocess(ref_from) as ref_from,
        $process_player_version(player_version, add_info) as player_version,
        IF(event == "heartbeat", `timestamp`, NULL) as hb_ts,
        IF(event == "start", `timestamp`, NULL) as start_ts
    from $source as s
    where event == "heartbeat" or event == "start" or event == "chunk"
);

$view_time_reduce_1 = (
    select
        vsid, fielddate,
        SUM(viewTime_Start) as viewTime_Start,
        SUM(viewTime30_Redir) as viewTime30_Redir,
        SUM(viewTime10_JsTracer) as viewTime10_JsTracer,
        SUM(viewTime20_JsTracer) as viewTime20_JsTracer,
        SUM(viewTime30_JsTracer) as viewTime30_JsTracer,
        SUM(viewTime10_Strm) as viewTime10_Strm,
        SUM(viewTime20_Strm) as viewTime20_Strm,
        SUM(viewTime30_Strm) as viewTime30_Strm,
        MIN(chunk_ts) as min_chunk_ts,
        MIN(hb_ts) as min_hb_ts,
        MAX(chunk_ts) as max_chunk_ts,
        MAX(hb_ts) as max_hb_ts,
        MAX(provider) as provider,
        MAX(region) as region,
        MAX(country) as country,
        MAX(device_type) as device_type,
        MAX(os_family) as os_family,
        MAX(browser_name) as browser_name,
        MAX(player_version) as player_version,
        MAX(ref_from) as ref_from,
        MIN(start_ts) as start_ts,
        MAX(view_type) as view_type
    FROM $view_time_map
    group by fielddate, vsid
);


$vcids_pre = (
    select
        fielddate, vsid, video_content_id
    from $source
);
$vcids = (
    select
        fielddate, vsid, video_content_id
    from $vcids_pre
    group by fielddate, vsid, video_content_id
);

$channels = (
    select JoinKey as video_content_id,
    computed_channel as channel
    from `//home/videolog/strm_meta/iron_branch/concat`
);

$channels_joined = (
    select
        fielddate,
        a.video_content_id as video_content_id,
        vsid,
        channel
    from $vcids as a
    inner join $channels as b
    using (video_content_id)
);

$processChannels = ($chlist) -> {
    RETURN CASE
    WHEN ListLength($chlist) == 1 THEN $chlist[0]
    WHEN ListLength($chlist) == 0 THEN "NO_CHANNEL"
    WHEN ListLength($chlist) > 1 THEN "MULTIPLE"
    ELSE "NO_CHANNEL"
    END
};

$channels_joined_filtered = (
    select
        fielddate,
        vsid,
        $processChannels(AGGREGATE_LIST(DISTINCT channel)) as channel
    from $channels_joined
    group by fielddate, vsid
);

$extractViewType = ($sd) -> {
    RETURN String::ToLower(
        Yson::ConvertToString(Yson::YPath($sd, "/Data/data/videoType"))
    )
};

$viewTypeMap = (
    select
        fielddate,
        vsid,
        "unknown" as view_type
    from $source
    where source == "js_tracer" and (
        event == "heartbeat" or event == "start"
    )
);

$processViewTypes = ($vtlist) -> {
    RETURN CASE
    WHEN ListLength($vtlist) == 1 THEN $vtlist[0]
    WHEN ListLength($vtlist) > 1 THEN "multiple"
    ELSE NULL
    END
};

$viewTypeReduce = (
    select
        fielddate,
        vsid,
        $processViewTypes(AGGREGATE_LIST(DISTINCT view_type)) as view_type
    from $viewTypeMap
    group by fielddate, vsid
);

--$getViewTime = ($jstlist, $strmlist, $redir, $chunks) -> {
$getViewTime = (
    $j10, $j20, $j30,
    $s10, $s20, $s30,
    $redir, $chunks
) -> {
    $jst = ListMax(AsList($j10, $j20, $j30));
    $strm = ListMax(AsList($s10, $s20, $s30));
    $minhb = ListMin(AsList($jst, $strm, $redir));
    RETURN IF($minhb IS NOT NULL, unwrap($minhb), $chunks)
};

$processVcids = ($vcidlist) -> {
    $vcidlist = ListFlatMap($vcidlist, ($x) -> {RETURN IF(
        $x IS NOT NULL AND NOT ListHas(AsList("", "novcid"), $x), $x, NULL
    )});
    RETURN CASE
    WHEN ListLength($vcidlist) == 0 THEN "NO_CHANNEL"
    WHEN ListLength($vcidlist) == 1 THEN $vcidlist[0]
    ELSE "multiple"
    END
};

$view_time_reduce_2 = (
    select
        vsid,
        fielddate,
        viewTime_Start,
        $getViewTime(
            viewTime10_JsTracer,
            viewTime20_JsTracer,
            viewTime30_JsTracer,
            viewTime10_Strm,
            viewTime20_Strm,
            viewTime30_Strm,
            viewTime30_Redir,
            max_chunk_ts - min_chunk_ts
        ) as viewTime,
        MAX_OF(max_chunk_ts, max_hb_ts) AS fatal_threshold,
        IF(start_ts IS NOT NULL, start_ts, min_chunk_ts) as start_ts,
        provider,
        region,
        device_type,
        country,
        os_family,
        browser_name,
        ref_from,
        player_version,
        view_type
    from $view_time_reduce_1
);

$included_fatals = AsList(
    "113", "bufferAppendError", "fragLoadError",
    "fragLoadTimeOut", "internalException", "manifestLoadTimeOut"
);

$get_adtype = ($x) -> {
    RETURN Yson::ConvertToString(
        Yson::YPath($x, "/error_details/details/adType")
    )
};

$wrap_error_id = ($x) -> {
    RETURN IF($x LIKE "%_fatal", String::ReplaceAll($x, "_fatal", ""), $x)
};

$error_map = (
    select
        vsid,
        fielddate,
        IF(fatal == true, `timestamp`, NULL) as fatal_timestamp,
        IF(fatal == true, 1, NULL) as fatal,
        IF($wrap_error_id(error_id) LIKE "Stalled%", `timestamp`, NULL) as Stalled_timestamp,
        IF($wrap_error_id(error_id) LIKE "Stalled%", 1, NULL) as Stalled,
        IF($wrap_error_id(error_id) == "Stalled_Other", `timestamp`, NULL) as Stalled_Other_timestamp,
        IF($wrap_error_id(error_id) == "Stalled_Other", 1, NULL) as Stalled_Other,
        IF($wrap_error_id(error_id) == "Stalled_Init", `timestamp`, NULL) as Stalled_Init_timestamp,
        IF($wrap_error_id(error_id) == "Stalled_Init", 1, NULL) as Stalled_Init,
        IF($wrap_error_id(error_id) == "Stalled_AdEnd" and $get_adtype(add_info) == "midroll", 1, NULL) as Stalled_AdEnd_midroll,
        IF($wrap_error_id(error_id) == "Stalled_AdEnd" and $get_adtype(add_info) == "midroll", `timestamp`, NULL) as Stalled_AdEnd_midroll_timestamp,
        IF($wrap_error_id(error_id) == "Stalled_AdEnd" and $get_adtype(add_info) == "notReplaced", 1, NULL) as Stalled_AdEnd_notReplaced,
        IF($wrap_error_id(error_id) == "Stalled_AdEnd" and $get_adtype(add_info) == "notReplaced", `timestamp`, NULL) as Stalled_AdEnd_notReplaced_timestamp,
        IF($wrap_error_id(error_id) == "Stalled_AdEnd" and $get_adtype(add_info) == "postroll", 1, NULL) as Stalled_AdEnd_postroll,
        IF($wrap_error_id(error_id) == "Stalled_AdEnd" and $get_adtype(add_info) == "postroll", `timestamp`, NULL) as Stalled_AdEnd_postroll_timestamp,
        IF($wrap_error_id(error_id) == "Stalled_AdEnd" and $get_adtype(add_info) == "preroll", 1, NULL) as Stalled_AdEnd_preroll,
        IF($wrap_error_id(error_id) == "Stalled_AdEnd" and $get_adtype(add_info) == "preroll", `timestamp`, NULL) as Stalled_AdEnd_preroll_timestamp,
        IF($wrap_error_id(error_id) == "Stalled_AdEnd" and ($get_adtype(add_info) == "unknown" or $get_adtype(add_info) IS NULL), 1, NULL) as Stalled_AdEnd_unknown,
        IF($wrap_error_id(error_id) == "Stalled_AdEnd" and ($get_adtype(add_info) == "unknown" or $get_adtype(add_info) IS NULL), `timestamp`, NULL) as Stalled_AdEnd_unknown_timestamp,
        IF($wrap_error_id(error_id) == "Stalled_MediaError", `timestamp`, NULL) as Stalled_MediaError_timestamp,
        IF($wrap_error_id(error_id) == "Stalled_MediaError", 1, NULL) as Stalled_MediaError,
        IF($wrap_error_id(error_id) == "Stalled_NoFragLoad", `timestamp`, NULL) as Stalled_NoFragLoad_timestamp,
        IF($wrap_error_id(error_id) == "Stalled_NoFragLoad", 1, NULL) as Stalled_NoFragLoad,
        IF($wrap_error_id(error_id) == "Stalled_Offline", `timestamp`, NULL) as Stalled_Offline_timestamp,
        IF($wrap_error_id(error_id) == "Stalled_Offline", 1, NULL) as Stalled_Offline,
        IF($wrap_error_id(error_id) == "Stalled_Recover", `timestamp`, NULL) as Stalled_Recover_timestamp,
        IF($wrap_error_id(error_id) == "Stalled_Recover", 1, NULL) as Stalled_Recover,
        IF($wrap_error_id(error_id) == "Stalled_Seek", `timestamp`, NULL) as Stalled_Seek_timestamp,
        IF($wrap_error_id(error_id) == "Stalled_Seek", 1, NULL) as Stalled_Seek,
        IF($wrap_error_id(error_id) == "Stalled_SetSource", `timestamp`, NULL) as Stalled_SetSource_timestamp,
        IF($wrap_error_id(error_id) == "Stalled_SetSource", 1, NULL) as Stalled_SetSource,
        IF($wrap_error_id(error_id) == "Stalled_VideoTrackChange", `timestamp`, NULL) as Stalled_VideoTrackChange_timestamp,
        IF($wrap_error_id(error_id) == "Stalled_VideoTrackChange", 1, NULL) as Stalled_VideoTrackChange,
        IF($wrap_error_id(error_id) == "113", `timestamp`, NULL) as `113_timestamp`,
        IF($wrap_error_id(error_id) == "113", 1, NULL) as `113`,
        IF($wrap_error_id(error_id) == "bufferAppendError", `timestamp`, NULL) as bufferAppendError_timestamp,
        IF($wrap_error_id(error_id) == "bufferAppendError", 1, NULL) as bufferAppendError,
        IF($wrap_error_id(error_id) == "fragLoadError", `timestamp`, NULL) as fragLoadError_timestamp,
        IF($wrap_error_id(error_id) == "fragLoadError", 1, NULL) as fragLoadError,
        IF($wrap_error_id(error_id) == "fragLoadTimeOut", `timestamp`, NULL) as fragLoadTimeOut_timestamp,
        IF($wrap_error_id(error_id) == "fragLoadTimeOut", 1, NULL) as fragLoadTimeOut,
        IF($wrap_error_id(error_id) == "internalException", `timestamp`, NULL) as internalException_timestamp,
        IF($wrap_error_id(error_id) == "internalException", 1, NULL) as internalException,
        IF($wrap_error_id(error_id) == "manifestLoadTimeOut", `timestamp`, NULL) as manifestLoadTimeOut_timestamp,
        IF($wrap_error_id(error_id) == "manifestLoadTimeOut", 1, NULL) as manifestLoadTimeOut,
        IF(fatal == true and not ListHas($included_fatals, $wrap_error_id(error_id)), `timestamp`, NULL) as fatal_other_timestamp,
        IF(fatal == true and not ListHas($included_fatals, $wrap_error_id(error_id)), 1, NULL) as fatal_other,
        provider,
        region,
        country,
        device_type,
        os_family,
        browser_name,
        view_type,
        $ref_from_preprocess(ref_from) as ref_from,
        $process_player_version(player_version, add_info) as player_version
    from $source
    where event == "error"
);

$error_reduce = (
    select
        vsid,
        fielddate,
        SUM(`fatal`) as `fatal`,
        IF(SUM(`fatal`)>0,1,0) as `fatal_bin`,
        SUM(`Stalled`) as `Stalled`,
        IF(SUM(`Stalled`)>0,1,0) as `Stalled_bin`,
        SUM(`Stalled_Other`) as `Stalled_Other`,
        IF(SUM(`Stalled_Other`)>0,1,0) as `Stalled_Other_bin`,
        SUM(`Stalled_Init`) as `Stalled_Init`,
        IF(SUM(`Stalled_Init`)>0,1,0) as `Stalled_Init_bin`,
        SUM(`Stalled_AdEnd_midroll`) as `Stalled_AdEnd_midroll`,
        IF(SUM(`Stalled_AdEnd_midroll`)>0,1,0) as `Stalled_AdEnd_midroll_bin`,
        SUM(`Stalled_AdEnd_notReplaced`) as `Stalled_AdEnd_notReplaced`,
        IF(SUM(`Stalled_AdEnd_notReplaced`)>0,1,0) as `Stalled_AdEnd_notReplaced_bin`,
        SUM(`Stalled_AdEnd_preroll`) as `Stalled_AdEnd_preroll`,
        IF(SUM(`Stalled_AdEnd_preroll`)>0,1,0) as `Stalled_AdEnd_preroll_bin`,
        SUM(`Stalled_AdEnd_postroll`) as `Stalled_AdEnd_postroll`,
        IF(SUM(`Stalled_AdEnd_postroll`)>0,1,0) as `Stalled_AdEnd_postroll_bin`,
        SUM(`Stalled_AdEnd_unknown`) as `Stalled_AdEnd_unknown`,
        IF(SUM(`Stalled_AdEnd_unknown`)>0,1,0) as `Stalled_AdEnd_unknown_bin`,
        SUM(`Stalled_MediaError`) as `Stalled_MediaError`,
        IF(SUM(`Stalled_MediaError`)>0,1,0) as `Stalled_MediaError_bin`,
        SUM(`Stalled_NoFragLoad`) as `Stalled_NoFragLoad`,
        IF(SUM(`Stalled_NoFragLoad`)>0,1,0) as `Stalled_NoFragLoad_bin`,
        SUM(`Stalled_Offline`) as `Stalled_Offline`,
        IF(SUM(`Stalled_Offline`)>0,1,0) as `Stalled_Offline_bin`,
        SUM(`Stalled_Recover`) as `Stalled_Recover`,
        IF(SUM(`Stalled_Recover`)>0,1,0) as `Stalled_Recover_bin`,
        SUM(`Stalled_Seek`) as `Stalled_Seek`,
        IF(SUM(`Stalled_Seek`)>0,1,0) as `Stalled_Seek_bin`,
        SUM(`Stalled_SetSource`) as `Stalled_SetSource`,
        IF(SUM(`Stalled_SetSource`)>0,1,0) as `Stalled_SetSource_bin`,
        SUM(`Stalled_VideoTrackChange`) as `Stalled_VideoTrackChange`,
        IF(SUM(`Stalled_VideoTrackChange`)>0,1,0) as `Stalled_VideoTrackChange_bin`,
        SUM(`113`) as `113`,
        IF(SUM(`113`)>0,1,0) as `113_bin`,
        SUM(`bufferAppendError`) as `bufferAppendError`,
        IF(SUM(`bufferAppendError`)>0,1,0) as `bufferAppendError_bin`,
        SUM(`fragLoadError`) as `fragLoadError`,
        IF(SUM(`fragLoadError`)>0,1,0) as `fragLoadError_bin`,
        SUM(`fragLoadTimeOut`) as `fragLoadTimeOut`,
        IF(SUM(`fragLoadTimeOut`)>0,1,0) as `fragLoadTimeOut_bin`,
        SUM(`internalException`) as `internalException`,
        IF(SUM(`internalException`)>0,1,0) as `internalException_bin`,
        SUM(`manifestLoadTimeOut`) as `manifestLoadTimeOut`,
        IF(SUM(`manifestLoadTimeOut`)>0,1,0) as `manifestLoadTimeOut_bin`,
        SUM(`fatal_other`) as `fatal_other`,
        IF(SUM(`fatal_other`)>0,1,0) as `fatal_other_bin`,
        MAX(Stalled_AdEnd_midroll_timestamp) as Stalled_AdEnd_midroll_timestamp_max,
        MIN(Stalled_AdEnd_midroll_timestamp) as Stalled_AdEnd_midroll_timestamp_min,
        MAX(Stalled_AdEnd_notReplaced_timestamp) as Stalled_AdEnd_notReplaced_timestamp_max,
        MIN(Stalled_AdEnd_notReplaced_timestamp) as Stalled_AdEnd_notReplaced_timestamp_min,
        MAX(Stalled_AdEnd_preroll_timestamp) as Stalled_AdEnd_preroll_timestamp_max,
        MIN(Stalled_AdEnd_preroll_timestamp) as Stalled_AdEnd_preroll_timestamp_min,
        MAX(Stalled_AdEnd_postroll_timestamp) as Stalled_AdEnd_postroll_timestamp_max,
        MIN(Stalled_AdEnd_postroll_timestamp) as Stalled_AdEnd_postroll_timestamp_min,
        MAX(Stalled_AdEnd_unknown_timestamp) as Stalled_AdEnd_unknown_timestamp_max,
        MIN(Stalled_AdEnd_unknown_timestamp) as Stalled_AdEnd_unknown_timestamp_min,
        MAX(fatal_timestamp) as fatal_timestamp_max,
        MIN(fatal_timestamp) as fatal_timestamp_min,
        MAX(Stalled_timestamp) as Stalled_timestamp_max,
        MIN(Stalled_timestamp) as Stalled_timestamp_min,
        MAX(Stalled_Other_timestamp) as Stalled_Other_timestamp_max,
        MIN(Stalled_Other_timestamp) as Stalled_Other_timestamp_min,
        MAX(Stalled_Init_timestamp) as Stalled_Init_timestamp_max,
        MIN(Stalled_Init_timestamp) as Stalled_Init_timestamp_min,
        MAX(Stalled_MediaError_timestamp) as Stalled_MediaError_timestamp_max,
        MIN(Stalled_MediaError_timestamp) as Stalled_MediaError_timestamp_min,
        MAX(Stalled_NoFragLoad_timestamp) as Stalled_NoFragLoad_timestamp_max,
        MIN(Stalled_NoFragLoad_timestamp) as Stalled_NoFragLoad_timestamp_min,
        MAX(Stalled_Offline_timestamp) as Stalled_Offline_timestamp_max,
        MIN(Stalled_Offline_timestamp) as Stalled_Offline_timestamp_min,
        MAX(Stalled_Recover_timestamp) as Stalled_Recover_timestamp_max,
        MIN(Stalled_Recover_timestamp) as Stalled_Recover_timestamp_min,
        MAX(Stalled_Seek_timestamp) as Stalled_Seek_timestamp_max,
        MIN(Stalled_Seek_timestamp) as Stalled_Seek_timestamp_min,
        MAX(Stalled_SetSource_timestamp) as Stalled_SetSource_timestamp_max,
        MIN(Stalled_SetSource_timestamp) as Stalled_SetSource_timestamp_min,
        MAX(Stalled_VideoTrackChange_timestamp) as Stalled_VideoTrackChange_timestamp_max,
        MIN(Stalled_VideoTrackChange_timestamp) as Stalled_VideoTrackChange_timestamp_min,
        MAX(`113_timestamp`) as `113_timestamp_max`,
        MIN(`113_timestamp`) as `113_timestamp_min`,
        MAX(bufferAppendError_timestamp) as bufferAppendError_timestamp_max,
        MIN(bufferAppendError_timestamp) as bufferAppendError_timestamp_min,
        MAX(fragLoadError_timestamp) as fragLoadError_timestamp_max,
        MIN(fragLoadError_timestamp) as fragLoadError_timestamp_min,
        MAX(fragLoadTimeOut_timestamp) as fragLoadTimeOut_timestamp_max,
        MIN(fragLoadTimeOut_timestamp) as fragLoadTimeOut_timestamp_min,
        MAX(internalException_timestamp) as internalException_timestamp_max,
        MIN(internalException_timestamp) as internalException_timestamp_min,
        MAX(manifestLoadTimeOut_timestamp) as manifestLoadTimeOut_timestamp_max,
        MIN(manifestLoadTimeOut_timestamp) as manifestLoadTimeOut_timestamp_min,
        MAX(fatal_other_timestamp) as fatal_other_timestamp_max,
        MIN(fatal_other_timestamp) as fatal_other_timestamp_min,
        MAX(provider) as provider,
        MAX(region) as region,
        MAX(country) as country,
        MAX(os_family) as os_family,
        MAX(device_type) as device_type,
        MAX(browser_name) as browser_name,
        MAX(player_version) as player_version,
        MAX(view_type) as view_type
    from $error_map
    group by vsid, fielddate
);

$getRefFrom = ($rflist) -> {
    $rflist = ListFilter($rflist, ($x) -> {RETURN $x.ref_from != "-"});
    $goodvcids = ListFilter($rflist, ($x) -> {RETURN $x.video_content_id != "novcid"});
    RETURN CASE
    WHEN ListLength($goodvcids) > 0 THEN $goodvcids[listlength($goodvcids) - 1].ref_from
    WHEN ListLength($rflist) > 0 THEN $rflist[listlength($rflist) - 1].ref_from
    ELSE "-"
    END
};

$ref_froms = (
    select
        vsid,
        fielddate,
        MAX(view_type_player) ?? "unknown" as view_type_player,
        MAX(ref_from) as ref_from
    from range(
        `cubes/video-strm`, $date_from, $date_to, `sessions`
    ) with columns Struct<'view_type_player':String?>
    group by
        vsid,
        ListReverse(String::SplitToList(TablePath(), "/"))[1] as fielddate
);

$joined = (
    select
        ch.channel as channel,
        refreshes.refreshes as refreshes,
        vt.provider ?? err.provider as provider,
        vt.region ?? err.region as region,
        vt.country ?? err.country as country,
        vt.os_family ?? err.os_family as os_family,
        vt.browser_name ?? err.browser_name as browser_name,
        vt.device_type ?? err.device_type as device_type,
        vt.player_version ?? err.player_version as player_version,
        sess.view_type_player ?? vt.view_type ?? err.view_type ?? "unknown" as view_type,
        sess.ref_from ?? "unknown" as ref_from,
        err.*,
        vt.* WITHOUT
            vt.browser_name, err.browser_name, vt.country, err.country,
            vt.os_family, err.os_family, vt.player_version, err.player_version,
            vt.provider, err.provider, vt.region, err.region,
            err.vsid, err.fielddate, vt.device_type, err.device_type,
            vt.view_type, err.view_type, vt.ref_from
    from $view_time_reduce_2 as vt
    left join $error_reduce as err
    on (vt.fielddate == err.fielddate and vt.vsid == err.vsid)
    left join $channels_joined_filtered as ch
    on (vt.fielddate == ch.fielddate and vt.vsid == ch.vsid)
    left join $refreshes_grouped as refreshes
    on (vt.fielddate == refreshes.fielddate and vt.vsid == refreshes.vsid)
    left join $ref_froms as sess
    on (vt.fielddate == sess.fielddate and vt.vsid == sess.vsid)
);

$joined2 = (
    select
        j.*,
        IF(`fatal_timestamp_max` > (start_ts + viewTime),1,0) as `fatal_binf`,
        IF(`Stalled_timestamp_max` > (start_ts + viewTime),1,0) as `Stalled_binf`,
        IF(`Stalled_Other_timestamp_max` > (start_ts + viewTime),1,0) as `Stalled_Other_binf`,
        IF(`Stalled_Init_timestamp_max` > (start_ts + viewTime),1,0) as `Stalled_Init_binf`,
        IF(`Stalled_AdEnd_preroll_timestamp_max` > (start_ts + viewTime),1,0) as `Stalled_AdEnd_preroll_binf`,
        IF(`Stalled_AdEnd_midroll_timestamp_max` > (start_ts + viewTime),1,0) as `Stalled_AdEnd_midroll_binf`,
        IF(`Stalled_AdEnd_postroll_timestamp_max` > (start_ts + viewTime),1,0) as `Stalled_AdEnd_postroll_binf`,
        IF(`Stalled_AdEnd_notReplaced_timestamp_max` > (start_ts + viewTime),1,0) as `Stalled_AdEnd_notReplaced_binf`,
        IF(`Stalled_AdEnd_unknown_timestamp_max` > (start_ts + viewTime),1,0) as `Stalled_AdEnd_unknown_binf`,
        IF(`Stalled_MediaError_timestamp_max` > (start_ts + viewTime),1,0) as `Stalled_MediaError_binf`,
        IF(`Stalled_NoFragLoad_timestamp_max` > (start_ts + viewTime),1,0) as `Stalled_NoFragLoad_binf`,
        IF(`Stalled_Offline_timestamp_max` > (start_ts + viewTime),1,0) as `Stalled_Offline_binf`,
        IF(`Stalled_Recover_timestamp_max` > (start_ts + viewTime),1,0) as `Stalled_Recover_binf`,
        IF(`Stalled_Seek_timestamp_max` > (start_ts + viewTime),1,0) as `Stalled_Seek_binf`,
        IF(`Stalled_SetSource_timestamp_max` > (start_ts + viewTime),1,0) as `Stalled_SetSource_binf`,
        IF(`Stalled_VideoTrackChange_timestamp_max` > (start_ts + viewTime),1,0) as `Stalled_VideoTrackChange_binf`,
        IF(`113_timestamp_max` > (start_ts + viewTime),1,0) as `113_binf`,
        IF(`bufferAppendError_timestamp_max` > (start_ts + viewTime),1,0) as `bufferAppendError_binf`,
        IF(`fragLoadError_timestamp_max` > (start_ts + viewTime),1,0) as `fragLoadError_binf`,
        IF(`fragLoadTimeOut_timestamp_max` > (start_ts + viewTime),1,0) as `fragLoadTimeOut_binf`,
        IF(`internalException_timestamp_max` > (start_ts + viewTime),1,0) as `internalException_binf`,
        IF(`manifestLoadTimeOut_timestamp_max` > (start_ts + viewTime),1,0) as `manifestLoadTimeOut_binf`,
        IF(`fatal_other_timestamp_max` > (start_ts + viewTime),1,0) as `fatal_other_binf`
    from $joined as j
);

insert into `@output_table` with truncate
select * from $joined2;
