use hahn;
pragma yt.Pool = "@[pool]";
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
$log = "//logs/zen-events-log/1d";
$video_events = AsList("show", "heartbeat","autoplay", "autopause","end");

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_table = "@[output_table]";

$tmp = (
    select
        fielddate,
        if(is_mobile, "mobile", "desktop") as platform,
        strongest_id as user_id,
        item_id as content_id,
        max(video_position_sec) as view_time
    from
        range($log, $date_from, $date_to)
    where
        event in $video_events
        and item_type = "gif"
    group by
        TableName() as fielddate,
        is_mobile,
        strongest_id,
        item_id
);

$monsters = (
    select
        distinct user_id
    from (
        select
            user_id,
            sum(view_time) as tvt
        from $tmp
        group by user_id
    )
    where tvt >= 86400
);

$tmp2 = (
    select
        *
    from $tmp as t
    left only join $monsters as m using (user_id)
);

$totalize = ($row)->(AsList($row, AddMember(RemoveMember($row, "platform"), "platform", "_total_")));

$totalized = process $tmp2 using $totalize(TableRow());

$grouped2 = (
    select
        fielddate,
        platform,
        sum(view_time) as tvt,
        count_if(view_time >= 30) as sessions_30s,
        CountDistinctEstimate(user_id) as users,
        CountDistinctEstimate(content_id) as unique_content_ids,
    from $totalized
    group by fielddate,
        platform
);

insert into $output_table WITH TRUNCATE
select * from $grouped2;
