from collections import namedtuple

Rec = namedtuple("Rec", ["ts", "ev"])


def reducer(key, recs):
    lst = []
    result = {
        "fielddate": key[0],
        "vsid": key[1],
        "service": None,
        "userAgent": None,
        "tech_name": None,
        "ref_from": None,
        "wt_from_player_states": 0,
    }
    fill_keys = ("service", "userAgent", "tech_name", "ref_from")
    for rec in recs:
        for k in fill_keys:
            if (not result[k]) and getattr(rec, k, None):
                result[k] = getattr(rec, k)
        if rec.wt_from_player_states and (
            rec.wt_from_player_states > result["wt_from_player_states"]
        ):
            result["wt_from_player_states"] = rec.wt_from_player_states
        if len(lst) < 200:
            lst.append(Rec(rec.ts, rec.ev))
    for k in fill_keys:
        if not result[k]:
            result[k] = "unknown"
    result["sorted_events"] = lst
    yield result
