use hahn;
pragma yt.Pool = "@[pool]";
pragma yson.DisableStrict;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
pragma library("stability_common.sql");
import stability_common SYMBOLS $getTechName, $refFromWrapper, $getRefFrom, $getPlatform, $getPlayerStates;
pragma yt.DefaultMemoryLimit = "4G";

$date_from = "@[date_from]";
$date_to = "@[date_to]";
$output_table = "@[output_table]";
$tmp_table = "@[tmp_table]";

$getBool = ($json, $fieldPath) -> {
    return Yson::ConvertToBool(Yson::YPath(Yson::ParseJson($json), $fieldPath));
};

$getEv = ($EventName, $Data, $EventType) -> {
    return case
    when $EventName == "RequestAutoplaySettingsTime" and $getBool($Data, '/data/autoplaySettingsRequestResult/autoplay') THEN "AutoplayAllowed"
    when $EventName == "RequestAutoplaySettingsTime" and not $getBool($Data, '/data/autoplaySettingsRequestResult/autoplay') THEN "AutoplayDisabled"
    when $getBool($Data, "/data/isFatal") or $EventType == "fatal" THEN $EventName || "_fatal"
    when $EventType == "error" THEN $EventName || "_error"
    else $EventName
    end
};

$dedup_stalleds = ($list) -> {
    RETURN ListFlatMap(
        ListEnumerate($list), ($pair) -> {
            $index = $pair.0;
            $object = $pair.1;
            RETURN CASE
            WHEN $list[$index + 1].duration > $object.duration THEN NULL
            ELSE $object
            END
        }
    )
};

$goodSession = ($lst) -> {
    RETURN ListHas($lst, "Start") or ListHas($lst, "AutoplayAllowed")
};

$ad_events = AsList("AdPodStart", "AdStart", "AdEnd", "AdPodEnd");
$no_autoplay = AsList("AutoplayDisabled", "HiddenAutoplayPrevented");
$has_event = ($events, $list) -> {
    return ListAny(listMap($list, ($y)->(listHas($events,$y))))
};

$countTVT = ($lst) -> {
    $t30 = ListLength(ListFilter($lst, ($x)->($x == "30SecHeartbeat")));
    $t20 = ListLength(ListFilter($lst, ($x)->($x == "20SecWatched")));
    $t10 = ListLength(ListFilter($lst, ($x)->($x == "10SecWatched")));
    $result = CASE
    WHEN $t30 > 0 THEN 30 * $t30
    WHEN $t20 > 0 THEN 20
    WHEN $t10 > 0 THEN 10
    ELSE 0
    END;
    return CAST($result as UInt64)
};

$getRefFrom = ($Data) -> {
    RETURN
        Yson::ConvertToString(Yson::YPath($Data, "/labels/from"))
        ?? Yson::ConvertToString(Yson::YPath($Data, "/data/additionalParams/from"))
        ?? Yson::ConvertToString(Yson::YPath($Data, "/data/source/additionalParams/from"))
        ?? Url::GetCGIParam(
            Yson::ConvertToString(Yson::YPath($Data, "/data/currentStream/url")), "from"
        )
        ?? Url::GetCGIParam(Yson::ConvertToString(Yson::YPath($Data, "/location")), "from")
};

$getOsF = ($parsed) -> {
    $os_family = $parsed.OSFamily;
    RETURN CASE
    WHEN $parsed.isTV THEN "tv"
    WHEN $os_family in ("Windows", "Android", "iOS") THEN $os_family
    WHEN $parsed.isMobile THEN "other_mobile"
    ELSE "other_desktop"
    END
};

$getPlayerStatesWT = ($states) -> {
    $wts = ListMap($states, ($x)->($x.watchedTime));
    RETURN CAST(ListMax($wts) as Double) ?? 0.0
};

$getStalledDuration = ($data) -> {
    RETURN Yson::ConvertToDouble(
        Yson::YPath($data, "/data/stalledDuration")
    ) ?? CAST(
        Yson::ConvertToString(
            Yson::YPath($data, "/labels/stalledDuration")
        ) AS Double
    )
};

$tmp = (
    select
        TableName() as fielddate,
        vsid,
        service,
        $getEv(eventName, data, eventType) as ev,
        $getPlayerStatesWT($getPlayerStates(data)) as wt_from_player_states,
        $getTechName(streamUrl) ?? $getTechName(data) as tech_name,
        clientTimestamp as ts,
        $refFromWrapper($getRefFrom(Yson::ParseJson(data))) as ref_from,
        IF(
            eventName in ("Stalled", "StalledEnd"),
            AsStruct(
                $getStalledDuration(Yson::ParseJson(data)) as duration,
                clientTimestamp as ts
            )
        ) as stalled_ev,
        userAgent
    from range(
        `logs/strm-gogol-log/1d`, $date_from, $date_to
    )
    where service in ("StreamPlayer", "AndroidPlayer")
);

$grouped = (
    select
        fielddate,
        vsid,
        MAX(wt_from_player_states) as wt_from_player_states,
        $getPlatform(MAX(service), MAX(userAgent)) as platform,
        ListTake(ListSort(AGGREGATE_LIST(
            AsStruct(
                ts as ts,
                ev as ev,
            )
        ), ($x)->($x.ts)), 200) as sorted_events,
        -- tech_name as tech_name,
        --         ref_from as ref_from
        ListSort(AGGREGATE_LIST(
            AsStruct(
                ts as ts,
                tech_name as tech_name,
            )
        ), ($x)->($x.ts))[0].tech_name ?? "unknown" as tech_name,
        ListSort(AGGREGATE_LIST(
            AsStruct(
                ts as ts,
                ref_from as ref_from,
            )
        ), ($x)->($x.ts))[0].ref_from ?? "unknown" as ref_from,
        ListSum(
            ListMap(
                $dedup_stalleds(ListSort(AGGREGATE_LIST(stalled_ev), ($x)->($x.ts))),
                ($x)->($x.duration)
            )
        ) as stalled_duration
    from $tmp
    group by fielddate, vsid
);

$add_tvt_and_bools = (
    select
        t.*,
        $goodSession(ListMap(sorted_events, ($x)->($x.ev))) as good_session,
        $has_event(ListMap(sorted_events, ($x)->($x.ev)), $ad_events) as ad,
        $has_event(ListMap(sorted_events, ($x)->($x.ev)), $no_autoplay) and not listHas(ListMap(sorted_events, ($x)->($x.ev)), "Start") as no_autoplay,
        ListAny(ListMap(sorted_events, ($x)->(String::Contains(String::ToLower($x.ev), 'fatal')))) as fatal,
        ListAny(ListMap(sorted_events, ($x)->(String::Contains(String::ToLower($x.ev), 'error')))) as error,
        MAX_OF(wt_from_player_states, $countTVT(ListMap(sorted_events, ($x)->($x.ev)))) as tvt,
        ListMax(ListMap(sorted_events, ($x)->($x.ts)))-ListMin(ListMap(sorted_events, ($x)->($x.ts))) as duration
    from $grouped as t
);

$add_case = (
    select t.*,
    case
    when tvt > 0 then "has_tvt"
    when ad then "ad"
    when fatal then "fatal"
    when no_autoplay then "no_autoplay"
    when stalled_duration >= 1.0 then "long_stalled"
    when error then "other_error"
    when duration >= 5000 then "duration>=5sec"
    else "duration<5sec"
    end as p_case
    from $add_tvt_and_bools as t
);

$totalize = ($row) -> {
    $result = AsList($row);
    $add = ListFlatMap($result, ($x)->(IF($x.platform != "_total_", AddMember(RemoveMember($x, "platform"), "platform", "_total_"), NULL)));
    $result = ListUnionAll($result, $add);
    $add = ListFlatMap($result, ($x)->(IF($x.tech_name != "_total_", AddMember(RemoveMember($x, "tech_name"), "tech_name", "_total_"), NULL)));
    $result = ListUnionAll($result, $add);
    $add = ListFlatMap($result, ($x)->(IF($x.ref_from != "_total_", AddMember(RemoveMember($x, "ref_from"), "ref_from", "_total_"), NULL)));
    $result = ListUnionAll($result, $add);
    return $result
};

$filtered = (
    select * from $add_case
    where good_session
);

$totalized = process $filtered using $totalize(TableRow());

$grouped2 = (
    select
        fielddate,
        ref_from,
        tech_name,
        platform,
        count(*) as total_vsids,
        count_if(tvt == 0) / cast(count(*) as double) as zero_vt_share,
        count_if(p_case == "has_tvt") / cast(count(*) as double) as p0_has_tvt_share,
        count_if(p_case == "ad") / cast(count(*) as double) as p1_ad_share,
        count_if(p_case == "fatal") / cast(count(*) as double) as p2_fatal_share,
        count_if(p_case == "no_autoplay") / cast(count(*) as double) as p3_no_autoplay_share,
        count_if(p_case == "long_stalled") / cast(count(*) as double) as p4_long_stalled_share,
        count_if(p_case == "other_error") / cast(count(*) as double) as p5_other_error_share,
        count_if(p_case == "duration>=5sec") / cast(count(*) as double) as p6_duration_ge5sec_share,
        count_if(p_case == "duration<5sec") / cast(count(*) as double) as p7_duration_lt5sec_share,
    from $totalized
    group by fielddate,
        ref_from,
        tech_name,
        platform
);

insert into $tmp_table WITH TRUNCATE 
select * from $add_case
where vsid is not null and len(vsid) <= 1000
order by vsid;

insert into $output_table with truncate
select * from $grouped2;