#!/usr/bin/env python
# -*- coding: utf-8 -*-
import sys
import os
import codecs
import argparse
import subprocess
import re

re_service_cfg = re.compile('Name: "(.+?)"')
re_service_meta = re.compile('when \$x == "(.+?)" then [0-9]+')
service_enum = re.compile('\$serviceEnum.+?as UInt8\)\);\n', re.DOTALL)
cfg_service = re.compile('ClientService {.+?\n}', re.DOTALL)

def parse_cfg(s):
    services = [x.group(0) for x in cfg_service.finditer(s)]
    services = [x for x in services if not "IsDummy: true" in x]
    return {re_service_cfg.search(x).group(1) for x in services}

def tryint(s):
    try:
        return int(s)
    except ValueError:
        return


def valid_service(s):
    return not "IsDummy: true"

def patch_ugc_stats(meta, non_existent):
    srch = service_enum.search(meta)
    enum = srch.group(0)
    meta_before = meta[:srch.start()]
    meta_after = meta[srch.end():]
    lines = enum.split("\n")
    stub = lines[-4]
    current_num = int(stub.split()[-1])
    additional = []
    for i, service in enumerate(sorted(non_existent)):
        additional.append(f'when $x == "{service}" then {current_num + i + 1}')
    enum_patched = "\n".join(lines[:-3] + additional + lines[-3:])
    return meta_before + enum_patched + meta_after


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--config_path", "-c")
    parser.add_argument("--input_file", "-i", default="ugc_stats_regular.sql")
    parser.add_argument("--output_file", "-o")
    args = parser.parse_args()
    with open(args.config_path) as f:
        cfg = f.read()
    all_services = parse_cfg(cfg)
    with open(args.input_file) as f:
        meta = f.read()
    meta_services = {x.group(1) for x in re_service_meta.finditer(service_enum.search(meta).group(0))}
    non_existent = all_services - meta_services
    if non_existent:
        print("non-existent services: " + ", ".join(non_existent))
        with open(args.input_file, "w") as f:
            f.write(patch_ugc_stats(meta, non_existent))
        subprocess.call(["tar", "-czvf", args.output_file, "."])


if __name__ == "__main__":
    main()
