#!/usr/bin/env python
# -*- coding: utf-8 -*-
import sys
import os
import codecs
import argparse
import subprocess
import re

re_service_cfg = re.compile('Name: "(.+?)"')
re_service_meta = re.compile('when \$x == "(.+?)" then [0-9]+')
service_enum = re.compile('\$serviceEnum.+?as UInt8', re.DOTALL)
cfg_service = re.compile('ClientService {.+?\n}', re.DOTALL)

def parse_cfg(s):
    services = [x.group(0) for x in cfg_service.finditer(s)]
    services = [x for x in services if not "IsDummy: true" in x]
    return {re_service_cfg.search(x).group(1) for x in services}

def tryint(s):
    try:
        return int(s)
    except ValueError:
        return


def valid_service(s):
    return not "IsDummy: true"


def main():
    subprocess.check_call(
        ["svn", "up", "/home/pecheny/arcadia/extsearch/video/ugc/config"]
    )
    with open("/home/pecheny/arcadia/extsearch/video/ugc/config/clients_prod.cfg") as f:
        cfg = f.read()
    all_services = parse_cfg(cfg)
    with open("/home/pecheny/arcadia/analytics/videolog/strm-stats/strm_cube_2/ugc_stats_regular/ugc_stats_regular.sql") as f:
        meta = f.read()
    meta_services = {x.group(1) for x in re_service_meta.finditer(service_enum.search(meta).group(0))}
    non_existent = all_services - meta_services
    print("non-existent services: " + ", ".join(non_existent))


if __name__ == "__main__":
    main()
