use hahn;
pragma library("get_ugc_meta.sql");
import get_ugc_meta symbols $getResource;

$threshold = 10000;
$date_from = "@[date_from]";
$date_to = "@[date_to]";
$input_root = "@[input_root]";
$output_root = "@[output_root]";
$output_cumul = $output_root || "/cumulative_views";
$output_last_date = $output_root || "/last_date";
$already_sent = "@[already_sent_table]";
$to_send_table = "@[to_send_root]/" || $date_to;

define subquery $get_channel_services() as
$tmp = (
    SELECT 
        ugc_channel_id,
        ugc_service,
        count(*) as videos
    from `//home/videolog/strm_meta/iron_branch/concat`
    where JoinKey = `UUID` and ugc_channel_id is not null
    group by ugc_channel_id, ugc_service
);

$grouped = (
    select
        ugc_channel_id,
        ListSortDesc(aggregate_list(AsTuple(ugc_service, videos)), ($x)->($x.1)) as top_services
    from $tmp
    group by ugc_channel_id
);

$add = (
    select
        a.*,
        ListUniq(ListSort(ListMap(top_services, ($x)->($x.0)))) as uniq_services,
        ListSum(ListMap(top_services, ($x)->($x.1))) as total_videos
    from $grouped as a
);

select ugc_channel_id
from $add
where String::JoinFromList(uniq_services, ",") == "ugc";
end define;

$delta = (
    select
        channel_id,
        some(OwnerUID) as owner_id,
        count(*) as views,
        sum(ViewTime) as tvt
    from range(
        $input_root, $date_from, $date_to   
    )
    group by ChannelID as channel_id
);

$merged = (
    select
        channel_id,
        some(owner_id) as owner_id,
        sum(views) as views,
        sum(tvt) as tvt
    from (
        select * from $output_cumul
        union all
        select * from $delta
    )
    group by channel_id
);

insert into $output_cumul with truncate
select * from $merged;

insert into $output_last_date with truncate
select $date_to as fielddate;

$isMonetized = ($resources) -> (($getResource($resources, "monetization_status") == "enabled") ?? false);

$monetized = (
    select `channel.id` as channel_id
    from `//home/video-hosting/ugc_replica/ugc_channel`
    where $isMonetized(`extra.resources`)
);

$to_send = (
    select
        *
    from $merged as s
    left only join $already_sent as a on (s.channel_id == a.channel_id)
    left only join $monetized as m on (s.channel_id == m.channel_id)
    left semi join $get_channel_services() as chs on (s.channel_id = chs.ugc_channel_id)
    where views >= $threshold
);

insert into $to_send_table with truncate
select * from $to_send;
