import binascii
from base64 import urlsafe_b64encode, urlsafe_b64decode
from ctypes import c_int64
from yql.typing import *


def generate_vcid(video_meta_id: int) -> str:
    encoded_meta_id = urlsafe_b64encode(video_meta_id.to_bytes(8, "little"))
    video_url_id = encoded_meta_id.decode().strip("=")
    video_url_id = f"v{video_url_id}"
    return video_url_id


def generate_video_meta_id(vcid: str) -> int:
    video_url_id = vcid.decode()[1:]
    try:
        decoded = urlsafe_b64decode(video_url_id.encode())
    except binascii.Error:
        decoded = urlsafe_b64decode((video_url_id + "=").encode())
    return int.from_bytes(decoded, "little")


_P = 239017


def _ichwill_hash(x, char_fn):
    result = c_int64(0)
    for c in x:
        result.value = result.value * _P + char_fn(c)
    return result.value


def ichwill_hash(x):
    return _ichwill_hash(x, lambda y: ord(y))


def object_id_hash(x: bytes) -> int:
    x = x or b""
    return _ichwill_hash(x, lambda y: int.from_bytes([y], byteorder="big", signed=True))
