#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import os
import argparse
import datetime
import vh
try:
    basestring
except NameError:
    basestring = str

"""
To run: REQUESTS_CA_BUNDLE=/etc/ssl/certs/ python3 valhalla_ugc_push.py --from {date_from} --to {date_to}
"""


def date_range(from_, to_):
    if isinstance(from_, basestring):
        from_ = datetime.datetime.strptime(from_, '%Y-%m-%d').date()
    if isinstance(to_, basestring):
        to_ = datetime.datetime.strptime(to_, '%Y-%m-%d').date()
    mvr = min([from_, to_])
    result = []
    while mvr <= max([from_, to_]):
        result.append(mvr)
        mvr += datetime.timedelta(days=1)
    if to_ < from_:
        result = result[::-1]
    return result


ECHO_OP_ID = "a0603967-154d-4201-a5f2-fb835ac19a5d"
SVN_EXPORT_OP_ID = "7306fbe8-3ae7-4eb0-b846-e132649b9033"
UPSERT_OP_ID = "f5f6a584-339c-493e-8b72-0774d19a46e5"
UGC_CONFIG_PATH = "arcadia/analytics/videolog/strm-stats/ugc_ch/ugc_config.json"
NIRVANA_TO_CLICKHOUSE_PATH = "arcadia/analytics/videolog/strm-stats/ugc_ch/ugc_nirvana_to_clickhouse.py"


def process_date(date):
    date = str(date)
    with vh.Graph() as graph:
        json_date = vh.op(id=ECHO_OP_ID)(text='["{}"]'.format(date)).output_json
        ugc_config = vh.op(id=SVN_EXPORT_OP_ID)(_options={"arcadia_path": UGC_CONFIG_PATH}).json
        nirvana_to_clickhouse_script = vh.op(id=SVN_EXPORT_OP_ID)(_options={"arcadia_path": NIRVANA_TO_CLICKHOUSE_PATH}).text

        upsert_op = vh.op(id=UPSERT_OP_ID)(
            _inputs={
                "dates": json_date,
                "config": ugc_config,
                "script": nirvana_to_clickhouse_script
            },
            _options={
                "yt-token": "pecheny_yt_token",
                "ch-user": "vh_ugc_stats_admin",
                "ch-password": "vh_ugc_stats_password",
                "ttl": 1440,
                "max-ram": 3000
            }
        )

        vh.run(
            graph,
            oauth_token=os.environ["NIRVANA_TOKEN"],
            workflow_guid="3c7365d0-0f7f-4cc1-bff9-c013246758b0",
            wait=True,
            description=date,
            quota="mm-metrics",
            keep_going=True,
            api_retry_delay=60,
            api_retries=-1
        )


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--from")
    parser.add_argument("--to")
    args = parser.parse_args()

    from_ = getattr(args, "from")
    to_ = getattr(args, "to")
    for date in date_range(from_, to_):
        print("processing {}".format(date))
        process_date(date)


if __name__ == "__main__":
    main()
