#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os
import argparse
import datetime
import vh
try:
    basestring
except NameError:
    basestring = str

"""
To run: REQUESTS_CA_BUNDLE=/etc/ssl/certs/ python3 valhalla_ugc_push.py --from {date_from} --to {date_to}
"""


def date_range(from_, to_):
    if isinstance(from_, basestring):
        from_ = datetime.datetime.strptime(from_, '%Y-%m-%d').date()
    if isinstance(to_, basestring):
        to_ = datetime.datetime.strptime(to_, '%Y-%m-%d').date()
    mvr = min([from_, to_])
    result = []
    while mvr <= max([from_, to_]):
        result.append(mvr)
        mvr += datetime.timedelta(days=1)
    if to_ < from_:
        result = result[::-1]
    return result


ECHO_OP_ID = "a0603967-154d-4201-a5f2-fb835ac19a5d"
SVN_EXPORT_OP_ID = "7306fbe8-3ae7-4eb0-b846-e132649b9033"
UPSERT_OP_ID = "f7dfc4d5-01d0-42e8-9a96-abe92da167fa"
NIRVANA_TO_CLICKHOUSE_PATH = "arcadia/analytics/videolog/strm-stats/nirvana_to_clickhouses.py"


def process_date(date, args):
    date = str(date)
    with vh.Graph() as graph:
        json_date = vh.op(id=ECHO_OP_ID)(text='["{}"]'.format(date)).output_json
        nirvana_to_clickhouse_script = vh.op(id=SVN_EXPORT_OP_ID)(_options={"arcadia_path": NIRVANA_TO_CLICKHOUSE_PATH}).text

        upsert_op = vh.op(id=UPSERT_OP_ID)(
            _inputs={
                "dates": json_date,
                "script": nirvana_to_clickhouse_script
            },
            _options={
                "yt-token": "pecheny_yt_token",
                "ch-user": "vh-ch-user",
                "ch-password": "vh-ch-password",
                "ttl": 360,
                "yt-path": args.yt_path,
                "mr-default-cluster": "hahn",
                "ch-table": "VideohostingViewsDetailedStat",
                "max-ram": 500,
                "max-tmpfs-disk": 500,
                "mr-account": "videolog",
                "job-layer": ["3c89985a-5ba3-47be-bdc1-7538833c36ce"]
            }
        )

        vh.run(
            graph,
            oauth_token=os.environ["NIRVANA_TOKEN"],
            workflow_guid="07773221-4e62-4206-8927-52644981dbc5",
            wait=True,
            description=date,
            quota="mm-metrics",
            keep_going=True,
            api_retry_delay=60,
            api_retries=-1
        )


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--from")
    parser.add_argument("--to")
    parser.add_argument("--yt-path", default="//home/videoquality/vh_analytics/vhds_reduced")
    args = parser.parse_args()

    from_ = getattr(args, "from")
    to_ = getattr(args, "to")
    for date in date_range(from_, to_):
        print("processing {}".format(date))
        process_date(date, args)


if __name__ == "__main__":
    main()
