from typing import *

import vh3

@vh3.decorator.graph("https://nirvana.yandex-team.ru/flow/6c91d4d7-2bf3-4ee0-b729-e140fb2c6d59")
def vhds_mapreduce_for_cloning(params_string: vh3.String = "", string_of_paths: vh3.String = None) -> None:
    """
    vhds mapreduce for cloning
    """
    svn_export_single_file_result: SvnExportSingleFileOutput = svn_export_single_file(
        arcadia_path="arcadia/analytics/videolog/strm-stats/nirvana_to_clickhouses.py",
        **vh3.block_args(
            code="operation-c333cf73-dc34-45d0-8c0d-74f733468092$2",
            name="SVN: Export single file",
            position=(352, 336, 160, 368),
        )
    )
    job_command = 'bash -c \'python ${param["downloader"]!""} ${param["list_of_paths"]!""} ${param["string_of_paths"]!""} --token ${param["arcanum_token"]!""}[#if param["revision"]??] --revision ${param["revision"]}[/#if];\\\nexport ARCANUM_REVISION=`cat arc_dl_revision.txt`;\\\nexport ARCANUM_TOKEN=${param["arcanum_token"]};\\\n[#if param["yql_token"]??]export YQL_TOKEN=${param["yql_token"]};[/#if] \\\nexport YT_TOKEN=${param["yt_token"]};\\\nexport YT_PROXY=${param["yt_proxy"]};\\\n[#if param["stat_login"]??]export STAT_LOGIN=${param["stat_login"]};[/#if] \\\n[#if param["stat_token"]??]export STAT_TOKEN=${param["stat_token"]};[/#if] \\\npython vhds_stats_regular.py --from ${param["params_string"]} --to ${param["params_string"]} --pool cubes-video-strm --output ${output["output_json"]}\''
    checkout_from_arcadia_and_run_script_result: CheckoutFromArcadiaAndRunScriptOutput = checkout_from_arcadia_and_run_script(
        job_command=job_command,
        yt_token="robot-mma-nirvana_yt_token",
        yql_token="robot-mma-nirvana_yql_token",
        arcanum_token="robot-mma-nirvana_arcanum_token",
        stat_login="",
        stat_token="robot-mma-nirvana_stat_token",
        list_of_paths=(
            "arcadia/analytics/videolog/strm-stats/strm_cube_2/ugc_stats_regular/vhds_stats_regular.py",
            "arcadia/analytics/videolog/strm-stats/strm_cube_2/ugc_stats_regular/vhds_stats_regular.sql",
            "arcadia/analytics/videolog/videolog_common.py",
        ),
        string_of_paths="",
        params_string=params_string,
        **vh3.block_args(
            code="operation-059f8c25-cd94-4b02-aa22-b19fee892161",
            name="Checkout from arcadia and run script",
            position=(352, 16, 160, 272),
        )
    )
    upsert_to_ch_retries_result: None = upsert_to_ch_retries(
        script=svn_export_single_file_result.text,
        dates=checkout_from_arcadia_and_run_script_result.output_json,
        max_ram=430,
        ch_table="VideohostingViewsDetailedStat",
        force_tmpfs_disk=False,
        max_tmpfs_disk=500,
        job_layer=("3c89985a-5ba3-47be-bdc1-7538833c36ce",),
        yt_token="robot-mma-nirvana_yt_token",
        mr_account="videoquality/vh_analytics",
        **vh3.block_args(
            code="operation-1538407764972-9$1", name="upsert to ch +retries", position=(576, 192, 160, 208)
        )
    )


class CheckoutFromArcadiaAndRunScriptOutput(NamedTuple):
    output_mr_table: vh3.OptionalOutput[vh3.MRTable]
    output_json: vh3.OptionalOutput[vh3.JSON]
    output_text: vh3.OptionalOutput[vh3.Text]
    output_binary: vh3.OptionalOutput[vh3.Binary]


@vh3.decorator.external_operation("https://nirvana.yandex-team.ru/operation/f4d5648e-d573-4696-aa1d-dba0503037fa")
@vh3.decorator.nirvana_names(
    job_command="job-command",
    max_ram="max-ram",
    max_disk="max-disk",
    cpu_guarantee="cpu-guarantee",
    job_layer="job-layer",
)
def checkout_from_arcadia_and_run_script(
    *,
    job_command: vh3.String = 'bash -c \'python ${param["downloader"]!""} ${param["list_of_paths"]!""} ${param["string_of_paths"]!""} --token ${param["arcanum_token"]!""}[#if param["revision"]??] --revision ${param["revision"]}[/#if];\\\nexport ARCANUM_REVISION=`cat arc_dl_revision.txt`;\\\nexport ARCANUM_TOKEN=${param["arcanum_token"]};\\\n[#if param["yql_token"]??]export YQL_TOKEN=${param["yql_token"]};[/#if] \\\nexport YT_TOKEN=${param["yt_token"]};\\\nexport YT_PROXY=${param["yt_proxy"]};\\\n[#if param["stat_login"]??]export STAT_LOGIN=${param["stat_login"]};[/#if] \\\n[#if param["stat_token"]??]export STAT_TOKEN=${param["stat_token"]};[/#if] \\\npython ${param["params_string"]!""}\'',
    yt_token: vh3.Secret = "pecheny_yt_token",
    yt_proxy: vh3.String = "hahn",
    yql_token: vh3.Secret = "pecheny_yql_token",
    list_of_paths: vh3.MultipleStrings = (),
    arcanum_token: vh3.Secret = "pecheny_arcanum_token",
    revision: vh3.Integer = None,
    stat_login: vh3.String = "robot_pecheny",
    stat_token: vh3.Secret = "robot_pecheny_stat_token",
    ttl: vh3.Integer = 360,
    max_ram: vh3.Integer = 100,
    max_disk: vh3.Integer = 2048,
    cpu_guarantee: vh3.Integer = 1,
    params_string: vh3.String = None,
    string_of_paths: vh3.String = None,
    job_layer: vh3.MultipleStrings = ("26ae3512-cde8-4834-bb2e-fe0be0738636",),
    input_mr_table: Sequence[vh3.MRTable] = (),
    input_json: Sequence[vh3.JSON] = (),
    input_text: Sequence[vh3.Text] = (),
    input_binary: Sequence[vh3.Binary] = ()
) -> CheckoutFromArcadiaAndRunScriptOutput:
    """
    Checkout from arcadia and run script

    :param list_of_paths: List of paths to checkout
    :param arcanum_token: Arcanum token
    :param revision: Revision number
    :param string_of_paths: List of paths (string, space separated)
    """
    raise NotImplementedError("Write your local execution stub here")


class SvnExportSingleFileOutput(NamedTuple):
    text: vh3.Text
    json: vh3.JSON
    binary: vh3.Binary
    executable: vh3.Executable
    tsv: vh3.TSV
    file: vh3.File
    revision: vh3.Text


@vh3.decorator.external_operation("https://nirvana.yandex-team.ru/operation/7306fbe8-3ae7-4eb0-b846-e132649b9033")
def svn_export_single_file(
    *,
    arcadia_path: Union[vh3.String, vh3.Text] = None,
    revision: vh3.Integer = None,
    path_prefix: vh3.String = None,
    only_info: vh3.Boolean = False
) -> SvnExportSingleFileOutput:
    """
    SVN: Export single file

    **Назначение операции**

    Позволяет скачать один файл из SVN-репозитория.
    В опциях укажите относительный путь в Arcadia и номер ревизии.

    **Описание входов**

     - arcadia_path — относительный путь в Arcadia для checkout'а файла, например `arcadia/entity/ugc/tools/nirvana/takeout/main.yql`
      Если выход не указан, значение берется из options.


    **Описание выходов**

     - text, json, binary, executable, tsv, file — возможные форматы файлов для checkout'а.
     - revision — номер ревизии из опции .


    **Ограничения**

    Не предусмотрены.

    :param arcadia_path: Arcadia path
      Относительный путь в аркадии для checkout'а.
    :param arcadia_path:
      Относительный путь в аркадии для checkout'а. Если не указано - берется из options.
    :param revision: Revision
      [[Revision(HEAD if not set)]]
      Revision(HEAD if not set)
    :param path_prefix: Path prefix
      Path prefix to support branches and tags(i.e. https://arcadia.yandex.ru/arc/branches/remorph/stable-1/arcadia/), set to null if trunk
    :param only_info: Only Revision
      Only revision in output(do not export file)
    """
    raise NotImplementedError("Write your local execution stub here")


@vh3.decorator.external_operation("https://nirvana.yandex-team.ru/operation/f7dfc4d5-01d0-42e8-9a96-abe92da167fa")
@vh3.decorator.nirvana_names_transformer(vh3.name_transformers.snake_to_dash, options=True)
def upsert_to_ch_retries(
    *,
    yt_token: vh3.Secret,
    mr_account: vh3.String,
    dates: vh3.JSON,
    script: Union[vh3.Binary, vh3.Executable, vh3.Text],
    job_command: vh3.String = 'python ${input["script"]} --input-dates ${input["dates"]} --ch-table ${param["ch-table"]} --ch-user ${param["ch-user"]} --ch-password ${param["ch-password"]} --yt-path ${param["yt-path"]}',
    yt_pool: vh3.String = None,
    ttl: vh3.Integer = 360,
    max_ram: vh3.Integer = 100,
    ch_table: vh3.String = "VideohostingViewsDetailedStatTest",
    mr_default_cluster: vh3.String = "hahn",
    ch_user: vh3.Secret = "vh-ch-user",
    ch_password: vh3.Secret = "vh-ch-password",
    yt_path: vh3.String = "//home/videoquality/vh_analytics/vhds_reduced",
    force_tmpfs_disk: vh3.Boolean = True,
    max_tmpfs_disk: vh3.Integer = 16000,
    job_layer: vh3.MultipleStrings = ("e012ff5a-dd87-41fd-82cf-708dab81b3c5",)
) -> None:
    """
    upsert to ch +retries

    :param yt_token: YT Token:
      [[ID of Nirvana Secret with YT access token (https://nda.ya.ru/3RSzVU).
    Guide to Nirvana Secrets: https://nda.ya.ru/3RSzWZ]]
      YT OAuth Token.

        [Obtain access token](https://nda.ya.ru/3RSzVU), then [create a Nirvana secret](https://nda.ya.ru/3RSzWZ) and [use it here](https://nda.ya.ru/3RSzWb).
        You can [share the secret](https://nda.ya.ru/3RSzWd) with user(s) and/or a staff group.
    :param mr_account: MR Account:
      [[MR Account Name.
    By default, output tables and directories will be created in some subdirectory of home/<MR Account>/<workflow owner>/nirvana]]
      MR account name (e.g. `rank_machine`) used to build MR output path for this operation.

      See the `mr-output-path` option for more information
    :param yt_pool: YT Pool:
      [[Pool used by YT scheduler. Leave blank to use default pool.
    This option has no effect on YaMR.]]
      Pool used by [YT operation scheduler](https://nda.ya.ru/3Rk4af). Leave this blank to use default pool.
    :param yt_path:
      input tables home path
    """
    raise NotImplementedError("Write your local execution stub here")

