#!/usr/bin/env python
# -*- coding: utf-8 -*-
import vh3
import argparse
from videolog_common import date_range
from vh3_vhds_calc_and_push import vhds_mapreduce_for_cloning


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--from")
    parser.add_argument("--to")
    args = vars(parser.parse_args())

    profile = vh3.Profile.from_file(workflow=vh3.Workflow(id="f2d67315-57b7-4438-b435-0d70894738d2"))

    previous_block = None
    with profile.build(vh3.WorkflowInstance) as wi:
        for date in date_range(args["from"], args["to"]):
            with vh3.wait_for(previous_block):
                previous_block = vhds_mapreduce_for_cloning(params_string=str(date))
    wi.run()
    wi.get_result()



if __name__ == "__main__":
    main()
