#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import codecs
import argparse
from nile.api.v1 import clusters
from yql.api.v1.client import YqlClient
from videolog_common import (
    get_cluster,
    get_driver,
    YqlRunner,
    get_date,
    apply_replacements,
)


OUTPUT_TABLE = "//home/videolog/strm_meta/yandexuids_subscriptions"
TITLE = "User Licenses | YQL"


def get_last_date(yr, args):
    req = yr.run(
        "use hahn; " "select max(max_date) from `{}`".format(args.output_table)
    )
    res = req.get_results()
    res.table.fetch_full_data()
    return get_date(res.table.rows[0][0])


def process_dates(date_from, date_to, yr, args):
    with open("user_licenses_stub.sql", "r") as f:
        query = f.read()
    query = apply_replacements(
        query,
        {
            "@[date_from]": str(date_from),
            "@[date_to]": str(date_to),
            "@[output_table]": args.output_table,
            "@[pool]": args.pool,
        },
    )
    yr.run(query)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--from")
    parser.add_argument("--to")
    parser.add_argument("--pool", default="pecheny")
    parser.add_argument("--output_table", default=OUTPUT_TABLE)
    args = parser.parse_args()

    yc = YqlClient(token=os.environ["YQL_TOKEN"])
    yr = YqlRunner(yc, title=TITLE)

    cluster = get_cluster(clusters, {})
    yt = get_driver(cluster).client

    from_ = getattr(args, "from", None)
    to_ = getattr(args, "from", None)

    if not from_ or not to_:
        yc.config.db = None
        last_date = get_last_date(yr, args)
        dates_sessions = set(
            get_date(x)
            for x in yt.search(
                root="//user_sessions/pub/video/daily",
                node_type="table",
                path_filter=lambda x: get_date(x) and x.endswith("clean"),
            )
            if get_date(x) > last_date
        )
        available_dates = dates_sessions
        if not available_dates:
            print("No dates available, last date is {}".format(last_date))
            sys.exit(0)
        date_from = sorted(available_dates)[0]
        date_to = sorted(available_dates)[-1]
    else:
        date_from = get_date(from_)
        date_to = get_date(to_)
    print("Processing dates {} to {}...".format(date_from, date_to))
    process_dates(date_from, date_to, yr, args)


if __name__ == "__main__":
    main()
