use hahn;
pragma yt.Pool = "@[pool]";
pragma yt.PoolTrees = "physical";
pragma yt.UseDefaultTentativePoolTrees;

$existing_table = "@[output_table]";
$output_table = $existing_table;
$date_from = "@[date_from]";
$date_to = "@[date_to]";

$re_yandexuid = Re2::Match("[0-9]+1[23456][0-9]{8}");

$tmp = (
    select
        ListReverse(String::SplitToList(TablePath(), "/"))[1] as fielddate,
        substring(key_uid, 1) as yandexuid,
        subkey_unixtime as `timestamp`,
        Dsv::Parse(TSKV_DATA.search_props, ",")["user_subscription"] as user_subscription
    from range(
        `//user_sessions/pub/video/daily`, $date_from, $date_to, `clean`
    )
    where
        Dsv::Parse(TSKV_DATA.search_props, ",")["user_subscription"] is not null
        and key_uid like "y%" and $re_yandexuid(substring(key_uid, 1))
);

$tmp2 = (
    select
        yandexuid,
        user_subscription,
        dates as fielddate
    from (
        select
            yandexuid,
            licenses_dates.user_subscription as user_subscription,
            licenses_dates.dates as dates
        from $existing_table
        flatten list by licenses_dates
    )
    flatten list by dates
);

$grouped_final_step_1 = (
    select
        unwrap(yandexuid) as yandexuid,
        unwrap(user_subscription) as user_subscription,
        aggregate_list_distinct(fielddate) as dates,
        max(fielddate) as max_date
    from (
        select * from $tmp
        union all
        select * from $tmp2
    )
    where user_subscription is not null
    and yandexuid is not null
    group by yandexuid, user_subscription
);

$grouped_final_step_2 = (
    select
        yandexuid,
        aggregate_list(
            AsStruct(
                user_subscription as user_subscription,
                dates as dates
            )
        ) as licenses_dates,
        max(max_date) as max_date
    from $grouped_final_step_1
    group by yandexuid
);

insert into $output_table WITH TRUNCATE 
select * from $grouped_final_step_2;
