#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import codecs
import argparse
import json
from nile.api.v1 import clusters
from yql.api.v1.client import YqlClient
from videolog_common import (
    get_cluster,
    get_driver,
    YqlRunner,
    get_date,
    apply_replacements,
)

RECOM_ROOT = "//home/videoindex/recommender/profiles/dumps/recent/final_users"
OUTPUT_ROOT = "//home/videolog/strm_meta/user_subscriptions/parsed_profiles"
TITLE = "User Subscriptions v2 | YQL"


def process_date(date, yr, args):
    with open("parse_profiles_stub.sql", "r") as f:
        query = f.read()
    output_table = "{}/{}".format(args.root, date)
    query = apply_replacements(
        query,
        {
            "@[date]": str(date),
            "@[output_root]": args.root,
            "@[pool]": args.pool,
        },
    )
    yr.run(query)
    return output_table


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--date")
    parser.add_argument("--pool", default="robot-mma-nirvana")
    parser.add_argument("--root", default=OUTPUT_ROOT)
    parser.add_argument("--output", default="output.json")
    parser.add_argument("--dst_path", default="dst_path.json")
    args = parser.parse_args()

    yc = YqlClient(token=os.environ["YQL_TOKEN"])
    yr = YqlRunner(yc, title=TITLE)

    cluster = get_cluster(clusters, {})
    yt = get_driver(cluster).client

    if not args.date:
        yc.config.db = None
        last_date = max(
            get_date(x)
            for x in yt.search(root=args.root, node_type="table")
            if get_date(x)
        )
        available_dates = sorted(
            get_date(x)
            for x in yt.search(root=RECOM_ROOT, node_type="table")
            if get_date(x) and get_date(x) > last_date
        )
        if not available_dates:
            print("No dates available, last date is {}".format(last_date))
            sys.exit(0)
        date = available_dates[-1]
    else:
        date = get_date(args.date)
    print("Processing {}...".format(date))
    table = process_date(date, yr, args)
    with open(args.output, "w") as f:
        json.dump(
            {"cluster": os.environ["YT_PROXY"].lower(), "table": table}, f
        )
    with open(args.dst_path, "w") as f:
        json.dump(
            {"dst-path": table}, f
        )


if __name__ == "__main__":
    main()
