use arnold;
pragma yt.Pool = "@[pool]";
pragma yt.DataSizePerJob = "4G";
PRAGMA File("libdj_udf.so", "https://proxy.sandbox.yandex-team.ru/last/DJ_UDF");
PRAGMA UDF("libdj_udf.so");

$date = "@[date]";
$output_root = "@[output_root]";
$output_table = $output_root || "/" || $date;
$input_table = "//home/videoindex/recommender/profiles/dumps/recent/final_users/" || $date;

$extract_profile = ($profile) -> {
    $deserialized_profile = DJ::ProfileFromProto($profile);
    return DJ::ProfileToStruct($deserialized_profile);
};

$get_counters_by_type = ($profile, $type) -> {
    return ListFilter(
        $profile.Counters,
        ($counter) -> {
            return $counter.CounterType == $type;
        }
    );
};

$tmp = (
    select 
        $get_counters_by_type(
            $extract_profile(profile),
            "PN_VHS#CT_LICENSE"
        ) as counters,
        id as id
    from $input_table
);

$processed = (
    select
        subs.counters[0].ObjectId as subscription,
        SUBSTRING(subs.id, 1) as puid
    from 
        $tmp as subs
    where 
        ListLength(subs.counters) > 0 and subs.counters[0].ObjectId != ""
);

insert into $output_table with truncate
select * from $processed;
