use hahn;
pragma yt.Pool = "@[pool]";

$input_table = "@[input_table]";
$output_table = "@[output_table]";

$puids = (
    select distinct puid from $input_table
);

$crypta_yandexuids = (
    select
        puid,
        target_id as yandexuid
    from $puids as p
    inner join `//home/crypta/production/state/graph/v2/matching/by_id/puid/direct/yandexuid` as c
    on (p.puid == c.id)
);

$grouped = (
    select
        puid,
        ListSort(AGGREGATE_LIST_DISTINCT(yandexuid)) as yandexuids
    from $crypta_yandexuids
    group by puid
);

$with_yandexuids = (
    select
        p.*,
        yandexuids
    from $input_table as p
    left join $grouped as g using (puid)
);

insert into $output_table with truncate
select * from $with_yandexuids;
