#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
import vh
from pytils import date_range
from nile.api.v1 import clusters


SC2_ROOT = 'arcadia/analytics/videolog/strm-stats/strm_cube_2'

SC2_JOB_COMMAND = """bash -c 'python ${param["downloader"]!""} ${param["list_of_paths"]!""} ${param["string_of_paths"]!""} --token ${param["arcanum_token"]!""}[#if param["revision"]??] --revision ${param["revision"]}[/#if]; export ARCANUM_REVISION=`cat arc_dl_revision.txt`; [#if param["yql_token"]??]export YQL_TOKEN=${param["yql_token"]};[/#if]  \
export YT_TOKEN=${param["token"]}; \
export YT_PROXY=hahn; \
python ${param["params_string"]!""}"""

VHDS_MR_JOB_COMMAND = SC2_JOB_COMMAND + ' --output ${output["processed_tables"]}'


hahn = clusters.yt.Hahn(token=os.environ['YT_TOKEN'])


def process_date(date):
    date = str(date)
    with vh.Graph() as graph:
        nile_data = vh.data(id='30bb1772-318d-43f3-9827-648d784daa5e')
        client = hahn.driver.client
        preprocessed_table = '//cubes/video-strm/{}/preprocessed'.format(date)
        sessions_table = '//cubes/video-strm/{}/sessions'.format(date)

        # preprocessed_table_is_good = (
        #     client.get_attribute(
        #         preprocessed_table, 'build_time', ''
        #     ).split('T')[0] >= '2019-12-18'
        # )
        # sessions_table_is_good = (
        #     client.get_attribute(
        #         sessions_table, 'build_time', ''
        #     ).split('T')[0] >= '2019-12-18'
        # )
        preprocessed_table_is_good = True
        sessions_table_is_good = True

        if not sessions_table_is_good:
            strm_cube_2_sessions = vh.op(
                id='9622cab9-aca2-4f9b-9228-ed89b8fb5265',
            )

            strm_cube_2_sessions = strm_cube_2_sessions(
                _inputs={'volume': nile_data},
                _options={
                    'params_string': ' '.join([
                        'strm_cube_2.py --from {date} --to {date}{prep}',
                        '--pool search-research_pecheny'
                    ]).format(
                        date=date,
                        prep=(
                            ' --redo all'
                            if not preprocessed_table_is_good
                            else ''
                        )
                    ),
                    'string_of_paths': ' '.join(
                        [
                            '{}/strm_cube_2.py'.format(SC2_ROOT),
                            '{}/strm_cube_2_common.py'.format(SC2_ROOT),
                            'arcadia/analytics/atom/pytils.py'
                        ]
                    ),
                    'max-ram': 512,
                    'job-command': SC2_JOB_COMMAND,
                    'ttl': 3600
                }
            )
            kwargs = {
                '_after': [strm_cube_2_sessions]
            }
        else:
            kwargs = {}

        reduced_table_is_good = False
        # reduced_table_is_good = hahn.driver.client.get_attribute(
        #     '//home/videoquality/vh_analytics/vhds_reduced/{}'.format(
        #         date
        #     ), 'creation_time'
        # ).split('T')[0] >= '2019-12-26'

        if not reduced_table_is_good or not sessions_table_is_good:
            vhds_mapreduce = vh.op(
                id='75dc38ae-21d9-4820-bf83-0b4f3a891937',
            )
            vhds_mapreduce = vhds_mapreduce(
                _inputs={'volume': nile_data},
                _options={
                    'params_string':
                    'vhds_mapper_strm_cube.py '
                    '--from {date} --to {date}'.format(
                        date=date
                    ),
                    'job-command': VHDS_MR_JOB_COMMAND,
                    'string_of_paths': ' '.join(
                        [
                            'arcadia/analytics/videolog/strm-stats/'
                            'vhds_mapper_strm_cube.py',
                            'arcadia/analytics/atom/pytils.py'
                        ]
                    ),
                    'max-ram': 512
                },
                **kwargs
            )
            dates = [vhds_mapreduce]
        else:
            dates = [vh.data_from_str(
                '["{}"]'.format(date),
                data_type="json"
            )]

        upsert_to_ch = vh.op(
            id='e18d93b3-fb1d-4bbb-b1e9-f0e5ca3bbc2a',
        )
        upsert_to_ch = upsert_to_ch(
            _inputs={'dates': dates},
            _options={
                'ch-user': 'vh-ch-user',
                'ch-password': 'vh-ch-password',
                'yt-token': 'pecheny_yt_token',
                'mr-default-cluster': 'hahn',
                'mr-account': 'videoquality',
                'yt-path': '//home/videoquality/vh_analytics/vhds_reduced',
                'ch-table': 'VideohostingViewsDetailedStat',
                'yt-table': ''.join(
                    [
                        '//home/video-hosting-dev/'
                        'vandermond/VideohostingViewsDetailedStat'
                    ]
                )
            }
        )

        vh.run(
            graph,
            oauth_token=os.environ['NIRVANA_TOKEN'],
            workflow_guid='3119ddec-5711-4ae3-810e-8c0b93b56392',
            wait=False,
            description=date,
            quota='mm-metrics',
            keep_going=True
        )


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--from')
    parser.add_argument('--to')
    args = parser.parse_args()

    from_ = getattr(args, 'from')
    to_ = getattr(args, 'to')
    for date in date_range(from_, to_):
        process_date(date)


if __name__ == "__main__":
    main()
