#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import os
import argparse
import datetime
import vh


SC2_ROOT = "arcadia/analytics/videolog/strm-stats/strm_cube_2"

SC2_JOB_COMMAND = """bash -c 'python ${param["downloader"]!""} ${param["list_of_paths"]!""} ${param["string_of_paths"]!""} --token ${param["arcanum_token"]!""}[#if param["revision"]??] --revision ${param["revision"]}[/#if]; export ARCANUM_REVISION=`cat arc_dl_revision.txt`; [#if param["yql_token"]??]export YQL_TOKEN=${param["yql_token"]};[/#if]  \
export YT_TOKEN=${param["token"]}; \
export YT_PROXY=hahn; \
python ${param["params_string"]!""}"""

VHDS_MR_JOB_COMMAND = (
    SC2_JOB_COMMAND + ' --output ${output["processed_tables"]}'
)


def date_range(from_, to_):
    if isinstance(from_, basestring):
        from_ = datetime.datetime.strptime(from_, '%Y-%m-%d').date()
    if isinstance(to_, basestring):
        to_ = datetime.datetime.strptime(to_, '%Y-%m-%d').date()
    mvr = min([from_, to_])
    result = []
    while mvr <= max([from_, to_]):
        result.append(mvr)
        mvr += datetime.timedelta(days=1)
    if to_ < from_:
        result = result[::-1]
    return result


def process_date(date):
    date = str(date)
    with vh.Graph() as graph:
        nile_data = vh.data(id="30bb1772-318d-43f3-9827-648d784daa5e")

        vhds_mapreduce = vh.op(id="4285fb24-d64c-47aa-895f-a8de4df1da44")
        vhds_mapreduce = vhds_mapreduce(
            _inputs={"volume": nile_data},
            _options={
                "params_string": "vhds_mapper_strm_cube_beta.py "
                "--from {date} --to {date} --job_root //home/videoquality/vh_analytics/vhds_reduced".format(
                    date=date
                ),  # YT_PATH
                "job-command": VHDS_MR_JOB_COMMAND,
                "string_of_paths": " ".join(
                    [
                        "arcadia/analytics/videolog/strm-stats/"
                        "vhds_mapper_strm_cube_beta.py",
                        "arcadia/analytics/atom/pytils.py",
                    ]
                ),
                "max-ram": 512,
                "arcanum_token": "",  # TOKEN
                "stat_login": "",  # TOKEN
                "stat_token": "",  # TOKEN
                "yql_token": "",  # TOKEN
                "token": "",  # YT TOKEN
            }
        )
        dates = [vhds_mapreduce]

        upsert_to_ch = vh.op(id="e18d93b3-fb1d-4bbb-b1e9-f0e5ca3bbc2a")
        upsert_to_ch = upsert_to_ch(
            _inputs={"dates": dates},
            _options={
                "ch-user": "vh-ch-user",
                "ch-password": "vh-ch-password",
                "yt-token": "pecheny_yt_token",  # TOKEN
                "mr-default-cluster": "hahn",
                "mr-account": "videoquality",
                "yt-path": "//home/videoquality/vh_analytics/vhds_reduced",
                "ch-table": "VideohostingViewsDetailedStat",
                "yt-table": "".join(
                    [
                        "//home/video-hosting-dev/"
                        "vandermond/VideohostingViewsDetailedStat"
                    ]
                ),
            },
        )

        vh.run(
            graph,
            oauth_token=os.environ["NIRVANA_TOKEN"],
            workflow_guid="3119ddec-5711-4ae3-810e-8c0b93b56392",
            wait=False,
            description=date,
            quota="mm-metrics",
            keep_going=True,
        )


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--from")
    parser.add_argument("--to")
    args = parser.parse_args()

    from_ = getattr(args, "from")
    to_ = getattr(args, "to")
    for date in date_range(from_, to_):
        process_date(date)


if __name__ == "__main__":
    main()
