pragma AnsiInForEmptyOrNullableItemsCollections;

$getChannel = ($ch, $chid, $video_content_id, $parentUUID, $program) -> {
    RETURN CASE
    WHEN $ch == "ott" and $parentUUID in ("4bd70910dee2e0a0a4d960995c786334", "4f75ab2350acb20fb77c8014bdb4d3a9") THEN "ott.trailers"
    WHEN $chid == "1550142789" THEN "Яндекс.Персональный канал." || ($ch ?? "-")
    WHEN $chid == "1563558125" THEN "Яндекс.Моя музыка." || ($ch ?? "-")
    WHEN $ch IS NULL AND LENGTH($video_content_id) == 12 THEN "UGC"
    WHEN $ch IS NULL AND LENGTH($video_content_id) == 32 THEN "-non-joined-"
    WHEN $ch IS NULL THEN "-"
    WHEN LENGTH($ch) == 0 THEN "-"
    ELSE $ch ?? "-"
    END
};


$getChannelsList = ($row)->{
    $ch = $row.channel;
    $ch_old = $row.channel_old;
    $result = IF(
        $ch LIKE "YANDEXSHOW__%",
        AsList(SUBSTRING($ch, 12), "_yandex_show_"),
        AsList($ch)
    );
    $result = IF(
        $result[0] LIKE "Яндекс.Персональный канал.%",
        ListExtend(
            AsList(SUBSTRING(unwrap($result[0]), 49), "Яндекс.Персональный канал"),
            ListSkip($result, 1)
        ),
        $result
    );
    $result = IF(
        $result[0] LIKE "Яндекс.Моя музыка.%",
        ListExtend(
            AsList(SUBSTRING(unwrap($result[0]), 33), "Яндекс.Моя музыка"),
            ListSkip($result, 1)
        ),
        $result
    );
    $ch = $result[0];
    $add = ListNotNull(ListMap(
        AsList($ch), ($x)->(IF($x IS NULL or $x in ("", "-") and $row.ref_from not like 'zen%' and $row.ref_from != "ZEN", NULL, "_total_"))
    ));
    $result = ListExtend($result, $add);
    $add = ListNotNull(ListMap(
        AsList($ch), ($x)->(IF($x == "ott.trailers", "ott", NULL))
    ));
    $result = ListExtend($result, $add);
    $add = ListNotNull(ListMap(
        AsList($ch), ($x)->(IF($x LIKE "%НХЛ%" or $x LIKE "%NHL%", "_nhl_", NULL))
    ));
    $result = ListExtend($result, $add);
    $add = ListNotNull(ListMap(
        AsList($ch), ($x)->(IF($x LIKE "%ФНЛ%", "_fnl_", NULL))
    ));
    $result = ListExtend($result, $add);
    $add = ListNotNull(ListMap(
        AsList($ch), ($x)->(IF($x LIKE "%Яндекс.Уроки%", "_yandex_education_", NULL))
    ));
    $result = ListExtend($result, $add);
    $add = CASE
    WHEN ($ch NOT LIKE "UGC.%" AND $ch NOT LIKE "Zen.%") OR $ch == "UGC.Канал Ether" THEN ListCreate(String)
    WHEN ($ch_old == "zen" OR $ch LIKE "Zen.%") THEN AsList("_zen_ugc_", "_ugc_")
    ELSE AsList("_vh_ugc_", "_ugc_")
    END;
    $result = ListExtend($result, $add);
    $add = IF(
        $ch LIKE "UGC.%" and $row.program LIKE "UGCLive.%", ["_ugc_live_"],
        ListCreate(String)
    );
    $result = ListExtend($result, $add);
    $add = ListNotNull(ListMap(
        AsList($ch), ($x)->(IF($x LIKE "fm_%", "_fm_", NULL))
    ));
    $result = ListExtend($result, $add);
    $add = ListNotNull(ListFlatMap(
        AsList($ch), ($x)->(IF($x LIKE "Яндекс.Новогодний%", ["Яндекс.Новогодний (все)"], []))
    ));
    $result = ListExtend($result, $add);
    $add = ListFlatMap(
        AsList($ch), ($x)->(IF($x LIKE "Яндекс.%", "_yandex_", NULL))
    );
    $result = ListExtend($result, $add);
    $add = ListFlatMap(
        AsList($ch), ($x)->(IF($x LIKE "Спецпроекты.%", "_special_", NULL))
    );
    $result = ListExtend($result, $add);
    $add = ListFlatMap(
        AsList($ch), ($x)->(IF($x LIKE "Youtube.%", "_youtube_", NULL))
    );
    $result = ListExtend($result, $add);
    $add = ListFlatMap(
        AsList($ch), ($x)->(IF(
            "2" in String::SplitToList($row.path, ",")
            and ListLength(ListFilter($result, ($x)->(String::StartsWith($x, "_") and $x != "_total_"))) == 0
            and ListLength(ListFilter($result, ($x)->($x like "Погода%"))) == 0
            and ListLength(ListFilter($result, ($x)->($x like "Я.Новости%"))) == 0
            and ListLength(ListFilter($result, ($x)->($x like "Яндекс%"))) == 0
            and ListLength(ListFilter($result, ($x)->($x like "%VOD%"))) == 0
            and "ya-news" not in $result,
            "_tv_channels_",
            NULL
        ))
    );
    $result = ListExtend($result, $add);
    $add = IF(
        "_youtube_" in $result or "_vh_ugc_" in $result,
        AsList("_vh_ugc_youtube_"),
        ListCreate(String)
    );
    $result = ListExtend($result, $add);
    $result = ListFilter($result, ($x)->($x is not null and $x != ""));
    RETURN $result
};

$ref_from_whitelist = [
    "appsearch",
    "browser",
    "efir",
    "efir_touch",
    "feed",
    "geoadv",
    "kp",
    "leagueoflegends.com",
    "morda",
    "morda_touch",
    "multiple",
    "ny2018",
    "ottwidget_kp",
    "ottwidget_morda",
    "ottwidget_tv",
    "ottwidget_ya-serp",
    "ottwidget_ya-video",
    "ottwidget_yavideo",
    "ott-smart-webos",
    "ott-smart-tizen",
    "ott-smart-samsung",
    "partner",
    "ru.yandex.quasar.app",
    "serp",
    "streamhandler_appsearch",
    "streamhandler_other",
    "streamhandler_serp",
    "streamhandler_serp_touch",
    "streamhandler_tv",
    "streamhandler_yabrowser",
    "streamhandler_yxnews",
    "turbo",
    "tv",
    "unknown",
    "videohub",
    "videohub_touch",
    "weather_desktop",
    "weather_turbo",
    "ya-market",
    "ya-music",
    "ya-tv",
    "ya-tv-in-page",
    "ya-tv-program",
    "ya-weather",
    "yanews",
    "yanewsautoplay",
    "yanewstragic",
    "yatvapp",
    "yavideo",
];

$utf8 = Re2::Options(true as Utf8);
$badSymbols = Re2::Grep("[^a-zA-Z.-]", $utf8);

$wrapRefFrom = ($ref_from) -> {
    RETURN CASE
    WHEN $ref_from IS NULL OR $ref_from == "" THEN "other"
    WHEN $ref_from IN $ref_from_whitelist THEN $ref_from
    WHEN $ref_from LIKE "zen_site_mobile%" THEN "zen_site_mobile"
    WHEN $ref_from LIKE "zen_site_desktop%" THEN "zen_site_desktop"
    WHEN $ref_from LIKE "zen%" THEN "zen"
    WHEN $ref_from LIKE "streamhandler%" THEN "streamhandler"
    WHEN $badSymbols($ref_from) THEN "other"
    WHEN LENGTH($ref_from) > 30 THEN "other"
    WHEN CAST($ref_from as Uint64) IS NOT NULL THEN "other"
    ELSE $ref_from
    END
};

$getRefFromsList = ($row)->{
    $ref_froms_to_add = CASE
    WHEN $row.ref_from LIKE "zen%" THEN AsList("_zen_", "_total_")
    WHEN $row.ref_from in (
        "morda_touch",
        "videohub_touch",
        "efir_touch",
        "streamhandler_appsearch"
    ) THEN AsList("Эфир-тач", "_total_without_zen_", "_total_")
    WHEN $row.ref_from in (
        "morda",
        "videohub",
        "efir",
        "streamhandler_other"
    ) THEN AsList("Эфир", "_total_without_zen_", "_total_")
    ELSE AsList("_total_without_zen_", "_total_")
    END;
    RETURN $ref_froms_to_add
};

$makeTotaled = ($row) -> {
    $totaled = RemoveMember($row, "browser");
    $totaled = RemoveMember($totaled, "os_family");
    $totaled = RemoveMember($totaled, "channel");
    $totaled = RemoveMember($totaled, "program");
    $totaled = RemoveMember($totaled, "ref_from");
    $totaled = RemoveMember($totaled, "view_type");
    RETURN ExpandStruct(
        $totaled,
        "_total_" as browser,
        "_total_" as os_family,
        "_total_" as channel,
        "_total_" as program,
        "_total_" as platform,
        "_total_" as ref_from,
        "_total_" as view_type
    )
};

$totalize = ($row) -> {
    $row = AddMember(RemoveMember($row, "ref_from"), "ref_from", $wrapRefFrom($row.ref_from));
    $ref_froms_to_add = $getRefFromsList($row);
    $channelsList = $getChannelsList($row);
    $row = AddMember(RemoveMember($row, "channel"), "channel", unwrap($channelsList[0]));
    $channelsList = ListSkip($channelsList, 1);
    $totaled = $makeTotaled($row);
    $result = AsList(
        $row,
        $totaled,
        AddMember(RemoveMember($totaled, "browser"), "browser", $row.browser),
        AddMember(RemoveMember($totaled, "os_family"), "os_family", $row.os_family),
        AddMember(RemoveMember($totaled, "channel"), "channel", $row.channel),
        AddMember(RemoveMember($totaled, "program"), "program", $row.program),
        AddMember(RemoveMember($totaled, "ref_from"), "ref_from", $row.ref_from),
        AddMember(RemoveMember($totaled, "view_type"), "view_type", $row.view_type),
        AddMember(RemoveMember($totaled, "country"), "country", $row.country),
        ExpandStruct(RemoveMember(RemoveMember($totaled, "channel"), "view_type"), $row.channel as channel, $row.view_type as view_type),
        ExpandStruct(RemoveMember(RemoveMember($totaled, "ref_from"), "view_type"), $row.ref_from as ref_from, $row.view_type as view_type),
        ExpandStruct(RemoveMember(RemoveMember($totaled, "channel"), "os_family"), $row.channel as channel, $row.os_family as os_family),
        ExpandStruct(RemoveMember(RemoveMember($totaled, "os_family"), "view_type"), $row.os_family as os_family, $row.view_type as view_type),
        ExpandStruct(RemoveMember(RemoveMember($totaled, "os_family"), "ref_from"), $row.os_family as os_family, $row.ref_from as ref_from),
        ExpandStruct(RemoveMember(RemoveMember($totaled, "channel"), "ref_from"), $row.channel as channel, $row.ref_from as ref_from),
        ExpandStruct(RemoveMember(RemoveMember($totaled, "country"), "ref_from"), $row.country as country, $row.ref_from as ref_from),
        ExpandStruct(RemoveMember(RemoveMember($totaled, "channel"), "program"), $row.channel as channel, $row.program as program),
        ExpandStruct(RemoveMember(RemoveMember($totaled, "program"), "ref_from"), $row.program as program, $row.ref_from as ref_from),
        ExpandStruct(RemoveMember(RemoveMember($totaled, "channel"), "country"), $row.channel as channel, $row.country as country),
        ExpandStruct(RemoveMember(RemoveMember(RemoveMember($totaled, "channel"), "program"), "view_type"), $row.channel as channel, $row.program as program, $row.view_type as view_type),
        ExpandStruct(RemoveMember(RemoveMember(RemoveMember($totaled, "channel"), "ref_from"), "view_type"), $row.channel as channel, $row.ref_from as ref_from, $row.view_type as view_type),
        ExpandStruct(RemoveMember(RemoveMember(RemoveMember($totaled, "channel"), "os_family"), "view_type"), $row.channel as channel, $row.os_family as os_family, $row.view_type as view_type),
        ExpandStruct(RemoveMember(RemoveMember(RemoveMember($totaled, "browser"), "os_family"), "view_type"), $row.browser as browser, $row.os_family as os_family, $row.view_type as view_type)
    );
    $add = ListFlatMap(
        $result, ($x)->(IF(
            $x.channel == $row.channel,
            ListMap($channelsList, ($f)->(AddMember(RemoveMember($x, "channel"), "channel", $f))),
            NULL
        ))
    );
    $add = ListFlatMap($add, ($x)->($x));
    $result = ListUnionAll($result, $add);
    $add = ListFlatMap(
        $result, ($x)->(IF(
            $x.ref_from == $row.ref_from,
            ListMap($ref_froms_to_add, ($f)->(AddMember(RemoveMember($x, "ref_from"), "ref_from", $f))),
            NULL
        ))
    );
    $add = ListFlatMap($add, ($x)->($x));
    $result = ListUnionAll($result, $add);
    RETURN $result
};

EXPORT $totalize, $getChannelsList, $getChannel;
