use hahn;
pragma yt.Pool = '@pool';
pragma yt.PoolTrees = "physical";
pragma yt.TentativePoolTrees = "cloud";
PRAGMA Library("yandex_shows.sql");
IMPORT yandex_shows SYMBOLS $is_yandex_show, $is_good_session;
PRAGMA Library("vh_cube_2_common.sql");
IMPORT vh_cube_2_common SYMBOLS $getChannel;

$date_from = '@date_from';
$date_to = '@date_to';
$output_table = '@output_table';

$ornull = ($x, $y) -> {
    RETURN IF($x is not null, $x, $y)
};

$bad_vcids = AsList("novcid", "-", NULL, "");
$iron_branch = "//home/videolog/strm_meta/iron_branch/concat";

$wrap_yandex_show = ($ch, $ch_orig, $program) -> {
    RETURN IF(
        $is_yandex_show($ch_orig, $program),
        "YANDEXSHOW__" || $ch,
        $ch
    )
};

$sourcesAggrTest = ($add_info) -> {
    $sources_aggr = Yson::LookupString($add_info, "sources_aggr");
    RETURN $sources_aggr LIKE "%heartbeat%" OR $sources_aggr LIKE "%start%"
};

$getProgram = ($program, $video_content_id) -> {
    RETURN CASE
    WHEN $program IS NULL AND LENGTH($video_content_id) == 12 THEN "UNKNOWN_UGC"
    WHEN $program IS NULL THEN "-"
    WHEN LENGTH($program) == 0 THEN "-"
    ELSE $program
    END
};

$basicTest = ($video_content_id, $add_info, $vtpl) -> {
    RETURN ($sourcesAggrTest($add_info) or $vtpl > 0) AND ((NOT ListHas($bad_vcids, $video_content_id ?? "")))
};

$countVT = ($vt, $vtpl) -> (IF(
    $vt == 0 and $vtpl <= 10,
    CAST($vtpl as Int64),
    $vt
));

$source_pre = (
    select
        ListReverse(String::SplitToList(TablePath(), "/"))[1] as fielddate,
        $ornull(ref_from, "–") as ref_from,
        $ornull(category_id, "-") as category_id,
        $ornull(page_id, "-") as page_id,
        $ornull(browser_name, "-") as browser_name,
        $ornull(os_family, "-") as os_family,
        bytes_sent,
        IF($is_good_session(TableRow()), 1, 0) as is_good_session,
        vsid,
        channel_old,
        country ?? "UNK" as country,
        video_content_id,
        IF(
            view_time_non_muted > view_time,
            view_time,
            view_time_non_muted
        ) ?? 0.0 as view_time_non_muted,
        $countVT(view_time, view_time_player_alive) as view_time,
        IF(view_time < 30, 0, Math::Log(CAST($countVT(view_time, view_time_player_alive) as Double))) as lvt,
        view_type,
        provider,
        price,
        partner_price,
        if(channel_old like 'fm_%' and channel is null, channel_old, channel) as channel,
        ParentUUID,
        channel_id,
        program,
        if(WeakField(device_id, "String") == "-", NULL, WeakField(device_id, "String")) ?? yu_hash as yu_hash,
    from RANGE(
        `@[root]`, $date_from, $date_to,
        `sessions`
    ) with columns Struct<view_time_non_muted:Int64?, fraud:UInt64?>
    where (
        (
            $basicTest(video_content_id, add_info, view_time_player_alive)
            or ref_from like 'zen%'
            or ref_from == 'district'
            or channel_old like 'fm_%'
        )
        OR price > 0 OR shows_good > 0
    ) and (fraud is null or fraud == 0)
);

$source = (
    select
        fielddate,
        ref_from,
        category_id,
        s.page_id as page_id,
        browser_name,
        channel_old,
        os_family,
        vsid,
        country,
        video_content_id,
        view_time,
        is_good_session,
        IF(is_good_session == 1, view_time, 0) as good_view_time,
        view_time_non_muted,
        lvt,
        view_type,
        provider,
        price,
        partner_price,
        yu_hash,
        bytes_sent,
        $wrap_yandex_show($getChannel(@[ibfix_channel]channel, channel_id, video_content_id, ParentUUID, program), channel, program) as channel,
        $getProgram(@[ibfix_program]program, video_content_id) as program,
        IF(view_time > 0, 1, 0) as with_view,
        IF(view_time >= 30, 1, 0) as with_view_30s,
        IF(price > 0, 1, 0) as with_money
    from $source_pre as s
    @[ibfix_join]
);

$grouped = (
    select
        fielddate,
        vsid,
        video_content_id,
        SUM(is_good_session) as good_sessions,
        SUM(good_view_time) as good_tvt,
        MAX(channel_old) as channel_old,
        MAX(country) as country,
        MAX(channel) as channel,
        MAX(ref_from) as ref_from,
        MAX(program) as program,
        MAX(provider) as provider,
        $ornull(SUM(view_time), 0) as view_time,
        $ornull(SUM(view_time_non_muted), 0) as view_time_non_muted,
        $ornull(SUM(lvt), 0) as lvt,
        MAX(view_type) as view_type,
        $ornull(SUM(price), 0) as price,
        $ornull(SUM(partner_price), 0) as partner_price,
        MAX(yu_hash) ?? "-" as yu_hash,
        SUM(with_view) as with_view,
        SUM(with_view_30s) as with_view_30s,
        SUM(with_money) as with_money,
        SUM(bytes_sent) as bytes_sent,
        MAX(browser_name) ?? "Unknown" as browser_name,
        MAX(os_family) ?? "Unknown" as os_family
    from $source
    group by fielddate, vsid, video_content_id, page_id
);

$grouped_processed = (
    select
        fielddate,
        IF(vsid like 'rtbdsp%', NULL, vsid) as vsid,
        video_content_id,
        channel_old,
        good_sessions,
        good_tvt,
        yu_hash,
        country,
        `path`,
        IF(view_time >= 30, yu_hash, NULL) as yu_hash_30s,
        channel,
        ref_from,
        program,
        provider,
        view_time,
        view_time_non_muted,
        bytes_sent / Math::Pow(1024.0, 3) as gbytes_sent,
        lvt,
        view_type,
        CAST(price AS Double) / 1000000 as price,
        CAST(partner_price AS Double) / 1000000 as partner_price,
        with_view,
        with_view_30s,
        with_money,
        browser_name ?? "Unknown" as browser,
        os_family ?? "Unknown" as os_family
    from $grouped as g
    left join $iron_branch as ib
    on g.video_content_id == ib.JoinKey
);

insert into $output_table with truncate
select * from $grouped_processed