use hahn;
pragma yt.Pool = '@pool';
pragma yt.PoolTrees = "physical";
pragma yt.TentativePoolTrees = "cloud";

$date_from = '@date_from';
$date_to = '@date_to';
$output_table = '@output_table';

$ornull = ($x, $y) -> {
    RETURN IF($x is not null, $x, $y)
};

$bad_vcids = AsList("novcid", "-", NULL, "");

$getChannel = ($ch, $chid, $video_content_id, $parentUUID) -> {
    RETURN CASE
    WHEN $ch == "ott" and $parentUUID == "4bd70910dee2e0a0a4d960995c786334" THEN "ott.trailers"
    WHEN $chid == "1550142789" THEN "Яндекс.Персональный канал." || ($ch ?? "-")
    WHEN $ch IS NULL AND LENGTH($video_content_id) == 12 THEN "UGC"
    WHEN $ch IS NULL AND LENGTH($video_content_id) == 32 THEN "-non-joined-"
    WHEN $ch IS NULL THEN "-"
    WHEN LENGTH($ch) == 0 THEN "-"
    ELSE $ch ?? "-"
    END
};

$sourcesAggrTest = ($add_info) -> {
    $sources_aggr = Yson::LookupString($add_info, "sources_aggr");
    RETURN $sources_aggr LIKE "%heartbeat%" OR $sources_aggr LIKE "%start%"
};

$getProgram = ($program, $video_content_id) -> {
    RETURN CASE
    WHEN $program IS NULL AND LENGTH($video_content_id) == 12 THEN "UNKNOWN_UGC"
    WHEN $program IS NULL THEN "-"
    WHEN LENGTH($program) == 0 THEN "-"
    ELSE $program
    END
};

$source_pre = (
    select
        ListReverse(String::SplitToList(TablePath(), "/"))[1] as fielddate,
        $ornull(ref_from, "–") as ref_from,
        $ornull(category_id, "-") as category_id,
        $ornull(page_id, "-") as page_id,
        $ornull(browser_name, "-") as browser_name,
        $ornull(os_family, "-") as os_family,
        vsid,
        country ?? "UNK" as country,
        video_content_id,
        IF(
            view_time_non_muted > view_time,
            view_time,
            view_time_non_muted
        ) ?? 0.0 as view_time_non_muted,
        view_time,
        IF(view_time < 30, 0, Math::Log(CAST(view_time as Double))) as lvt,
        view_type,
        provider,
        price,
        partner_price,
        channel,
        ParentUUID,
        channel_id,
        program,
        if(WeakField(device_id, "String") == "-", NULL, WeakField(device_id, "String")) ?? yu_hash as yu_hash,
    from RANGE(
        `@[root]`, $date_from, $date_to,
        `sessions`
    ) with columns Struct<view_time_non_muted:Int64?>
    where (
        ($sourcesAggrTest(add_info) AND NOT ListHas($bad_vcids, video_content_id ?? ""))
        OR price > 0 OR shows_good > 0
    )
);

$source = (
    select
        fielddate,
        ref_from,
        category_id,
        s.page_id as page_id,
        browser_name,
        os_family,
        vsid,
        country,
        video_content_id,
        view_time,
        view_time_non_muted,
        lvt,
        view_type,
        provider,
        price,
        partner_price,
        yu_hash,
        $getChannel((ib.computed_channel ?? channel), channel_id, video_content_id, ParentUUID) as channel,
        $getProgram((ib.computed_program ?? program), video_content_id) as program,
        IF(view_time > 0, 1, 0) as with_view,
        IF(price > 0, 1, 0) as with_money
    from $source_pre as s
    left join `//home/videolog/strm_meta/iron_branch/concat` as ib on (s.video_content_id == ib.JoinKey)
);


$grouped = (
    select
        fielddate,
        vsid,
        video_content_id,
        MAX(country) as country,
        MAX(channel) as channel,
        MAX(ref_from) as ref_from,
        MAX(program) as program,
        MAX(provider) as provider,
        $ornull(SUM(view_time), 0) as view_time,
        $ornull(SUM(view_time_non_muted), 0) as view_time_non_muted,
        $ornull(SUM(lvt), 0) as lvt,
        MAX(view_type) as view_type,
        $ornull(SUM(price), 0) as price,
        $ornull(SUM(partner_price), 0) as partner_price,
        MAX(yu_hash) ?? "-" as yu_hash,
        SUM(with_view) as with_view,
        SUM(with_money) as with_money,
        MAX(browser_name) ?? "Unknown" as browser_name,
        MAX(os_family) ?? "Unknown" as os_family
    from $source
    group by fielddate, vsid, video_content_id, page_id
);

$iron_branch = "home/videolog/strm_meta/iron_branch/concat";

$grouped_processed = (
    select
        fielddate,
        IF(vsid like 'rtbdsp%', NULL, vsid) as vsid,
        video_content_id,
        yu_hash,
        country,
        `path`,
        IF(view_time >= 30, yu_hash, NULL) as yu_hash_30s,
        channel,
        ref_from,
        program,
        provider,
        view_time,
        view_time_non_muted,
        lvt,
        view_type,
        CAST(price AS Double) / 1000000 as price,
        CAST(partner_price AS Double) / 1000000 as partner_price,
        with_view,
        with_money,
        browser_name ?? "Unknown" as browser,
        os_family ?? "Unknown" as os_family
    from $grouped as g
    left join $iron_branch as ib
    on g.video_content_id == ib.JoinKey
);

insert into $output_table with truncate
select * from $grouped_processed