#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import os
import smtplib
import datetime
from email.mime.text import MIMEText
from pytils import get_stat_headers, get_dates_from_stat
os.environ['REQUESTS_CA_BUNDLE'] = '/etc/ssl/certs/ca-certificates.crt'


def send_mail(msg, addressees):
    msg = MIMEText(msg)
    msg['Subject'] = 'STRM Cube outdated'
    msg['From'] = 'strm-cube-monitoring@yandex-team.ru'
    msg['To'] = ','.join(addressees)
    s = smtplib.SMTP('outbound-relay.yandex.net')
    s.sendmail(msg['From'], addressees, msg.as_string())
    s.quit()


def main():
    headers = get_stat_headers()
    dates_from_stat = get_dates_from_stat(
        headers=headers,
        report='Video/Others/Strm/strm_cube_2'
    )
    if (
        dates_from_stat[-1] <
        datetime.date.today() - datetime.timedelta(days=1)
    ):
        send_mail(
            "strm_cube is outdated, last date: {}".format(dates_from_stat[-1]),
            ['pecheny@yandex-team.ru', 'ensuetina@yandex-team.ru']
        )


if __name__ == "__main__":
    main()
