#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
from pytils import date_range


def process_date(date):
    ftj = '--from {d} --to {d} --job_root {jr}'.format(
        d=date,
        jr='//home/videoquality/vh_analytics/strm_video_nc'
    )
    os.system(
        'python sessions.py {ftj} -nc --cleanup_self'.format(ftj=ftj)
    )
    os.system(
        'python make_cube_report.py {ftj}'.format(ftj=ftj)
    )
    os.system(
        'python push_cube_report.py {ftj} --report Video/Others/Strm/strm_cube_nc --async_mode'.format(ftj=ftj)
    )


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--from')
    parser.add_argument('--to')
    args = parser.parse_args()

    from_ = getattr(args, 'from')
    to_ = getattr(args, 'to')

    for date in date_range(from_, to_):
        process_date(date)


if __name__ == "__main__":
    main()
