import re
import requests
import datetime
import json
import time


# https://strm.yandex.ru/dvr/rentv/rentv0.m3u8
content_url_re = re.compile(r'^https:\/\/strm\.yandex\.ru\/dvr\/(.*?)/.*$')
# https://strm.yandex.ru/kal/ntv_cv/ntv_cv0.m3u8
content_url_kal_re = re.compile(
    r'^https:\/\/strm\.yandex\.ru\/kal\/(.*?)\/.*$')
# https://strm.yandex.ru/dvr/rentv/rentv0.m3u8?...
referer_re = re.compile(
    r'^https:\/\/strm\.yandex\.ru\/dvr\/(.*)/.*m3u8\?(.*)$')
# https://strm.yandex.ru/vh-tnt-converted/vod-content/138884.m3u8?...
referer_vod_re = re.compile(
    r'https:\/\/strm\.yandex\.ru\/vh-(.*)-converted\/vod-content\/.*m3u8\?(.*)$')
# https://strm.yandex.ru/kal/ntv_cv/ntv_cv0.m3u8?...
referer_kal_re = re.compile(
    r'https:\/\/strm\.yandex\.ru\/kal\/(.*)\/.*m3u8\?(.*)$')
# /dvr/edatv/edatv0_169_576p-1482310130000.ts
request_re = re.compile(r'^\/dvr\/(.*)/.*-(.*)\.ts$')
# /kal/ntv_cv/ntv_cv0_169_576p.json/seg-300660927-v1-a1.ts
request_kal_re = re.compile(r'^\/kal\/(.*)/(.*)/.*-([0-9]+)-.*\.ts$')
# /vh-ntv-converted/vod-content/138931_169_576p7.ts
vod_request_re = re.compile(r'vh-(.*)-converted/vod-content/.*\.ts')
zen_request_re = re.compile(r'/(.*)-vod/vod-content/.*\.ts')
# &vsid=860995526e6be931d653b0972d21de148e97a75c3197dfc7f79d0917a3dde437
vsid_re = re.compile(r'^&vsid=(.*)$')
# ntv_cv
channel_cv_re = re.compile(r'(.*)_cv$')


def retry_request(request_type, args=None, kwargs=None):
    if not args:
        args = []
    if not kwargs:
        kwargs = {}
    req = None
    retries = 0
    while ((req is None or req.status_code >= 300) and retries < 10):
        try:
            req = getattr(requests, request_type)(*args, **kwargs)
        except Exception as e:
            time.sleep(60)
            retries += 1
    return req


def get_programs(date):
    channels = get_channels()
    channel_programs = {}

    date_from = str(
        datetime.datetime.strptime(
            date, '%Y-%m-%d'
        ).replace(
            hour=0, minute=0, second=0
        ).strftime("%s")
    )
    date_to = str(
        datetime.datetime.strptime(
            date, '%Y-%m-%d'
        ).replace(
            hour=23, minute=59, second=59
        ).strftime("%s")
    )

    if not len(channels):
        return {}

    for channel in channels:
        channel_name = get_channel_by_content_url(channel['content_url'])

        if channel_name == '':
            continue

        if channel_name in channel_programs and len(
            channel_programs[channel_name]['programs']
        ):
            continue

        channel_programs[channel_name] = {
            'info': channel,
            'programs': get_channel_programs(
                channel['content_id'], date_from, date_to
            )
        }

    return channel_programs


def get_channels():
    url = (
        'https://frontend.vh.yandex.ru/channels'
        '?geo_id=213&locale=ru&content_type_name=channel'
    )

    resp = retry_request('get', kwargs=dict(url=url))
    data = json.loads(resp.text)

    res = data.get('set')

    if not len(res):
        return {}

    return res


def get_channel_by_content_url(content_url):
    match = content_url_re.findall(content_url)

    if (content_url == 'https://www.1tv.ru/embedlive'):
        return '1tv'

    if match:
        return match[0]

    match = content_url_kal_re.findall(content_url)

    if match:
        return match[0]

    return ''


def get_channel_programs(parent_id, date_from, date_to):
    url = (
        'https://frontend.vh.yandex.ru/episodes'
        '?parent_id=%s&end_date__from=%s&start_date__to=%s'
        '&geo_id=213&locale=ru' % (
            parent_id, date_from, date_to
        )
    )

    resp = retry_request('get', kwargs=dict(url=url))
    data = json.loads(resp.text)

    res = data.get('set')

    if not len(res):
        return {}

    return res
