#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
import datetime
import yt.wrapper as yt
from pytils import yt_config_set_defaults, yt_get_date_from_table


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--root')
    parser.add_argument('--from', default=None)
    parser.add_argument('--to', default=None)
    args = parser.parse_args()

    yt_config_set_defaults(yt)
    yt.config['token'] = os.environ['YT_TOKEN']

    if not getattr(args, 'to'):
        to_ = datetime.date.today()
    else:
        to_ = yt_get_date_from_table(getattr(args, 'to'))

    if not getattr(args, 'from'):
        from_ = to_ - datetime.timedelta(days=30)
    else:
        from_ = yt_get_date_from_table(getattr(args, 'from'))

    for table in yt.search(
        root=args.root,
        path_filter=lambda x: bool(yt_get_date_from_table(x))
    ):
        if yt_get_date_from_table(table) < from_:
            print('To remove: {}'.format(table))
            yt.remove(table)


if __name__ == "__main__":
    main()
