#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
from __future__ import division
import sys
import os
import codecs
import argparse
import requests
import json
import copy
import tqdm
import time


input_parameters = {
    u'dash_encryption_key': u'',
    u'dash_encryption_key_id': u'',
    u'dash_pssh': u'',
    u'drm_fairplay': False,
    u'drm_playready': False,
    u'drm_playready_la': u'https://ott-playready-testing.common.yandex.net/proxy?PlayRight=1&UseSimpleNonPersistentLicense=1',
    u'drm_widevine': False,
    u'drm_widevine_header_provider': u'widevine_test',
    u'ffmpeg_output_format': u'hls',
    u'ffmpeg_segment_time': 10,
    u'ffmpeg_two_pass': True,
    u'ffpmeg_capture_start': 0.0,
    u'ffpmeg_capture_stop': 0.0,
    u'ffpmeg_encoding_preset': u'veryslow',
    u'ffpmeg_first_resolution': False,
    u'ffpmeg_thumbnails_scene': True,
    u'ffpmeg_thumbnails_t': 0.0,
    u'keep_aspect_ratio': False,
    u'ott_content_uuid': u'',
    u'ott_product': u'',
    u'ott_sound_packaging': True,
    u'production': True,
    u'reuse_old_keys': False,
    u's3_bucket': u'vlt-converted',
    u's3_dir': u'',
    u's3_key_prefix': u'PREFIX',
    u's3_testing': False,
    u'strm_embed_ready': False,
    u'url': u'',
    u'use_encryption_keys_stub': False,
    u'webhook_payload_url': u''
}


class SandboxApi:
    root_url = 'https://sandbox.yandex-team.ru/api/v1.0/'

    def __init__(self, token):
        self.token = token

    @staticmethod
    def retry(request, *args, **kwargs):
        for attempt in range(10, 0, -1):
            try:
                return request(*args, **kwargs)
            except Exception as e:
                if attempt == 1:
                    raise
                else:
                    time.sleep(5)

    def post(self, url, **kwargs):
        r = self.retry(requests.post, self.root_url + url, headers={
            'Authorization': 'Bearer ' + self.token}, **kwargs)
        if not str(r.status_code).startswith('2'):
            raise Exception('{}: {}'.format(r.status_code, r.content))
        return r

    def put(self, url, **kwargs):
        r = self.retry(requests.put, self.root_url + url, headers={
            'Authorization': 'Bearer ' + self.token}, **kwargs)
        if not str(r.status_code).startswith('2'):
            raise Exception('{}: {}'.format(r.status_code, r.content))
        return r

    def get(self, url, **kwargs):
        return self.retry(requests.get, self.root_url + url, **kwargs)

    def create_task(self, task_type, context):
        return self.post(
            'task',
            json={
                'type': task_type,
                'owner': 'VIDEOLOG',
                'author': 'robot-atom-banner',
                'context': context
            }
        ).json()

    def update_task(self, task_id, values):
        return self.put('task/{}'.format(task_id), json=values)

    def run_task(self, task_id):
        return self.put('batch/tasks/start', json=[task_id]).json()

    def increase_priority(self, task_id, N):
        for i in range(N):
            self.put('batch/tasks/increase_priority', json=[task_id])

    def get_status(self, task_id):
        return self.get('task/{}'.format(task_id)).json()['status']

    def release(self, task_id, to, subject):
        self.post('release', json={
            "cc": [], "type": to,
            "task_id": task_id, "subject": subject, "message": ""
        })


def main():
    info = json.load(open('video_info_good_processed1.json'))
    with open('.sandbox_token', 'rb') as f:
        token = f.read().strip()
    sb = SandboxApi(token)
    ids = []
    for obj in tqdm.tqdm(info[8100:]):
        ip = copy.deepcopy(input_parameters)
        ip['url'] = obj['link']
        ip['s3_key_prefix'] = obj['prefix']
        task = sb.create_task('STRM_VIDEO_CONVERT', {})
        task_id = task['id']
        obj['task_id'] = task_id
        ids.append(task_id)
        sb.update_task(task_id, {'custom_fields': [
            {"name": k, "value": v} for k, v in ip.items()
        ]})
        if len(ids) % 100 == 0:
            if os.path.isfile('task_ids.json'):
                ids_old = json.load(open('task_ids.json'))
            else:
                ids_old = []
            json.dump(ids_old + ids, open('task_ids.json', 'w'), indent=2)
            json.dump(
                info,
                open('video_info_good_processed1.json', 'w'),
                indent=2, sort_keys=True
            )
            req = sb.put(
                'batch/tasks/start', json=ids
            )
            ids = []
    import pdb; pdb.set_trace()


if __name__ == "__main__":
    main()
