#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import division
import sys
import os
import codecs
import argparse
from nile.api.v1 import (
    clusters,
    statface as ns,
    Record
)
import datetime
from collections import defaultdict, Counter
from pytils import get_host, bad_prefices
import json


def process_host(x):
    while x.startswith(bad_prefices):
        for p in bad_prefices:
            if x.startswith(p):
                x = x[len(p):]
    return x


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--input')
    parser.add_argument('--platform', default='touch')
    parser.add_argument('--date')
    parser.add_argument('--stat_login', '-sl')
    parser.add_argument('--stat_password', '-sp')
    args = parser.parse_args()

    ts = datetime.datetime.now().strftime('%s')

    obj = json.load(open(args.input))
    if not obj:
        sys.exit(0)

    if args.date:
        fielddate = args.date
    else:
        fielddate = datetime.date.today().strftime('%Y-%m-%d')

    cl = clusters.yt.Hahn(token=os.environ['YT_TOKEN'])

    host_dict = {process_host(x.host): 'film/serial' for x in cl.read(
        '//home/search-research/ensuetina/HOSTS_TVT/fs_by_clicks'
    )}

    host_dict.update({process_host(x.host): 'porn' for x in cl.read(
        '//home/search-research/ensuetina/HOSTS_TVT/porn_by_clicks'
    )})

    c = defaultdict(lambda: Counter())
    for el in obj:
        iv = el['inputValues']
        result = el['outputValues']['result']
        host = get_host(iv['url'])
        cats = ['_total_']
        if host in host_dict:
            cats.append(host_dict[host])
        else:
            cats.append('other')
        for cat in cats:
            for host_ in [host, '_total_']:
                c[(cat, host_)][result.lower()] += 1
                c[(cat, host_)]['shows'] += 1
    data = []
    for tup in c:
        cat = tup[0]
        host = tup[1]
        new = {
            'host': host, 'fielddate': fielddate, 'platform': args.platform,
            'category': cat
        }
        new.update(dict(c[tup]))
        data.append(new)

    cl.write(
        path='home/videolog/vdp/{}_{}'.format(fielddate, ts),
        records=[Record(**rec) for rec in data]
    )

    client = ns.StatfaceClient(
        proxy='upload.stat.yandex-team.ru',
        username=args.stat_login,
        password=args.stat_password
    )

    ns.StatfaceReport().path(
        'Video/Others/vdp_hosts'
    ).scale('daily').client(
        client
    ).data(
        data
    ).publish()


if __name__ == "__main__":
    main()
