#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import absolute_import, print_function, division
from qb2.api.v1 import (
    extractors as qe,
    filters as qf,
    typing as qt,
    resources as qr
)
from nile.api.v1 import Record


class GenerateMetrics(object):

    def _generate_metric(
        self, rec, metric_name, test_measure='sum', value=None,
        count=None, **kwargs
    ):
        return Record(
            exp_id=rec.exp_id,
            datetime=rec.datetime,
            metric_name=metric_name,
            test_measure=test_measure,
            value=getattr(rec, value if value else metric_name),
            count=getattr(rec, count) if count else None,
            **kwargs
        )


def video_player_prepare_stream(self, job):
    sample_stream = job.standalone_table(
        '//cubes/video-strm/{$start_date..$end_date}/sessions',
        name='strm_cube'
    )
    return sample_stream.qb2(
        log='generic-log',
        fields=[
            qe.log_field('view_time').with_type(int),
            qe.log_field('errors').with_type(qt.Json),
            qe.table_path('table_path').hide().with_type(str),
            qe.custom(
                'fielddate',
                lambda x: x.split('/')[-2],
                'table_path'
            ).with_type(str),
            qe.log_field('vsid').rename('user_id').with_type(str),
            self.helpers.get_exp_id_extractor(
                'exp_id',
                qe.log_field('player_version').hide().with_type(str),
                qe.custom(
                    'exp_id',
                    lambda x: 'v{}'.format(x.split('-')[-1]),
                    'player_version'
                ).with_type(str)
            ),
            qe.log_field('price').rename('raw_price').hide().with_type(int),
            qe.or_('price', 'raw_price', qr.const(0)),
            qe.log_field(
                'partner_price'
            ).rename('raw_partner_price').hide().with_type(int),
            qe.or_('partner_price', 'raw_partner_price', qr.const(0)),
        ],
        filters=[
            qf.one_of('exp_id', self.config.experiments),
            qf.or_(
                qf.nonzero('view_time'), qf.nonzero('price')
            )
        ]
    ).call(
        self.helpers.unfold_datetime, 'fielddate'
    )
